/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.actions.project;

import de.funfried.netbeans.plugins.editor.closeleftright.actions.AbstractInitialCloseBaseAction;
import java.awt.event.ActionEvent;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

abstract class AbstractProjectBaseAction
extends AbstractInitialCloseBaseAction {
    private static final long serialVersionUID = 5322225046091709258L;

    public AbstractProjectBaseAction(String name, TopComponent topComponent, boolean initialClose) {
        super(name, topComponent, initialClose);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Project project = this.getProjectByTopComponent(openProjects, this.topComponent);
        if (project == null) {
            return;
        }
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return;
        }
        for (TopComponent tc : mode.getTopComponents()) {
            Project otherProject = this.getProjectByTopComponent(openProjects, tc);
            if (!tc.isOpened() || (!this.initialClose || !Objects.equals(project, otherProject)) && (this.initialClose || Objects.equals(project, otherProject))) continue;
            tc.close();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getProjectByTopComponent(OpenProjects.getDefault().getOpenProjects(), this.topComponent) != null;
    }

    private Project getProjectByTopComponent(Project[] openProjects, TopComponent topComponent) {
        if (ArrayUtils.isEmpty((Object[])openProjects) || topComponent == null) {
            return null;
        }
        Project ret = null;
        FileObject fileObject = (FileObject)topComponent.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            for (Project project : openProjects) {
                if (!FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)fileObject) || ret != null && !FileUtil.isParentOf((FileObject)ret.getProjectDirectory(), (FileObject)project.getProjectDirectory())) continue;
                ret = project;
            }
        }
        return ret;
    }
}

