/*
 * Copyright (c) 2022 Airtango.
 * All rights reserved.
 */

package de.funfried.netbeans.plugins.editor.closeleftright.options;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;

import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

import de.funfried.netbeans.plugins.editor.closeleftright.AdditionalCloseActionFactory;

final class AdditionalCloseActionsPanel extends javax.swing.JPanel {
	private static final long serialVersionUID = 4588982272030513399L;

	private final Map<AdditionalCloseActionFactory, JCheckBox> actionChkBoxes = new HashMap<>();

	/** {@link ChangeSupport} to notify about changed preference components. */
	private final ChangeSupport changeSupport;

	AdditionalCloseActionsPanel() {
		this.changeSupport = new ChangeSupport(this);

		initComponents();
		generateComponents();
	}

	/**
	 * {@inheritDoc}
	 */
	public void addChangeListener(ChangeListener listener) {
		changeSupport.addChangeListener(listener);
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeChangeListener(ChangeListener listener) {
		changeSupport.removeChangeListener(listener);
	}

	/**
	 * Fires a change event to all registered {@link ChangeListener}s.
	 */
	protected void fireChangedListener() {
		changeSupport.fireChange();
	}

	private void updateSelectAllChkBox() {
		boolean allSelected = true;

		for (AdditionalCloseActionFactory additionalCloseActionFactory : actionChkBoxes.keySet()) {
			JCheckBox actionChkBox = actionChkBoxes.get(additionalCloseActionFactory);
			if (!actionChkBox.isSelected()) {
				allSelected = false;
				break;
			}
		}

		selectAllChkBox.setSelected(allSelected);
	}

	private void generateComponents() {
		Collection<? extends AdditionalCloseActionFactory> additionalCloseActionFactories = Lookup.getDefault().lookupAll(AdditionalCloseActionFactory.class);
		for (AdditionalCloseActionFactory additionalCloseActionFactory : additionalCloseActionFactories) {
			JCheckBox actionChkBox = new JCheckBox(additionalCloseActionFactory.getName() + (!additionalCloseActionFactory.isGlobalAction() ? " (Editor context menu only)" : ""));
			actionChkBox.addActionListener((ActionEvent e) -> {
				fireChangedListener();

				updateSelectAllChkBox();
			});

			actionChkBoxesPanel.add(actionChkBox);

			actionChkBoxes.put(additionalCloseActionFactory, actionChkBox);
		}
	}

	/**
	 * This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        selectAllChkBox = new javax.swing.JCheckBox();
        descriptionLbl = new javax.swing.JLabel();
        actionChkBoxesPanel = new javax.swing.JPanel();

        org.openide.awt.Mnemonics.setLocalizedText(selectAllChkBox, org.openide.util.NbBundle.getMessage(AdditionalCloseActionsPanel.class, "AdditionalCloseActionsPanel.selectAllChkBox.text")); // NOI18N
        selectAllChkBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectAllChkBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(descriptionLbl, org.openide.util.NbBundle.getMessage(AdditionalCloseActionsPanel.class, "AdditionalCloseActionsPanel.descriptionLbl.text")); // NOI18N

        actionChkBoxesPanel.setLayout(new javax.swing.BoxLayout(actionChkBoxesPanel, javax.swing.BoxLayout.Y_AXIS));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(actionChkBoxesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(selectAllChkBox)
                            .addComponent(descriptionLbl))
                        .addGap(0, 42, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(descriptionLbl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(selectAllChkBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(actionChkBoxesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 165, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void selectAllChkBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectAllChkBoxActionPerformed
		for (AdditionalCloseActionFactory additionalCloseActionFactory : actionChkBoxes.keySet()) {
			JCheckBox actionChkBox = actionChkBoxes.get(additionalCloseActionFactory);
			actionChkBox.setSelected(selectAllChkBox.isSelected());

			fireChangedListener();
		}
    }//GEN-LAST:event_selectAllChkBoxActionPerformed

		void load() {
			for (AdditionalCloseActionFactory additionalCloseActionFactory : actionChkBoxes.keySet()) {
				JCheckBox actionChkBox = actionChkBoxes.get(additionalCloseActionFactory);
				actionChkBox.setSelected(additionalCloseActionFactory.isActive());
			}

			updateSelectAllChkBox();
		}

		void store() {
			for (AdditionalCloseActionFactory additionalCloseActionFactory : actionChkBoxes.keySet()) {
				JCheckBox actionChkBox = actionChkBoxes.get(additionalCloseActionFactory);
				additionalCloseActionFactory.setActive(actionChkBox.isSelected());
			}
		}

		boolean valid() {
			return true;
		}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel actionChkBoxesPanel;
    private javax.swing.JLabel descriptionLbl;
    private javax.swing.JCheckBox selectAllChkBox;
    // End of variables declaration//GEN-END:variables

	}
