/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

abstract class AbstractBaseAction
extends AbstractAction {
    private final TopComponent topComponent;
    private final boolean initialClose;

    AbstractBaseAction(TopComponent topComponent, String name, boolean initialClose) {
        this.topComponent = topComponent;
        this.initialClose = initialClose;
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent unused) {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return;
        }
        boolean close = this.initialClose;
        for (TopComponent tc : mode.getTopComponents()) {
            if (tc == this.topComponent) {
                close = !close;
                continue;
            }
            if (!close || !tc.isOpened()) continue;
            tc.close();
        }
    }

    @Override
    public boolean isEnabled() {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return false;
        }
        boolean close = this.initialClose;
        for (TopComponent tc : mode.getTopComponents()) {
            if (tc == this.topComponent) {
                close = !close;
                continue;
            }
            if (!close || !tc.isOpened()) continue;
            return true;
        }
        return false;
    }
}

