/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.plugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.DependencyIndex;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.core.Message;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ValidationPlugin
extends Plugin {
    public static final String VALIDATION_PROP_FILE_NAME = "validate_base";
    public static final String PLUGIN_ID = "org.eclipse.wst.validation";
    private static ValidationPlugin _plugin;
    private static Message _message;
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static final String VALIDATOR_EXT_PT_ID = "validator";

    public ValidationPlugin() {
        if (_plugin == null) {
            _plugin = this;
        }
    }

    public static String getBundleName() {
        return ValidationPlugin.getBundlePropertyFileName();
    }

    public static String getBundlePropertyFileName() {
        return VALIDATION_PROP_FILE_NAME;
    }

    public static Message getMessage() {
        if (_message == null) {
            _message = new Message();
            _message.setBundleName(ValidationPlugin.getBundlePropertyFileName());
        }
        _message.setId(null);
        _message.setParams(null);
        _message.setTargetObject(null);
        _message.setGroupName(null);
        _message.setSeverity(4);
        return _message;
    }

    public static ValidationPlugin getPlugin() {
        return _plugin;
    }

    public static boolean isActivated() {
        Bundle bundle = Platform.getBundle(PLUGIN_ID);
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(EventManager.getManager(), 31);
        DependencyIndex di = (DependencyIndex)ValidationFramework.getDefault().getDependencyIndex();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addSaveParticipant(this, (ISaveParticipant)di);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(EventManager.getManager());
        ValidationFramework.getDefault().cancel();
        EventManager.getManager().shutdown();
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static IEclipsePreferences getPreferences(IProject project) {
        ProjectScope projectContext = new ProjectScope(project);
        return projectContext.getNode(PLUGIN_ID);
    }

    public void handleException(Throwable e) {
        this.handleException(e, 4);
    }

    public void handleException(Throwable e, int severity) {
        if (e == null) {
            return;
        }
        Status status = new Status(severity, PLUGIN_ID, e.getLocalizedMessage(), e);
        this.getLog().log(status);
    }

    public void handleProjectUnavailableError(ProjectUnavailableError e) {
        if (Tracing.isLogging()) {
            this.handleException(e);
        }
    }

    public void handleResourceUnavailableError(ResourceUnavailableError e) {
        if (Tracing.isLogging()) {
            this.handleException(e);
        }
    }

    public void logMessage(int severity, String message) {
        Status status = new Status(severity, PLUGIN_ID, message);
        this.getLog().log(status);
    }
}

