/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.PerformanceCounters;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class ValidatorJob
extends Job {
    private IProject project;
    private IWorkbenchContext helper;
    private IValidatorJob validator;

    public ValidatorJob(String name) {
        super(name);
    }

    public ValidatorJob(IValidatorJob validator, String displayName, String name, IProject project, IWorkbenchContext aHelper) {
        super(displayName);
        this.project = project;
        this.helper = aHelper;
        this.validator = validator;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ValidatorMetaData vmd;
        IStatus status;
        long cpuTime;
        long elapsed;
        IPerformanceMonitor pm;
        block109: {
            pm = ValidationFramework.getDefault().getPerformanceMonitor();
            elapsed = -1L;
            cpuTime = -1L;
            if (pm.isCollecting()) {
                elapsed = System.currentTimeMillis();
                cpuTime = Misc.getCPUTime();
            }
            monitor.beginTask("Validating", -1);
            status = IValidatorJob.OK_STATUS;
            WorkbenchReporter reporter = new WorkbenchReporter(this.project, monitor);
            vmd = ValidationRegistryReader.getReader().getValidatorMetaData(this.validator);
            try {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_STARTING_VALIDATION", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
                status = this.validator.validateInJob(this.helper, reporter);
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (ValidationException exc) {
                if (exc.getAssociatedException() != null && exc.getAssociatedException() instanceof ValidationException) {
                    ValidationException vexc = (ValidationException)exc.getAssociatedException();
                    vexc.setClassLoader(this.validator.getClass().getClassLoader());
                }
                exc.setClassLoader(this.validator.getClass().getClassLoader());
                ValidationPlugin.getPlugin().handleException(exc);
                ValidationPlugin.getPlugin().handleException(exc.getAssociatedException());
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
                if (exc.getAssociatedMessage() != null) {
                    reporter.addMessage(this.validator, exc.getAssociatedMessage());
                }
                try {
                    try {
                        this.validator.cleanup(reporter);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc2) {
                        ValidationPlugin.getPlugin().handleException(exc2);
                        String[] msgParm = new String[]{exc2.getClass().getName(), vmd.getValidatorDisplayName(), exc2.getMessage() == null ? "" : exc2.getMessage()};
                        Message message2 = ValidationPlugin.getMessage();
                        message2.setSeverity(2);
                        message2.setId("VBF_EXC_RUNTIME");
                        message2.setParams(msgParm);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message2.getText());
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception exc3) {
                                ValidationPlugin.getPlugin().handleException(exc3);
                                String[] msgParm2 = new String[]{exc3.getClass().getName(), vmd.getValidatorDisplayName(), exc3.getMessage() == null ? "" : exc3.getMessage()};
                                Message message3 = ValidationPlugin.getMessage();
                                message3.setSeverity(2);
                                message3.setId("VBF_EXC_RUNTIME");
                                message3.setParams(msgParm2);
                                reporter.addMessage(this.validator, message3);
                                IStatus iStatus2 = status = WTPCommonPlugin.createErrorStatus(message3.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus2;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc4) {
                            ValidationPlugin.getPlugin().handleException(exc4);
                            String[] msgParm = new String[]{exc4.getClass().getName(), vmd.getValidatorDisplayName(), exc4.getMessage() == null ? "" : exc4.getMessage()};
                            Message message4 = ValidationPlugin.getMessage();
                            message4.setSeverity(2);
                            message4.setId("VBF_EXC_RUNTIME");
                            message4.setParams(msgParm);
                            reporter.addMessage(this.validator, message4);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message4.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    throw throwable;
                }
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc5) {
                        ValidationPlugin.getPlugin().handleException(exc5);
                        String[] msgParm = new String[]{exc5.getClass().getName(), vmd.getValidatorDisplayName(), exc5.getMessage() == null ? "" : exc5.getMessage()};
                        Message message5 = ValidationPlugin.getMessage();
                        message5.setSeverity(2);
                        message5.setId("VBF_EXC_RUNTIME");
                        message5.setParams(msgParm);
                        reporter.addMessage(this.validator, message5);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message5.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                monitor.done();
                break block109;
            }
            catch (Exception e) {
                try {
                    ValidationPlugin.getPlugin().handleException(e);
                    String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                    monitor.subTask(mssg);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.validator.cleanup(reporter);
                        }
                        catch (OperationCanceledException e2) {
                            throw e2;
                        }
                        catch (Exception exc) {
                            ValidationPlugin.getPlugin().handleException(exc);
                            String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                            try {
                                try {
                                    this.helper.cleanup(reporter);
                                    vmd.removeHelper(this.validator);
                                }
                                catch (OperationCanceledException e3) {
                                    throw e3;
                                }
                                catch (Exception exc6) {
                                    ValidationPlugin.getPlugin().handleException(exc6);
                                    String[] msgParm3 = new String[]{exc6.getClass().getName(), vmd.getValidatorDisplayName(), exc6.getMessage() == null ? "" : exc6.getMessage()};
                                    Message message6 = ValidationPlugin.getMessage();
                                    message6.setSeverity(2);
                                    message6.setId("VBF_EXC_RUNTIME");
                                    message6.setParams(msgParm3);
                                    reporter.addMessage(this.validator, message6);
                                    IStatus iStatus3 = status = WTPCommonPlugin.createErrorStatus(message6.getText());
                                    this.helper.setProject(null);
                                    vmd.removeHelper(this.validator);
                                    this.helper = null;
                                    reporter = null;
                                    return iStatus3;
                                }
                            }
                            finally {
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                            }
                            return iStatus;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e4) {
                                throw e4;
                            }
                            catch (Exception exc) {
                                ValidationPlugin.getPlugin().handleException(exc);
                                String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                                Message message = ValidationPlugin.getMessage();
                                message.setSeverity(2);
                                message.setId("VBF_EXC_RUNTIME");
                                message.setParams(msgParm);
                                reporter.addMessage(this.validator, message);
                                IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        throw throwable2;
                    }
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e5) {
                            throw e5;
                        }
                        catch (Exception exc) {
                            ValidationPlugin.getPlugin().handleException(exc);
                            String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            reporter.addMessage(this.validator, message);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    monitor.done();
                    throw throwable;
                }
                try {
                    try {
                        this.validator.cleanup(reporter);
                    }
                    catch (OperationCanceledException e6) {
                        throw e6;
                    }
                    catch (Exception exc) {
                        ValidationPlugin.getPlugin().handleException(exc);
                        String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e7) {
                                throw e7;
                            }
                            catch (Exception exc7) {
                                ValidationPlugin.getPlugin().handleException(exc7);
                                String[] msgParm4 = new String[]{exc7.getClass().getName(), vmd.getValidatorDisplayName(), exc7.getMessage() == null ? "" : exc7.getMessage()};
                                Message message7 = ValidationPlugin.getMessage();
                                message7.setSeverity(2);
                                message7.setId("VBF_EXC_RUNTIME");
                                message7.setParams(msgParm4);
                                reporter.addMessage(this.validator, message7);
                                IStatus iStatus4 = status = WTPCommonPlugin.createErrorStatus(message7.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus4;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e8) {
                            throw e8;
                        }
                        catch (Exception exc) {
                            ValidationPlugin.getPlugin().handleException(exc);
                            String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            reporter.addMessage(this.validator, message);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    throw throwable;
                }
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e9) {
                        throw e9;
                    }
                    catch (Exception exc) {
                        ValidationPlugin.getPlugin().handleException(exc);
                        String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        reporter.addMessage(this.validator, message);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                monitor.done();
                break block109;
            }
            try {
                try {
                    this.validator.cleanup(reporter);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc) {
                    ValidationPlugin.getPlugin().handleException(exc);
                    String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                    Message message = ValidationPlugin.getMessage();
                    message.setSeverity(2);
                    message.setId("VBF_EXC_RUNTIME");
                    message.setParams(msgParm);
                    IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc8) {
                            ValidationPlugin.getPlugin().handleException(exc8);
                            String[] msgParm5 = new String[]{exc8.getClass().getName(), vmd.getValidatorDisplayName(), exc8.getMessage() == null ? "" : exc8.getMessage()};
                            Message message8 = ValidationPlugin.getMessage();
                            message8.setSeverity(2);
                            message8.setId("VBF_EXC_RUNTIME");
                            message8.setParams(msgParm5);
                            reporter.addMessage(this.validator, message8);
                            IStatus iStatus5 = status = WTPCommonPlugin.createErrorStatus(message8.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus5;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc) {
                        ValidationPlugin.getPlugin().handleException(exc);
                        String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        reporter.addMessage(this.validator, message);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                throw throwable;
            }
            try {
                try {
                    this.helper.cleanup(reporter);
                    vmd.removeHelper(this.validator);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc) {
                    ValidationPlugin.getPlugin().handleException(exc);
                    String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                    Message message = ValidationPlugin.getMessage();
                    message.setSeverity(2);
                    message.setId("VBF_EXC_RUNTIME");
                    message.setParams(msgParm);
                    reporter.addMessage(this.validator, message);
                    IStatus iStatus = status = WTPCommonPlugin.createErrorStatus(message.getText());
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                    return iStatus;
                }
            }
            finally {
                this.helper.setProject(null);
                vmd.removeHelper(this.validator);
                this.helper = null;
                reporter = null;
            }
            monitor.done();
        }
        if (pm.isCollecting()) {
            if (cpuTime != -1L) {
                cpuTime = Misc.getCPUTime() - cpuTime;
            }
            String projectName = null;
            if (this.project != null) {
                projectName = this.project.getName();
            }
            pm.add(new PerformanceCounters(vmd.getValidatorUniqueName(), vmd.getValidatorDisplayName(), projectName, -1, System.currentTimeMillis() - elapsed, cpuTime));
        }
        return status;
    }

    public boolean belongsTo(Object family) {
        return (String.valueOf(this.project.getName()) + "validators").equals(family);
    }
}

