/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValBuilderJob;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationBuilder
extends IncrementalProjectBuilder {
    public static final int NO_DELTA_CHANGE = -1;
    protected List<IProject> referencedProjects;
    protected IWorkbenchContext workbenchContext = null;
    public static final Object FAMILY_VALIDATION_JOB = new Object();

    private IProject[] getAllReferencedProjects(IProject project, Set<IProject> visitedProjects) {
        if (visitedProjects == null) {
            visitedProjects = new HashSet<IProject>();
        } else {
            if (visitedProjects.contains(project)) {
                return this.getReferencedProjects();
            }
            visitedProjects.add(project);
        }
        if (this.referencedProjects == null) {
            this.referencedProjects = new ArrayList<IProject>();
        }
        try {
            if (project.isAccessible()) {
                IProject[] refProjArray = project.getReferencedProjects();
                this.collectReferecedProject(refProjArray);
                IProject[] iProjectArray = refProjArray;
                int n = refProjArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    this.getAllReferencedProjects(refProject, visitedProjects);
                    ++n2;
                }
            }
            return this.getReferencedProjects();
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    public IWorkbenchContext getWorkbenchContext() {
        if (this.workbenchContext == null) {
            this.workbenchContext = new WorkbenchContext();
            this.workbenchContext.setProject(this.getProject());
        }
        return this.workbenchContext;
    }

    private void collectReferecedProject(IProject[] refProjArray) {
        IProject[] iProjectArray = refProjArray;
        int n = refProjArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.referencedProjects.contains(project)) {
                this.referencedProjects.add(project);
            }
            ++n2;
        }
    }

    @Override
    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        Tracing.log("ValidationBuilder-02 clean ", currentProject);
        this.newClean(monitor);
        if (currentProject == null || !currentProject.isAccessible()) {
            return;
        }
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(currentProject);
            ValidatorMetaData[] vmds = prjp.getValidators();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = vmds[i];
                WorkbenchReporter.removeAllMessages((IResource)currentProject, vmd.getValidatorNames(), null);
                ++i;
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
        }
    }

    private IProject[] getReferencedProjects() {
        IProject[] refProjArray = new IProject[this.referencedProjects.size()];
        return this.referencedProjects.toArray(refProjArray);
    }

    public IProject[] build(int kind, Map parameters, IProgressMonitor monitor) {
        IResourceDelta delta = null;
        IProject project = this.getProject();
        Tracing.log("ValidationBuilder-01 build ", kind, project);
        if (Tracing.isLogging(1)) {
            Tracing.logResourceDeltas(this.getDelta(project), 50);
        }
        IProject[] referenced = this.getAllReferencedProjects(project, null);
        if (ValidationFramework.getDefault().isSuspended(project) || ValManager.getDefault().isDisabled(project)) {
            return referenced;
        }
        try {
            boolean doFullBuild;
            this.newBuild(kind, monitor);
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            delta = this.getDelta(project);
            boolean bl = doFullBuild = kind == 6;
            if (!doFullBuild && delta == null) {
                if (this.isReferencedProjectInDelta(referenced)) {
                    this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                } else {
                    String[] msgParms = new String[]{project.getName()};
                    monitor.subTask(ResourceHandler.getExternalizedMessage("VBF_STATUS_NULL_DELTA", msgParms));
                }
                IProject[] iProjectArray = referenced;
                return iProjectArray;
            }
            if (doFullBuild) {
                this.cleanupReferencedProjectsMarkers(prjp, referenced);
                this.performFullBuild(monitor, prjp);
            } else {
                if (delta.getAffectedChildren().length == 0) {
                    if (this.isReferencedProjectInDelta(referenced)) {
                        this.cleanupReferencedProjectsMarkers(prjp, referenced);
                        this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                    }
                    IProject[] iProjectArray = referenced;
                    return iProjectArray;
                }
                EnabledIncrementalValidatorsOperation operation = new EnabledIncrementalValidatorsOperation(project, delta, true);
                operation.run(monitor);
            }
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        finally {
            this.referencedProjects = null;
        }
    }

    private void cleanupReferencedProjectsMarkers(ProjectConfiguration prjp, IProject[] referenced) {
        if (referenced == null || referenced.length == 0) {
            return;
        }
        try {
            ValidatorMetaData[] enabledValidators = prjp.getEnabledFullBuildValidators(true, false);
            HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>();
            set.addAll(Arrays.asList(enabledValidators));
            IProject[] iProjectArray = referenced;
            int n = referenced.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p.isAccessible()) {
                    ValidatorMetaData[] refEnabledValidators;
                    ProjectConfiguration refProjectCfg = ConfigurationManager.getManager().getProjectConfiguration(p);
                    ValidatorMetaData[] validatorMetaDataArray = refEnabledValidators = refProjectCfg.getEnabledFullBuildValidators(true, false);
                    int n3 = refEnabledValidators.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ValidatorMetaData vmd = validatorMetaDataArray[n4];
                        set.remove(vmd);
                        ++n4;
                    }
                    for (ValidatorMetaData vmd : set) {
                        WorkbenchReporter.removeAllMessages(p, vmd.getValidator());
                    }
                }
                ++n2;
            }
        }
        catch (Exception exc) {
            ValidationPlugin.getPlugin().logMessage(4, exc.toString());
        }
    }

    private boolean isReferencedProjectInDelta(IProject[] referenced) {
        IProject p = null;
        int i = 0;
        while (i < referenced.length) {
            p = referenced[i];
            IResourceDelta delta = this.getDelta(p);
            if (delta != null && delta.getAffectedChildren().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void performFullBuildForReferencedProjectChanged(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, true);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, false);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp, boolean onlyDependentValidators) throws InvocationTargetException {
        ValidatorMetaData[] enabledValidators = prjp.getEnabledFullBuildValidators(true, onlyDependentValidators);
        if (enabledValidators != null && enabledValidators.length > 0) {
            Set<ValidatorMetaData> enabledValidatorsSet = InternalValidatorManager.wrapInSet(enabledValidators);
            EnabledValidatorsOperation op = new EnabledValidatorsOperation(this.getProject(), enabledValidatorsSet, true);
            op.run(monitor);
        }
    }

    private void newBuild(int kind, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        IProject project = this.getProject();
        switch (kind) {
            case 9: 
            case 10: {
                delta = this.getDelta(project);
            }
        }
        ValBuilderJob.validateProject(project, delta, kind);
    }

    private void newClean(IProgressMonitor monitor) throws CoreException {
        ValManager.getDefault().clean(this.getProject(), monitor);
    }
}

