/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorExtensionReader {
    private static ValidatorExtensionReader _me = new ValidatorExtensionReader();

    public static ValidatorExtensionReader getDefault() {
        return _me;
    }

    private ValidatorExtensionReader() {
    }

    Collection<Validator> process() {
        Validator v;
        String id;
        IConfigurationElement validator;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension ext;
        HashMap<String, Validator> map = new HashMap<String, Validator>(100);
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return map.values();
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ext = iExtensionArray[n4];
            iConfigurationElementArray = ext.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                validator = iConfigurationElementArray[n];
                id = ext.getUniqueIdentifier();
                if (Tracing.isEnabled(id) && (v = this.processValidator(validator, id, ext.getLabel(), null)) != null) {
                    map.put(v.getId(), v);
                }
                ++n;
            }
            ++n4;
        }
        extensionPoint = this.getExtensionPointExclude();
        if (extensionPoint != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n3 = iExtensionArray.length;
            n4 = 0;
            while (n4 < n3) {
                ext = iExtensionArray[n4];
                iConfigurationElementArray = ext.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    validator = iConfigurationElementArray[n];
                    id = validator.getAttribute("id");
                    v = (Validator)map.get(id);
                    Validator.V2 v2 = null;
                    if (v != null) {
                        v2 = v.asV2Validator();
                    }
                    if (v2 == null) {
                        String msg = ext.getUniqueIdentifier() != null ? NLS.bind("Plug-in configuration error, extension \"{0}\" references validator id \"{1}\" but this id does not exist.", ext.getUniqueIdentifier(), id) : NLS.bind("Plug-in configuration error, extension in \"{0}\" references validator id \"{1}\" but this id does not exist.", ext.getNamespaceIdentifier(), id);
                        CoreException ex = new CoreException(new Status(4, "org.eclipse.wst.validation", msg));
                        ValidationPlugin.getPlugin().handleException(ex);
                    } else {
                        IConfigurationElement[] iConfigurationElementArray2 = validator.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement exclude = iConfigurationElementArray2[n6];
                            FilterGroup fg = null;
                            try {
                                fg = this.createFilterGroup(exclude);
                            }
                            catch (Exception e) {
                                ValidationPlugin.getPlugin().handleException(e);
                                IContributor contrib = validator.getContributor();
                                String message = NLS.bind(ValMessages.ErrConfig, contrib.getName());
                                ValidationPlugin.getPlugin().logMessage(4, message);
                            }
                            if (fg != null && fg.isExclude()) {
                                this.mergeExcludeGroup(v2, fg);
                            }
                            ++n6;
                        }
                    }
                    ++n;
                }
                ++n4;
            }
        }
        for (String removedValidator : this.getRemovedValidators()) {
            if (removedValidator == null) continue;
            map.remove(removedValidator);
        }
        return map.values();
    }

    private void mergeExcludeGroup(Validator.V2 v2, FilterGroup fg) {
        FilterGroup existing = null;
        FilterGroup[] filterGroupArray = v2.getGroups();
        int n = filterGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterGroup group = filterGroupArray[n2];
            if (group.isExclude()) {
                existing = group;
                break;
            }
            ++n2;
        }
        if (existing == null) {
            v2.add(fg);
        } else {
            LinkedList<FilterRule> rules = new LinkedList<FilterRule>();
            FilterRule[] filterRuleArray = existing.getRules();
            int n3 = filterRuleArray.length;
            n = 0;
            while (n < n3) {
                FilterRule rule = filterRuleArray[n];
                rules.add(rule);
                ++n;
            }
            filterRuleArray = fg.getRules();
            n3 = filterRuleArray.length;
            n = 0;
            while (n < n3) {
                FilterRule rule = filterRuleArray[n];
                rules.add(rule);
                ++n;
            }
            FilterRule[] filterRules = new FilterRule[rules.size()];
            rules.toArray(filterRules);
            FilterGroup merged = FilterGroup.create(existing.isExclude(), filterRules);
            v2.replaceFilterGroup(existing, merged);
        }
    }

    private Validator processValidator(IConfigurationElement validator, String id, String label, IProject project) {
        Validator.V2 v = null;
        try {
            IConfigurationElement[] children;
            v = Validator.create(validator, project).asV2Validator();
            v.setLevel(Validator.Level.Extension);
            v.setId(id);
            v.setName(label);
            v.setDescription(validator.getAttribute("description"));
            v.setBuildValidation(this.getAttribute(validator, "build", true));
            v.setManualValidation(this.getAttribute(validator, "manual", true));
            v.setMarkerId(validator.getAttribute("markerId"));
            v.setVersion(this.getAttribute(validator, "version", 1));
            v.setSourceId(validator.getAttribute("sourceid"));
            IConfigurationElement[] iConfigurationElementArray = children = validator.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                this.processIncludeAndExcludeElement(v, child);
                ++n2;
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            IContributor contrib = validator.getContributor();
            String message = NLS.bind(ValMessages.ErrConfig, contrib.getName());
            ValidationPlugin.getPlugin().logMessage(4, message);
        }
        return v;
    }

    public List<MessageSeveritySetting> addMessages(Validator v) {
        LinkedList<MessageSeveritySetting> list = new LinkedList<MessageSeveritySetting>();
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return list;
        }
        IExtension ext = extensionPoint.getExtension(v.getId());
        if (ext == null) {
            return list;
        }
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = elem.getChildren("messageCategory");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray2[n4];
                list.add(this.processMessage(ce));
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint("org.eclipse.wst.validation", "validatorV2");
    }

    private IExtensionPoint getExtensionPointExclude() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint("org.eclipse.wst.validation", "exclude");
    }

    private List<String> getRemovedValidators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "removeV2Validator");
        LinkedList<String> val = new LinkedList<String>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement validator = iConfigurationElementArray[n4];
                val.add(validator.getAttribute("validatorId"));
                ++n4;
            }
            ++n2;
        }
        return val;
    }

    private MessageSeveritySetting processMessage(IConfigurationElement ce) {
        String s = ce.getAttribute("severity");
        MessageSeveritySetting.Severity sev = null;
        if ("error".equals(s)) {
            sev = MessageSeveritySetting.Severity.Error;
        } else if ("warning".equals(s)) {
            sev = MessageSeveritySetting.Severity.Warning;
        } else if ("ignore".equals(s)) {
            sev = MessageSeveritySetting.Severity.Ignore;
        }
        return new MessageSeveritySetting(ce.getAttribute("id"), ce.getAttribute("label"), sev);
    }

    private void processIncludeAndExcludeElement(Validator.V2 v, IConfigurationElement group) {
        FilterGroup fg = this.createFilterGroup(group);
        if (fg != null) {
            v.add(fg);
        }
    }

    private FilterGroup createFilterGroup(IConfigurationElement group) {
        String name = group.getName();
        if (!FilterGroup.isKnownName(name)) {
            return null;
        }
        IConfigurationElement[] rules = group.getChildren("rules");
        LinkedList<FilterRule> list = new LinkedList<FilterRule>();
        int i = 0;
        while (i < rules.length) {
            IConfigurationElement[] r = rules[i].getChildren();
            int j = 0;
            while (j < r.length) {
                list.add(this.processRule(r[j]));
                ++j;
            }
            ++i;
        }
        FilterRule[] filterRules = new FilterRule[list.size()];
        list.toArray(filterRules);
        return FilterGroup.create(name, filterRules);
    }

    private FilterRule processRule(IConfigurationElement rule) {
        FilterRule fr = FilterRule.create(rule);
        if (fr == null) {
            String contributor = "";
            String name = "";
            try {
                contributor = rule.getDeclaringExtension().getContributor().getName();
                name = rule.getName();
            }
            catch (Exception exception) {}
            throw new IllegalStateException(NLS.bind(ValMessages.ErrFilterRule, contributor, name));
        }
        return fr;
    }

    Validator[] migrate(Validator[] validators, IProject project) {
        int count = 0;
        HashMap<String, Validator> map = new HashMap<String, Validator>(validators.length);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            map.put(v.getId(), v);
            ++n2;
        }
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        n = 0;
        while (n < n3) {
            IExtension ext = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n4 = iConfigurationElementArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Validator old;
                IConfigurationElement validator = iConfigurationElementArray[n5];
                Validator v = this.processValidator(validator, ext.getUniqueIdentifier(), ext.getLabel(), project);
                if (v != null && ((old = (Validator)map.get(v.getId())) == null || old.getVersion() < v.getVersion())) {
                    map.put(v.getId(), v);
                    ++count;
                }
                ++n5;
            }
            ++n;
        }
        if (count > 0) {
            Validator[] vals = new Validator[map.size()];
            map.values().toArray(vals);
            return vals;
        }
        return null;
    }

    private boolean getAttribute(IConfigurationElement element, String name, boolean dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        if ("true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v)) {
            return false;
        }
        return dft;
    }

    private int getAttribute(IConfigurationElement element, String name, int dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return dft;
        }
    }
}

