/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationRunner
implements IWorkspaceRunnable {
    private Map<IProject, Set<IResource>> _projects;
    private ValType _valType;
    private ValOperation _valOperation;

    public static ValOperation validate(Map<IProject, Set<IResource>> projects, ValType valType, IProgressMonitor monitor, boolean atomic) throws CoreException {
        ValidationRunner me = new ValidationRunner(projects, valType);
        if (atomic) {
            ResourcesPlugin.getWorkspace().run(me, null, 1, monitor);
        } else {
            me.execute(monitor);
        }
        return me._valOperation;
    }

    public static ValOperation validate(IFile file, ValType valType, IProgressMonitor monitor, boolean atomic) throws CoreException {
        HashMap<IProject, Set<IResource>> map = new HashMap<IProject, Set<IResource>>(1);
        HashSet<IFile> set = new HashSet<IFile>(1);
        set.add(file);
        map.put(file.getProject(), set);
        return ValidationRunner.validate(map, valType, monitor, atomic);
    }

    private ValidationRunner(Map<IProject, Set<IResource>> projects, ValType valType) {
        this._projects = projects;
        this._valType = valType;
    }

    private ValOperation execute(IProgressMonitor monitor) {
        this._valOperation = new ValOperation();
        ValManager manager = ValManager.getDefault();
        IValidatorVisitor startingVisitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.validationStarting(project, operation.getState(), monitor);
            }
        };
        IValidatorVisitor finishedVisitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.validationFinishing(project, operation.getState(), monitor);
            }
        };
        manager.accept(startingVisitor, null, this._valType, this._valOperation, monitor);
        for (Map.Entry<IProject, Set<IResource>> me : this._projects.entrySet()) {
            if (monitor.isCanceled()) {
                this._valOperation.setCanceled(true);
                return this._valOperation;
            }
            IProject project = me.getKey();
            manager.accept(startingVisitor, project, this._valType, this._valOperation, monitor);
            for (IResource resource : me.getValue()) {
                try {
                    manager.validate(project, resource, 0, this._valType, 9, this._valOperation, monitor);
                }
                catch (ResourceUnavailableError resourceUnavailableError) {}
            }
            manager.accept(finishedVisitor, project, this._valType, this._valOperation, monitor);
        }
        manager.accept(finishedVisitor, null, this._valType, this._valOperation, monitor);
        return this._valOperation;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        this.execute(monitor);
    }
}

