/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class Tracing {
    private static final DateFormat _df = new SimpleDateFormat("HH:mm:ss.SSSS");
    private static final boolean _isLogging = ValidationPlugin.getPlugin().isDebugging();
    private static final boolean _traceMatches = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/matches");
    private static final boolean _traceV1 = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/v1");
    private static final String _extraValDetail = Platform.getDebugOption("org.eclipse.wst.validation/extraValDetail");
    private static final int _tracingLevel;
    private static final String _filter;

    static {
        _filter = Platform.getDebugOption("org.eclipse.wst.validation/filter/allExcept");
        String traceLevel = Platform.getDebugOption("org.eclipse.wst.validation/trace/level");
        int level = 0;
        if (traceLevel != null) {
            try {
                level = Integer.parseInt(traceLevel);
            }
            catch (Exception exception) {}
        }
        _tracingLevel = level;
    }

    public static boolean isEnabled(String validatorId) {
        if (_filter == null || _filter.length() == 0) {
            return true;
        }
        return _filter.equals(validatorId);
    }

    public static boolean isLogging() {
        return _isLogging;
    }

    public static boolean isLogging(int level) {
        if (_isLogging) {
            return _tracingLevel >= level;
        }
        return false;
    }

    public static boolean isTraceMatches() {
        return _traceMatches;
    }

    public static boolean isTraceV1() {
        return _traceV1;
    }

    public static boolean matchesExtraDetail(String validatorId) {
        if (_extraValDetail == null) {
            return false;
        }
        return _extraValDetail.equals(validatorId);
    }

    public static void log(String line) {
        if (Tracing.isLogging()) {
            Tracing.write(line);
        }
    }

    public static void log(Object ... parts) {
        if (Tracing.isLogging()) {
            StringBuffer b = new StringBuffer(200);
            Object[] objectArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                b.append(p);
                ++n2;
            }
            Tracing.write(b.toString());
        }
    }

    public static void write(String line) {
        System.err.println(Tracing.timestampIt(line));
    }

    public static String timestampIt(String line) {
        Date date = new Date();
        String thread = Thread.currentThread().getName();
        return String.valueOf(_df.format(date)) + " " + thread + " " + line;
    }

    public static void log(StringBuffer b) {
        Tracing.log(b.toString());
        b.setLength(0);
    }

    public static void setForceLogging(boolean forceLogging) {
    }

    public static void logResourceDeltas(IResourceDelta delta, int maxNumber) {
        if (!Tracing.isLogging()) {
            return;
        }
        if (delta == null) {
            Tracing.log("  ResourceDelta: null");
        } else {
            DeltaLogger logger = new DeltaLogger(maxNumber);
            try {
                delta.accept(logger);
                if (logger.getCount() == 0) {
                    Tracing.log("  ResourceDelta: no deltas");
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static final class DeltaLogger
    implements IResourceDeltaVisitor {
        private final int _max;
        private int _count;
        private StringBuffer _b = new StringBuffer(200);

        public int getCount() {
            return this._count;
        }

        public DeltaLogger(int max) {
            this._max = max;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this._count++ > this._max) {
                return false;
            }
            int kind = delta.getKind();
            String type = "unknown";
            switch (kind) {
                case 1: {
                    type = "Added";
                    break;
                }
                case 4: {
                    type = "Changed";
                    break;
                }
                case 2: {
                    type = "Removed";
                }
            }
            this._b.append("  ResourceDelta ");
            this._b.append(type);
            this._b.append(' ');
            this._b.append(delta.getResource());
            Tracing.log(this._b);
            return true;
        }
    }
}

