/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.IProjectChangeListener;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class PreferencesWrapper {
    private static final WrapperManger _manager = new WrapperManger();

    public static PreferencesWrapper getPreferences(IProject project, Boolean persistent) {
        return _manager.get(project, persistent);
    }

    public abstract String[] childrenNames() throws BackingStoreException;

    public void flush() throws BackingStoreException {
    }

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract String get(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract long getLong(String var1, long var2);

    public abstract String[] keys() throws BackingStoreException;

    public boolean isPersistent() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public abstract void put(String var1, String var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract void putLong(String var1, long var2);

    public abstract void putInt(String var1, int var2);

    public abstract PreferencesWrapper node(String var1);

    public abstract boolean nodeExists();

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public static final class PreferencesWrapperPersistent
    extends PreferencesWrapper {
        private final Preferences _preferences;

        public PreferencesWrapperPersistent(Preferences preferences) {
            this._preferences = preferences;
        }

        public String[] childrenNames() throws BackingStoreException {
            return this._preferences.childrenNames();
        }

        public void flush() throws BackingStoreException {
            this._preferences.flush();
        }

        public String get(String key, String def) {
            return this._preferences.get(key, def);
        }

        public boolean getBoolean(String key, boolean def) {
            return this._preferences.getBoolean(key, def);
        }

        public int getInt(String key, int def) {
            return this._preferences.getInt(key, def);
        }

        public long getLong(String key, long def) {
            return this._preferences.getLong(key, def);
        }

        public String[] keys() throws BackingStoreException {
            return this._preferences.keys();
        }

        public boolean isPersistent() {
            return true;
        }

        public void put(String key, String value) {
            this._preferences.put(key, value);
        }

        public PreferencesWrapper node(String path) {
            Preferences prefs = this._preferences.node(path);
            return new PreferencesWrapperPersistent(prefs);
        }

        public boolean nodeExists() {
            try {
                return this.nodeExists("");
            }
            catch (BackingStoreException backingStoreException) {
                return false;
            }
        }

        public boolean nodeExists(String pathName) throws BackingStoreException {
            return this._preferences.nodeExists(pathName);
        }

        public void putBoolean(String key, boolean value) {
            this._preferences.putBoolean(key, value);
        }

        public void putLong(String key, long value) {
            this._preferences.putLong(key, value);
        }

        public void putInt(String key, int value) {
            this._preferences.putInt(key, value);
        }

        public void removeNode() throws BackingStoreException {
            this._preferences.removeNode();
        }
    }

    public static final class PreferencesWrapperTransient
    extends PreferencesWrapper {
        private final PreferencesWrapperTransient _parent;
        private final Map<String, String> _children = Collections.synchronizedMap(new HashMap(10));
        private final Map<String, PreferencesWrapperTransient> _nodes = Collections.synchronizedMap(new HashMap(10));

        public PreferencesWrapperTransient(PreferencesWrapperTransient parent) {
            this._parent = parent;
        }

        public PreferencesWrapperTransient(PreferencesWrapper pw, PreferencesWrapperTransient parent) {
            this._parent = parent;
            try {
                String[] stringArray = pw.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.put(key, pw.get(key, null));
                    ++n2;
                }
                stringArray = pw.childrenNames();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String nodeName = stringArray[n2];
                    PreferencesWrapper p = pw.node(nodeName);
                    PreferencesWrapperTransient pwt = new PreferencesWrapperTransient(p, this);
                    this._nodes.put(nodeName, pwt);
                    ++n2;
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }

        public String[] childrenNames() throws BackingStoreException {
            Set<String> keys = this._nodes.keySet();
            String[] names = new String[keys.size()];
            keys.toArray(names);
            return names;
        }

        public String get(String key, String def) {
            String value = this._children.get(key);
            if (value != null) {
                return value;
            }
            return def;
        }

        public boolean getBoolean(String key, boolean def) {
            String value = this._children.get(key);
            if (value == null) {
                return def;
            }
            if ("true".equals(value = value.toLowerCase())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            return def;
        }

        public int getInt(String key, int def) {
            String value = this._children.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }

        public long getLong(String key, long def) {
            String value = this._children.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }

        public boolean isTransient() {
            return true;
        }

        public synchronized String[] keys() throws BackingStoreException {
            String[] keys = new String[this._children.size()];
            this._children.keySet().toArray(keys);
            return keys;
        }

        public synchronized PreferencesWrapper node(String name) {
            PreferencesWrapperTransient pw = this._nodes.get(name);
            if (pw != null) {
                return pw;
            }
            pw = new PreferencesWrapperTransient(this);
            this._nodes.put(name, pw);
            return pw;
        }

        public boolean nodeExists() {
            return true;
        }

        public boolean nodeExists(String key) throws BackingStoreException {
            PreferencesWrapperTransient pw = this._nodes.get(key);
            return pw != null;
        }

        public void put(String key, String value) {
            this._children.put(key, value);
        }

        public void putBoolean(String key, boolean bool) {
            String value = bool ? "true" : "false";
            this._children.put(key, value);
        }

        public void putInt(String key, int value) {
            this._children.put(key, String.valueOf(value));
        }

        public void putLong(String key, long value) {
            this._children.put(key, String.valueOf(value));
        }

        public void removeNode() throws BackingStoreException {
            if (this._parent == null) {
                return;
            }
            this._parent.removeNode(this);
        }

        private synchronized void removeNode(PreferencesWrapperTransient node) {
            String key = null;
            for (Map.Entry<String, PreferencesWrapperTransient> me : this._nodes.entrySet()) {
                if (!me.getValue().equals(node)) continue;
                key = me.getKey();
                break;
            }
            if (key != null) {
                this._nodes.remove(key);
            }
        }
    }

    private static final class WrapperManger
    implements IProjectChangeListener {
        private final Map<IProject, PreferencesWrapper> _map = new HashMap<IProject, PreferencesWrapper>(20);
        private final AtomicReference<PreferencesWrapper> _global = new AtomicReference();

        private WrapperManger() {
            EventManager.getManager().addProjectChangeListener(this);
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            EventManager.getManager().removeProjectChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PreferencesWrapper get(IProject project, Boolean persistent) {
            if (project == null) {
                return this.globalPreferences(persistent);
            }
            PreferencesWrapper pw = null;
            Map<IProject, PreferencesWrapper> map = this._map;
            synchronized (map) {
                pw = this._map.get(project);
            }
            if (pw != null && (persistent == null || persistent.booleanValue() == pw.isPersistent())) {
                return pw;
            }
            if (pw == null) {
                pw = new PreferencesWrapperPersistent(ValidationPlugin.getPreferences(project));
            }
            if (persistent != null && persistent.booleanValue() && pw.isTransient()) {
                pw = new PreferencesWrapperPersistent(ValidationPlugin.getPreferences(project));
            }
            if (persistent != null && !persistent.booleanValue() && pw.isPersistent()) {
                pw = new PreferencesWrapperTransient(pw, null);
            }
            map = this._map;
            synchronized (map) {
                this._map.put(project, pw);
            }
            return pw;
        }

        private PreferencesWrapper globalPreferences(Boolean persistent) {
            PreferencesWrapper newPW;
            PreferencesWrapper pw = this._global.get();
            while (pw == null) {
                newPW = this.createGlobal(persistent);
                pw = this._global.compareAndSet(null, newPW) ? newPW : this._global.get();
            }
            while (persistent != null && !persistent.booleanValue() && !pw.isTransient()) {
                newPW = new PreferencesWrapperTransient(pw, null);
                pw = this._global.compareAndSet(pw, newPW) ? newPW : this._global.get();
            }
            while (persistent != null && persistent.booleanValue() && !pw.isPersistent()) {
                newPW = new PreferencesWrapperPersistent(ValidationFramework.getDefault().getPreferenceStore());
                pw = this._global.compareAndSet(pw, newPW) ? newPW : this._global.get();
            }
            return pw;
        }

        private PreferencesWrapper createGlobal(Boolean persistent) {
            PreferencesWrapperPersistent pw = new PreferencesWrapperPersistent(ValidationFramework.getDefault().getPreferenceStore());
            if (persistent == null || persistent.booleanValue()) {
                return pw;
            }
            return new PreferencesWrapperTransient(pw, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectChanged(IProject project, int type) {
            int interested = 6;
            if ((type & interested) != 0) {
                Map<IProject, PreferencesWrapper> map = this._map;
                synchronized (map) {
                    this._map.remove(project);
                }
            }
        }
    }
}

