/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalValidatorManager {
    private static InternalValidatorManager _inst = null;
    private static final String OP_GROUP = "ValidationOperation";

    private InternalValidatorManager() {
    }

    public static InternalValidatorManager getManager() {
        if (_inst == null) {
            _inst = new InternalValidatorManager();
        }
        return _inst;
    }

    public static Set<ValidatorMetaData> wrapInSet(ValidatorMetaData[] vmds) {
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        if (vmds == null || vmds.length == 0) {
            return result;
        }
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            result.add(vmd);
            ++n2;
        }
        return result;
    }

    public void addInternalErrorTask(IProject project, ValidatorMetaData vmd, Throwable exc) {
        this.addOperationTask(project, vmd, "VBF_EXC_INTERNAL", new String[]{project.getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()});
    }

    public void addOperationTask(IProject project, ValidatorMetaData vmd, String messageId, String[] parms) {
        Message message = ValidationPlugin.getMessage();
        message.setSeverity(4);
        message.setId(messageId);
        message.setParams(parms);
        message.setGroupName(OP_GROUP);
        WorkbenchReporter.addMessage((IResource)project, vmd.getValidatorUniqueName(), this.getClass().getClassLoader(), (IMessage)message);
    }

    public void removeOperationTasks(IProject project, ValidatorMetaData vmd) {
        WorkbenchReporter.removeMessageSubset((IResource)project, vmd.getValidatorUniqueName(), OP_GROUP);
    }

    public String[] getValidatorNames(ValidatorMetaData[] vmds) {
        HashSet<String> temp = new HashSet<String>();
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            String[] stringArray = vmd.getValidatorNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                temp.add(name);
                ++n4;
            }
            ++n2;
        }
        String[] vmdNames = new String[temp.size()];
        temp.toArray(vmdNames);
        return vmdNames;
    }

    public String[] getValidatorNames(Collection<ValidatorMetaData> vmds) {
        HashSet<String> temp = new HashSet<String>();
        for (ValidatorMetaData vmd : vmds) {
            String[] stringArray = vmd.getValidatorNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                temp.add(name);
                ++n2;
            }
        }
        String[] vmdNames = new String[temp.size()];
        temp.toArray(vmdNames);
        return vmdNames;
    }

    public ValidatorMetaData[] getValidatorsForExtension(IProject project, String fileExtension) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getValidators();
            StringBuffer buffer = new StringBuffer(project.getName());
            buffer.append('/');
            buffer.append(fileExtension);
            Path path = new Path(buffer.toString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            ValidatorMetaData[] temp = new ValidatorMetaData[vmds.length];
            int count = 0;
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = vmds[i];
                if (vmd.isApplicableTo(file)) {
                    temp[count++] = vmd;
                }
                ++i;
            }
            ValidatorMetaData[] result = new ValidatorMetaData[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            if (e.getTargetException() != null) {
                ValidationPlugin.getPlugin().handleException(e.getTargetException());
            }
            return new ValidatorMetaData[0];
        }
    }

    public String[] getValidatorNamesForExtension(IProject project, String fileExtension) {
        ValidatorMetaData[] vmds = this.getValidatorsForExtension(project, fileExtension);
        String[] names = new String[vmds.length];
        int i = 0;
        while (i < names.length) {
            names[i] = vmds[i].getValidatorUniqueName();
            ++i;
        }
        return names;
    }
}

