/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class GlobalConfiguration
extends ValidationConfiguration {
    static final boolean PREF_PROJECTS_CAN_OVERRIDE_DEFAULT = true;
    static final boolean PREF_SAVE_AUTOMATICALLY_DEFAULT = false;
    private boolean _canProjectsOverride = GlobalConfiguration.getCanProjectsOverrideDefault();
    private boolean _saveAutomatically = GlobalConfiguration.getSaveAutomaticallyDefault();

    public GlobalConfiguration(IWorkspaceRoot root) throws InvocationTargetException {
        super(root, GlobalConfiguration.convertToArray(ValidationRegistryReader.getReader().getAllValidators()));
    }

    public GlobalConfiguration(GlobalConfiguration original) throws InvocationTargetException {
        super(original.getResource());
        original.copyTo(this);
    }

    public boolean canProjectsOverride() {
        return this._canProjectsOverride;
    }

    public void setCanProjectsOverride(boolean can) {
        this._canProjectsOverride = can;
    }

    public boolean getSaveAutomatically() {
        return this._saveAutomatically;
    }

    public void setSaveAutomatically(boolean save) {
        this._saveAutomatically = save;
    }

    public void resetToDefault() throws InvocationTargetException {
        this.setDisableAllValidation(GlobalConfiguration.getDisableValidationDefault());
        this.setEnabledValidators(GlobalConfiguration.getEnabledValidatorsDefault());
        this.setEnabledManualValidators(this.getManualEnabledValidators());
        this.setEnabledBuildValidators(this.getBuildEnabledValidators());
        this.setCanProjectsOverride(GlobalConfiguration.getCanProjectsOverrideDefault());
        this.setSaveAutomatically(GlobalConfiguration.getSaveAutomaticallyDefault());
        this.setDefaultDelegates(this.getValidators());
    }

    protected IMarker[] getMarker() {
        try {
            IWorkspaceRoot root = GlobalConfiguration.getRoot();
            IMarker[] markers = root.findMarkers("org.eclipse.wst.validation.preferencemarker", false, 1);
            if (markers.length == 1) {
                return markers;
            }
            return null;
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    protected void load(IMarker[] marker) throws InvocationTargetException {
        try {
            IWorkspaceRoot root = GlobalConfiguration.getRoot();
            if (marker == null) {
                this.resetToDefault();
                return;
            }
            IMarker rootMarker = marker[0];
            String enabledManualValidators = (String)this.getValue(rootMarker, "enabledManualValidatorList");
            this.setEnabledManualValidators(GlobalConfiguration.getStringAsEnabledElementsArray(enabledManualValidators));
            String enabledBuildValidators = (String)this.getValue(rootMarker, "enabledBuildValidatorList");
            this.setEnabledManualValidators(GlobalConfiguration.getStringAsEnabledElementsArray(enabledBuildValidators));
            this.setCanProjectsOverride(this.getValue(rootMarker, "projectsCanOverride", true));
            root.getWorkspace().deleteMarkers(marker);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    protected void copyTo(GlobalConfiguration gp) throws InvocationTargetException {
        super.copyTo(gp);
        gp.setCanProjectsOverride(this.canProjectsOverride());
        gp.setSaveAutomatically(this.getSaveAutomatically());
    }

    public static boolean getCanProjectsOverrideDefault() {
        return true;
    }

    public static boolean getSaveAutomaticallyDefault() {
        return false;
    }

    public void deserialize(String storedConfiguration) throws InvocationTargetException {
        super.deserialize(storedConfiguration);
        if (storedConfiguration != null && storedConfiguration.length() > 0) {
            int canOverrideIndex = storedConfiguration.indexOf("projectsCanOverride");
            int disableAllValidationIndex = storedConfiguration.indexOf("disableAllValidation");
            int saveAutomaticallyIndex = storedConfiguration.indexOf("saveAutomatically");
            if (disableAllValidationIndex != -1) {
                String canOverride = storedConfiguration.substring(canOverrideIndex + "projectsCanOverride".length(), disableAllValidationIndex);
                this.setCanProjectsOverride(Boolean.valueOf(canOverride));
            }
            if (saveAutomaticallyIndex != -1) {
                String saveAutomatically = storedConfiguration.substring(saveAutomaticallyIndex + "saveAutomatically".length(), canOverrideIndex);
                this.setSaveAutomatically(Boolean.valueOf(saveAutomatically));
            }
        }
    }

    public String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("saveAutomatically");
        buffer.append(String.valueOf(this.getSaveAutomatically()));
        buffer.append("projectsCanOverride");
        buffer.append(String.valueOf(this.canProjectsOverride()));
        buffer.append(super.serialize());
        return buffer.toString();
    }
}

