/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DisabledValidatorManager
implements IValChangedListener {
    private static final AtomicInteger _counter = new AtomicInteger();
    private static final int CacheSize = 5;
    private final Map<IResource, LRUSet> _map = Collections.synchronizedMap(new HashMap(5));

    public static DisabledValidatorManager getDefault() {
        return Singleton.disabledValidatorManager;
    }

    private DisabledValidatorManager() {
        ValPrefManagerProject.addListener(this);
    }

    public void dispose() {
        ValPrefManagerProject.removeListener(this);
    }

    public Set<Validator> getDisabledValidatorsFor(IResource resource) {
        LRUSet set = this._map.get(resource);
        if (set != null) {
            set.counter = _counter.getAndIncrement();
            return set.validators;
        }
        DisabledValidationFinder dvf = new DisabledValidationFinder();
        Set<Validator> vset = dvf.findDisabledValidatorsFor(resource);
        this.insert(resource, vset);
        return vset;
    }

    private synchronized void insert(IResource resource, Set<Validator> vset) {
        if (this._map.size() >= 5) {
            IResource oldest = null;
            int current = Integer.MAX_VALUE;
            for (Map.Entry<IResource, LRUSet> me : this._map.entrySet()) {
                if (me.getValue().counter >= current) continue;
                oldest = me.getKey();
                current = me.getValue().counter;
            }
            this._map.remove(oldest);
        }
        LRUSet set = new LRUSet();
        set.counter = _counter.getAndIncrement();
        set.validators = vset;
        this._map.put(resource, set);
    }

    @Override
    public void validatorsForProjectChanged(IProject project, boolean configSettingChanged) {
        this._map.clear();
    }

    /* synthetic */ DisabledValidatorManager(DisabledValidatorManager disabledValidatorManager) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DisabledValidationFinder
    implements IValidatorVisitor {
        private Map<String, Validator> _validators;

        private DisabledValidationFinder() {
        }

        @Override
        public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
            this._validators.remove(validator.getId());
        }

        public Set<Validator> findDisabledValidatorsFor(IResource resource) {
            ValManager vm = ValManager.getDefault();
            Validator[] vals = vm.getValidatorsCopy();
            this._validators = new HashMap<String, Validator>(100);
            Validator[] validatorArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                this._validators.put(v.getId(), v);
                ++n2;
            }
            IProject project = resource.getProject();
            vm.accept(this, project, resource, ValType.Build, new ValOperation(), new NullProgressMonitor());
            HashSet<Validator> set = new HashSet<Validator>(this._validators.size());
            set.addAll(this._validators.values());
            return set;
        }
    }

    private static final class LRUSet {
        int counter;
        Set<Validator> validators;

        private LRUSet() {
        }
    }

    private static final class Singleton {
        static final DisabledValidatorManager disabledValidatorManager = new DisabledValidatorManager(null);

        private Singleton() {
        }
    }
}

