/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.IProjectChangeListener;
import org.eclipse.wst.validation.internal.PreferencesWrapper;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisabledResourceManager
implements IProjectChangeListener {
    private Set<IPath> _disabled = new HashSet<IPath>(100);
    private Set<IProject> _loadedProjects = new HashSet<IProject>(40);

    public static DisabledResourceManager getDefault() {
        return Singleton.disabledResourceManager;
    }

    private DisabledResourceManager() {
        EventManager.getManager().addProjectChangeListener(this);
    }

    public void disableValidation(IResource resource) {
        if (this.isDisabled(resource)) {
            return;
        }
        HashSet<IPath> copy = new HashSet<IPath>(this._disabled.size() + 2);
        copy.addAll(this._disabled);
        copy.add(resource.getFullPath());
        this.save(copy, resource.getProject());
        this._disabled = copy;
    }

    public void enableValidation(IResource resource) {
        if (!this.isDisabled(resource)) {
            return;
        }
        HashSet<IPath> copy = new HashSet<IPath>(this._disabled.size() + 2);
        copy.addAll(this._disabled);
        copy.remove(resource.getFullPath());
        this.save(copy, resource.getProject());
        this._disabled = copy;
    }

    private void save(Set<IPath> disabled, IProject project) {
        Serializer ser = new Serializer(200);
        String name = project.getName();
        for (IPath fullPath : disabled) {
            if (!name.equals(fullPath.segment(0))) continue;
            ser.put(fullPath.removeFirstSegments(1).toPortableString());
        }
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(project, null);
        prefs.put("disabled", ser.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void load(IProject project) {
        HashSet<IPath> copy = new HashSet<IPath>(this._disabled.size() + 10);
        copy.addAll(this._disabled);
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(project, null);
        String disabled = prefs.get("disabled", "");
        if (disabled.length() > 0) {
            Deserializer des = new Deserializer(disabled);
            IPath projectPath = project.getFullPath();
            while (des.hasNext()) {
                String pathString = des.getString();
                IPath path = Path.fromPortableString(pathString);
                copy.add(projectPath.append(path));
            }
        }
        this._disabled = copy;
    }

    public void dispose() {
        EventManager.getManager().removeProjectChangeListener(this);
    }

    public boolean isDisabled(IResource resource) {
        IProject project = resource.getProject();
        if (this._loadedProjects.contains(project)) {
            return this._disabled.contains(resource.getFullPath());
        }
        return this.isDisabled(resource, project);
    }

    private synchronized boolean isDisabled(IResource resource, IProject project) {
        if (!this._loadedProjects.contains(project)) {
            this.load(project);
            this._loadedProjects.add(project);
        }
        return this._disabled.contains(resource.getFullPath());
    }

    public void addDisabled(IResource resource) {
        this._disabled.add(resource.getFullPath());
    }

    @Override
    public void projectChanged(IProject project, int type) {
        switch (type) {
            case 2: 
            case 4: {
                this.projectRemoved(project);
            }
        }
    }

    private synchronized void projectRemoved(IProject project) {
        this._loadedProjects.remove(project);
        HashSet<IPath> copy = new HashSet<IPath>(100);
        String projectName = project.getName();
        for (IPath fullPath : this._disabled) {
            if (projectName.equals(fullPath.segment(0))) continue;
            copy.add(fullPath);
        }
        this._disabled = copy;
    }

    /* synthetic */ DisabledResourceManager(DisabledResourceManager disabledResourceManager) {
        this();
    }

    private static class Singleton {
        static DisabledResourceManager disabledResourceManager = new DisabledResourceManager(null);

        private Singleton() {
        }
    }
}

