/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.IVMInstall3;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.IVMRunner;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.PropertyChangeEvent;

public abstract class AbstractVMInstall
implements IVMInstall,
IVMInstall2,
IVMInstall3 {
    private IVMInstallType fType;
    private String fId;
    private String fName;
    private File fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private URL fJavadocLocation;
    private String fVMArgs;
    private boolean fNotify = true;

    public AbstractVMInstall(IVMInstallType type, String id) {
        if (type == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_typeNotNull);
        }
        if (id == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_idNotNull);
        }
        this.fType = type;
        this.fId = id;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_NAME", this.fName, name);
            this.fName = name;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(event);
            }
        }
    }

    @Override
    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public void setInstallLocation(File installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_INSTALL_LOCATION", this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(event);
            }
        }
    }

    @Override
    public IVMInstallType getVMInstallType() {
        return this.fType;
    }

    @Override
    public IVMRunner getVMRunner(String mode) {
        return null;
    }

    @Override
    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    @Override
    public void setLibraryLocations(LibraryLocation[] locations) {
        LibraryLocation[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals(prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_LIBRARY_LOCATIONS", prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(event);
        }
    }

    @Override
    public URL getJavadocLocation() {
        return this.fJavadocLocation;
    }

    @Override
    public void setJavadocLocation(URL url) {
        if (url == this.fJavadocLocation) {
            return;
        }
        if (url != null && this.fJavadocLocation != null && url.toString().equals(this.fJavadocLocation.toString())) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_JAVADOC_LOCATION", this.fJavadocLocation, url);
        this.fJavadocLocation = url;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(event);
        }
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IVMInstall) {
            IVMInstall vm = (IVMInstall)object;
            return this.getVMInstallType().equals(vm.getVMInstallType()) && this.getId().equals(vm.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getVMInstallType().hashCode() + this.getId().hashCode();
    }

    @Override
    public String[] getVMArguments() {
        String args = this.getVMArgs();
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getVMArgumentsArray();
    }

    @Override
    public void setVMArguments(String[] vmArgs) {
        if (vmArgs == null) {
            this.setVMArgs(null);
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < vmArgs.length) {
                String string = vmArgs[i];
                buf.append(string);
                buf.append(" ");
                ++i;
            }
            this.setVMArgs(buf.toString().trim());
        }
    }

    @Override
    public String getVMArgs() {
        return this.fVMArgs;
    }

    @Override
    public void setVMArgs(String vmArgs) {
        if (this.fVMArgs == null ? vmArgs == null : this.fVMArgs.equals(vmArgs)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_VM_ARGUMENTS", this.fVMArgs, vmArgs);
        this.fVMArgs = vmArgs;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(event);
        }
    }

    @Override
    public String getJavaVersion() {
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException(new Status(4, "org.eclipse.wst.jsdt.core", code, message, exception));
    }
}

