/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.NameEnvironment;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public class JavaScriptValidator
extends AbstractValidator {
    private ASTParser parser = ASTParser.newParser(3);

    @Override
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        JavaProject project = (JavaProject)JavaScriptCore.create(resource.getProject());
        NameEnvironment nameEnvironment = new NameEnvironment(project);
        if (resource instanceof IFile && Util.isJavaLikeFileName(resource.getName())) {
            SourceFile sf = this.findSourceFile((IFile)resource, true, nameEnvironment);
            if (sf == null) {
                return result;
            }
            this.parser.setSource(sf.getContents());
            JavaScriptUnit unit = (JavaScriptUnit)this.parser.createAST(monitor);
            if (unit == null) {
                Logger.log(4, "AST couldn't be created during the validation of " + resource.getName());
            } else if (unit.getProblems().length > 0) {
                CategorizedProblem[] resourceProblems;
                CategorizedProblem[] categorizedProblemArray = resourceProblems = (CategorizedProblem[])unit.getProblems();
                int n = resourceProblems.length;
                int n2 = 0;
                while (n2 < n) {
                    CategorizedProblem problem = categorizedProblemArray[n2];
                    ValidatorMessage vm = ValidatorMessage.create(problem.getMessage(), resource);
                    vm.setAttribute("severity", problem.isError() ? 2 : 1);
                    vm.setType(problem.getMarkerType());
                    vm.setAttribute("lineNumber", problem.getSourceLineNumber());
                    result.add(vm);
                    ++n2;
                }
            }
        }
        return result;
    }

    private SourceFile findSourceFile(IFile file, boolean mustExist, INameEnvironment nameEnvironment) {
        if (mustExist && !file.exists()) {
            return null;
        }
        if (file.isDerived()) {
            return null;
        }
        ClasspathMultiDirectory[] sourceLocations = ((NameEnvironment)nameEnvironment).getSourceLocations();
        if (sourceLocations == null || sourceLocations.length == 0) {
            return null;
        }
        IPath sourceFileFullPath = file.getFullPath();
        int j = 0;
        int m = sourceLocations.length;
        while (j < m) {
            ClasspathMultiDirectory md = sourceLocations[j];
            if (md.getSourceFolder().getFullPath().isPrefixOf(sourceFileFullPath) && !Util.isExcluded(file, md.getInclusionPatterns(), md.getExclusionPatterns())) {
                return new SourceFile(file, md);
            }
            ++j;
        }
        return null;
    }
}

