/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.search.IndexSelector;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.matching.ASTMatchingVisitor;
import org.eclipse.wst.jsdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class MatchLocator {
    private SearchPattern pattern;
    private SearchRequestor requestor;
    private IJavaScriptSearchScope scope;
    private SubMonitor progressMonitor;
    private static boolean PERF_STATS = false;

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaScriptSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = SubMonitor.convert(progressMonitor);
    }

    public void locateMatches(SearchDocument[] documents) throws CoreException {
        this.progressMonitor.beginTask(Messages.engine_searching_matching_progress, documents.length);
        long start = 0L;
        if (PERF_STATS) {
            start = System.currentTimeMillis();
        }
        ASTParser parser = ASTParser.newParser(3);
        parser.setResolveBindings(false);
        HandleFactory handleFactory = new HandleFactory();
        int i = 0;
        while (i < documents.length) {
            SearchDocument currentDocument = documents[i];
            if (this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.progressMonitor.subTask(Messages.bind(Messages.engine_searching_matching_progress, currentDocument.getPath().toString()));
            Path path = new Path(currentDocument.getPath());
            Openable openable = handleFactory.createOpenable(path.toString(), this.scope);
            ITypeRoot element = (ITypeRoot)((Object)openable);
            parser.setSource(element);
            ASTMatchingVisitor visitor = new ASTMatchingVisitor(this.pattern, currentDocument.getParticipant(), element);
            try {
                ASTNode root = parser.createAST(null);
                root.accept(visitor);
            }
            catch (ClassCastException e) {
                Util.verbose("ClassCastException during matching -- " + e.getMessage() + "\n\t in file:  " + currentDocument.getPath());
            }
            catch (IllegalArgumentException e) {
                Util.verbose("IllegalArgumentException during matching-- " + e.getMessage() + "\n\t in file:  " + currentDocument.getPath());
            }
            this.reportMatches(visitor.getMatches());
            visitor.clearMatches();
            this.progressMonitor.worked(1);
            ++i;
        }
        if (PERF_STATS) {
            System.out.println("Search Complete -- time : " + (System.currentTimeMillis() - start));
        }
    }

    private void reportMatches(List<SearchMatch> matches) throws CoreException {
        for (SearchMatch match : matches) {
            this.requestor.acceptSearchMatch(match);
        }
    }

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, IJavaScriptUnit[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static IJavaScriptElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public static IJavaScriptElement getProjectOrJar(IJavaScriptElement element) {
        while (!(element instanceof IJavaScriptProject || element instanceof LibraryFragmentRoot || element instanceof PackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    private static HashMap workingCopiesThatCanSeeFocus(IJavaScriptUnit[] copies, IJavaScriptElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaScriptProject)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            IJavaScriptUnit workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
            }
            ++i;
        }
        return result;
    }

    public static class WorkingCopyDocument
    extends JavaSearchDocument {
        public IJavaScriptUnit workingCopy;

        WorkingCopyDocument(IJavaScriptUnit workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        @Override
        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }
}

