/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ASTIndexerVisitor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataSourceElementNotifier;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    private static boolean PERF_STATS = false;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    @Override
    public void indexDocument() {
        long start = 0L;
        if (PERF_STATS) {
            start = System.currentTimeMillis();
        }
        ASTIndexerVisitor visitor = new ASTIndexerVisitor(this);
        char[] source = this.document.getCharContents();
        Path path = new Path(this.document.getPath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        ASTParser parser = ASTParser.newParser(3);
        parser.setResolveBindings(false);
        parser.setSource(source);
        parser.setUnitName(this.document.getPath());
        parser.setProject(JavaScriptCore.create(project));
        try {
            ASTNode root = parser.createAST(null);
            if (root != null) {
                root.accept(visitor);
            } else {
                Util.verbose("AST couldn't be created during indexing file:  " + this.document.getPath());
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            Util.verbose("ClassCastException during indexing -- " + e.getMessage() + "\n\t in file:  " + this.document.getPath());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Util.verbose("IllegalArgumentException during indexing -- " + e.getMessage() + "\n\t in file:  " + this.document.getPath());
        }
        if (PERF_STATS) {
            System.out.println(String.valueOf(System.currentTimeMillis() - start) + "  \ttaken to index file: " + this.document.getPath());
        }
    }

    public void indexMetadata() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        char[][] packageName = null;
        if (pkgName != null) {
            packageName = new char[][]{pkgName.toCharArray()};
        }
        LibraryAPIs apis = MetadataReader.readAPIsFromString(new String(source), documentPath);
        new MetadataSourceElementNotifier(apis, requestor).notifyRequestor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void indexArchive() {
        Path jarPath = new Path(this.document.getPath());
        File file = new File(jarPath.toOSString());
        if (!file.isFile()) return;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        Index index = indexManager.getIndexForUpdate(jarPath, false, true);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(ze.getName())) continue;
                byte[] classFileBytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                JavaSearchDocument entryDocument = new JavaSearchDocument(ze, (IPath)jarPath, ByteBuffer.wrap(classFileBytes).asCharBuffer().array(), participant);
                indexManager.indexDocument(entryDocument, participant, index, jarPath);
            }
            indexManager.saveIndex(index);
        }
        catch (ZipException e1) {
            e1.printStackTrace();
            if (zip == null) return;
            try {
                zip.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e1) {
            try {
                e1.printStackTrace();
                if (zip == null) return;
            }
            catch (Throwable throwable) {
                if (zip == null) throw throwable;
                try {
                    zip.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zip.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (zip == null) return;
        try {
            zip.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

