/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddLibraryFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public AddLibraryFolderToIndex(IPath folderPath, IProject project, char[][] inclusionPatterns, char[][] exclusionPatterns, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    private void indexFile(IFile resource) {
        this.manager.addSource(resource, this.folderPath);
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null || folder.getType() == 1) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                    folder.accept(new IResourceProxyVisitor(){

                        @Override
                        public boolean visit(IResourceProxy proxy) {
                            if (proxy.getType() == 1) {
                                if (Util.isJavaLikeFileName(proxy.getName()) || Util.isMetadataFileName(proxy.getName())) {
                                    AddLibraryFolderToIndex.this.indexFile((IFile)proxy.requestResource());
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    folder.accept(new IResourceProxyVisitor(){

                        @Override
                        public boolean visit(IResourceProxy proxy) {
                            switch (proxy.getType()) {
                                case 1: {
                                    IResource resource;
                                    if ((Util.isJavaLikeFileName(proxy.getName()) || Util.isMetadataFileName(proxy.getName())) && !Util.isExcluded(resource = proxy.requestResource(), AddLibraryFolderToIndex.this.inclusionPatterns, AddLibraryFolderToIndex.this.exclusionPatterns)) {
                                        AddLibraryFolderToIndex.this.indexFile((IFile)proxy.requestResource());
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (AddLibraryFolderToIndex.this.exclusionPatterns == null || AddLibraryFolderToIndex.this.inclusionPatterns != null || !Util.isExcluded(proxy.requestFullPath(), AddLibraryFolderToIndex.this.inclusionPatterns, AddLibraryFolderToIndex.this.exclusionPatterns, true)) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                }
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:", System.err);
                    e.printStackTrace();
                }
                monitor.exitRead();
                return false;
            }
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.containerPath;
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }
}

