/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.TypeVector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.ChangeCollector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    static final byte VERSION = 0;
    static final byte SEPARATOR1 = 10;
    static final byte SEPARATOR2 = 44;
    static final byte SEPARATOR3 = 62;
    static final byte SEPARATOR4 = 13;
    static final byte COMPUTE_SUBTYPES = 1;
    static final byte CLASS = 0;
    static final byte COMPUTED_FOR = 2;
    static final byte ROOT = 4;
    static final byte[] NO_FLAGS = new byte[0];
    static final int SIZE = 10;
    protected IJavaScriptProject project;
    protected IType focusType;
    protected IJavaScriptUnit[] workingCopies;
    protected Map classToSuperclass;
    protected Map typeToSubtypes;
    protected Map typeFlags;
    protected TypeVector rootClasses = new TypeVector();
    public ArrayList missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected IProgressMonitor progressMonitor = null;
    protected ArrayList changeListeners = null;
    public Map files = null;
    protected Region packageRegion = null;
    protected Region projectRegion = null;
    protected boolean computeSubtypes;
    IJavaScriptSearchScope scope;
    public boolean needsRefresh = true;
    protected ChangeCollector changeCollector;

    public TypeHierarchy() {
    }

    public TypeHierarchy(IType type, IJavaScriptUnit[] workingCopies, IJavaScriptProject project, boolean computeSubtypes) {
        this(type, workingCopies, SearchEngine.createJavaSearchScope(new IJavaScriptElement[]{project}), computeSubtypes);
        this.project = project;
    }

    public TypeHierarchy(IType type, IJavaScriptUnit[] workingCopies, IJavaScriptSearchScope scope, boolean computeSubtypes) {
        this.focusType = type == null ? null : (IType)((Object)((JavaElement)((Object)type)).unresolved());
        this.workingCopies = workingCopies;
        this.computeSubtypes = computeSubtypes;
        this.scope = scope;
    }

    protected void initializeRegions() {
        IType[] allTypes = this.getAllClasses();
        int i = 0;
        while (i < allTypes.length) {
            IType type = allTypes[i];
            Openable o = (Openable)((JavaElement)((Object)type)).getOpenableParent();
            if (o != null) {
                ArrayList<IType> types = (ArrayList<IType>)this.files.get(o);
                if (types == null) {
                    types = new ArrayList<IType>();
                    this.files.put(o, types);
                }
                types.add(type);
            }
            IPackageFragment pkg = type.getPackageFragment();
            this.packageRegion.add(pkg);
            IJavaScriptProject declaringProject = type.getJavaScriptProject();
            if (declaringProject != null) {
                this.projectRegion.add(declaringProject);
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    protected void addSubtype(IType type, IType subtype) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type.getDisplayName());
        if (subtypes == null) {
            subtypes = new TypeVector();
            this.typeToSubtypes.put(type.getDisplayName(), subtypes);
        }
        if (!subtypes.contains(subtype)) {
            subtypes.add(subtype);
        }
    }

    @Override
    public synchronized void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.changeListeners;
        if (listeners == null) {
            this.changeListeners = listeners = new ArrayList<ITypeHierarchyChangedListener>();
        }
        if (listeners.size() == 0) {
            JavaScriptCore.addElementChangedListener(this);
        }
        if (listeners.indexOf(listener) == -1) {
            listeners.add(listener);
        }
    }

    private static Integer bytesToFlags(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Integer.valueOf(new String(bytes));
        }
        return null;
    }

    public void cacheFlags(IType type, int flags) {
        this.typeFlags.put(type, flags);
    }

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            this.classToSuperclass.put(type, superclass);
            this.addSubtype(superclass, type);
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws JavaScriptModelException, CoreException {
        if (this.focusType != null) {
            IndexBasedHierarchyBuilder builder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)builder).build(this.computeSubtypes);
        }
    }

    @Override
    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        return this.rootClasses.contains(type);
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        if (this.needsRefresh) {
            return;
        }
        if (this.isAffected(event.getDelta())) {
            this.needsRefresh = true;
            this.fireChange();
        }
    }

    @Override
    public boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.focusType == null || this.focusType.exists()) && this.javaProject().exists();
    }

    public void fireChange() {
        ArrayList listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.focusType != null) {
                System.out.println("    for hierarchy focused on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
            }
        }
        listeners = (ArrayList)listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)listeners.get(i);
            SafeRunner.run(new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                    Util.log(exception, "Exception occurred in listener of Type hierarchy change notification");
                }

                @Override
                public void run() throws Exception {
                    listener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    private static byte[] flagsToBytes(Integer flags) {
        if (flags != null) {
            return flags.toString().getBytes();
        }
        return NO_FLAGS;
    }

    @Override
    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add((IType)iter.next());
        }
        return classes.elements();
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        HashSet<IType> subTypes = new HashSet<IType>();
        LinkedList<IType> typesToGetSubtypesOf = new LinkedList<IType>();
        typesToGetSubtypesOf.add(type);
        while (!typesToGetSubtypesOf.isEmpty()) {
            IType typeToGetSubtypeOf = (IType)typesToGetSubtypesOf.removeFirst();
            IType[] currSubTypes = this.getSubtypesForType(typeToGetSubtypeOf);
            int i = 0;
            while (i < currSubTypes.length) {
                if (!subTypes.contains(currSubTypes[i])) {
                    subTypes.add(currSubTypes[i]);
                    typesToGetSubtypesOf.add(currSubTypes[i]);
                }
                ++i;
            }
        }
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private IType[] getSubtypesForType(IType type) {
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type.getDisplayName());
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    @Override
    public IType[] getAllSuperclasses(IType type) {
        IType superclass = this.getSuperclass(type);
        TypeVector supers = new TypeVector();
        while (superclass != null) {
            supers.add(superclass);
            superclass = this.getSuperclass(superclass);
        }
        return supers.elements();
    }

    @Override
    public int getCachedFlags(IType type) {
        Integer flagObject = (Integer)this.typeFlags.get(type);
        if (flagObject != null) {
            return flagObject;
        }
        return -1;
    }

    @Override
    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    @Override
    public IType[] getSubclasses(IType type) {
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type.getDisplayName());
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    @Override
    public IType getSuperclass(IType type) {
        return (IType)this.classToSuperclass.get(type);
    }

    @Override
    public IType getType() {
        return this.focusType;
    }

    protected IType[] growAndAddToArray(IType[] array, IType[] additions) {
        if (array == null || array.length == 0) {
            return additions;
        }
        IType[] old = array;
        array = new IType[old.length + additions.length];
        System.arraycopy(old, 0, array, 0, old.length);
        System.arraycopy(additions, 0, array, old.length, additions.length);
        return array;
    }

    protected IType[] growAndAddToArray(IType[] array, IType addition) {
        if (array == null || array.length == 0) {
            return new IType[]{addition};
        }
        IType[] old = array;
        array = new IType[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    public boolean hasFineGrainChanges() {
        ChangeCollector collector = this.changeCollector;
        return collector != null && collector.needsRefresh();
    }

    private boolean hasSubtypeNamed(String simpleName) {
        if (this.focusType != null && this.focusType.getElementName().equals(simpleName)) {
            return true;
        }
        IType[] types = this.focusType == null ? this.getAllClasses() : this.getAllSubtypes(this.focusType);
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeNamed(String simpleName) {
        IType[] types = this.getAllClasses();
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean includesTypeOrSupertype(IType type) {
        int lastSeparator;
        String simpleName;
        block4: {
            try {
                if (!this.hasTypeNamed(type.getElementName())) break block4;
                return true;
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        String superclassName = type.getSuperclassName();
        if (superclassName != null && this.hasTypeNamed(simpleName = superclassName.substring((lastSeparator = superclassName.lastIndexOf(46)) + 1))) {
            return true;
        }
        return false;
    }

    protected void initialize(int size) {
        if (size < 10) {
            size = 10;
        }
        int smallSize = size / 2;
        this.classToSuperclass = new HashMap(size);
        this.missingTypes = new ArrayList(smallSize);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap(smallSize);
        this.typeFlags = new HashMap(smallSize);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.files = new HashMap(5);
    }

    public synchronized boolean isAffected(IJavaScriptElementDelta delta) {
        IJavaScriptElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                return this.isAffectedByJavaModel(delta, element);
            }
            case 2: {
                return this.isAffectedByJavaProject(delta, element);
            }
            case 3: {
                return this.isAffectedByPackageFragmentRoot(delta, element);
            }
            case 4: {
                return this.isAffectedByPackageFragment(delta, (PackageFragment)element);
            }
            case 5: 
            case 6: {
                return this.isAffectedByOpenable(delta, element);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IJavaScriptElementDelta delta) {
        if ((delta.getFlags() & 8) > 0) {
            IJavaScriptElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAffected(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isAffectedByJavaModel(IJavaScriptElementDelta delta, IJavaScriptElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                return element.equals(this.javaProject().getJavaScriptModel());
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByJavaProject(IJavaScriptElementDelta delta, IJavaScriptElement element) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if ((flags & 0x200) != 0) {
            kind = 1;
        }
        if ((flags & 0x400) != 0) {
            kind = 2;
        }
        switch (kind) {
            case 1: {
                try {
                    IIncludePathEntry[] classpath = ((JavaProject)this.javaProject()).getExpandedClasspath();
                    int i = 0;
                    while (i < classpath.length) {
                        if (classpath[i].getEntryKind() == 2 && classpath[i].getPath().equals(element.getPath())) {
                            return true;
                        }
                        ++i;
                    }
                    if (this.focusType != null) {
                        classpath = ((JavaProject)element).getExpandedClasspath();
                        IPath hierarchyProject = this.javaProject().getPath();
                        int i2 = 0;
                        while (i2 < classpath.length) {
                            if (classpath[i2].getEntryKind() == 2 && classpath[i2].getPath().equals(hierarchyProject)) {
                                return true;
                            }
                            ++i2;
                        }
                    }
                    return false;
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return false;
                }
            }
            case 2: {
                IJavaScriptElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    IJavaScriptProject javaProject = pkgs[i].getJavaScriptProject();
                    if (javaProject != null && javaProject.equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragment(IJavaScriptElementDelta delta, PackageFragment element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: {
                return this.packageRegionContainsSamePackageFragment(element);
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragmentRoot(IJavaScriptElementDelta delta, IJavaScriptElement element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: 
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 && this.projectRegion != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    IPath rootPath = root.getPath();
                    IJavaScriptElement[] elements = this.projectRegion.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        JavaProject javaProject = (JavaProject)elements[i];
                        try {
                            IIncludePathEntry entry = javaProject.getClasspathEntryFor(rootPath);
                            if (entry != null) {
                                return true;
                            }
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                        ++i;
                    }
                }
                if ((flags & 0x80) <= 0 && (flags & 1) <= 0) break;
                IJavaScriptElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(delta);
    }

    protected boolean isAffectedByOpenable(IJavaScriptElementDelta delta, IJavaScriptElement element) {
        if (element instanceof CompilationUnit) {
            ChangeCollector collector;
            CompilationUnit cu;
            block14: {
                cu = (CompilationUnit)element;
                collector = this.changeCollector;
                if (collector == null) {
                    collector = new ChangeCollector(this);
                }
                try {
                    collector.addChange(cu, delta);
                }
                catch (JavaScriptModelException e) {
                    if (!DEBUG) break block14;
                    e.printStackTrace();
                }
            }
            if (cu.isWorkingCopy()) {
                this.changeCollector = collector;
                return false;
            }
            return collector.needsRefresh();
        }
        if (element instanceof ClassFile) {
            switch (delta.getKind()) {
                case 2: {
                    return this.files.get(element) != null;
                }
                case 1: {
                    IType type = ((ClassFile)element).getType();
                    String typeName = type.getElementName();
                    if (!this.hasSupertype(typeName) && !this.subtypesIncludeSupertypeOf(type) && !this.missingTypes.contains(typeName)) break;
                    return true;
                }
                case 4: {
                    IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    int length = children.length;
                    while (i < length) {
                        IJavaScriptElementDelta child = children[i];
                        IJavaScriptElement childElement = child.getElement();
                        if (childElement instanceof IType) {
                            boolean hasSupertypeChange;
                            IType type = (IType)childElement;
                            boolean hasVisibilityChange = (delta.getFlags() & 2) > 0;
                            boolean bl = hasSupertypeChange = (delta.getFlags() & 0x800) > 0;
                            if (hasVisibilityChange && this.hasSupertype(type.getElementName()) || hasSupertypeChange && this.includesTypeOrSupertype(type)) {
                                return true;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return false;
    }

    public IJavaScriptProject javaProject() {
        return this.focusType.getJavaScriptProject();
    }

    protected static byte[] readUntil(InputStream input, byte separator) throws JavaScriptModelException, IOException {
        return TypeHierarchy.readUntil(input, separator, 0);
    }

    protected static byte[] readUntil(InputStream input, byte separator, int offset) throws IOException, JavaScriptModelException {
        byte b;
        int length = 0;
        byte[] bytes = new byte[10];
        while ((b = (byte)input.read()) != separator && b != -1) {
            if (bytes.length == length) {
                byte[] byArray = bytes;
                bytes = new byte[length * 2];
                System.arraycopy(byArray, 0, bytes, 0, length);
            }
            bytes[length++] = b;
        }
        if (b == -1) {
            throw new JavaScriptModelException(new JavaModelStatus(4));
        }
        byte[] byArray = bytes;
        bytes = new byte[length + offset];
        System.arraycopy(byArray, 0, bytes, offset, length);
        return bytes;
    }

    public static ITypeHierarchy load(IType type, InputStream input, WorkingCopyOwner owner) throws JavaScriptModelException {
        try {
            byte[] missing;
            byte b;
            byte[] bytes;
            TypeHierarchy typeHierarchy = new TypeHierarchy();
            typeHierarchy.initialize(1);
            IType[] types = new IType[10];
            int typeCount = 0;
            byte version = (byte)input.read();
            if (version != 0) {
                throw new JavaScriptModelException(new JavaModelStatus(4));
            }
            byte generalInfo = (byte)input.read();
            if ((generalInfo & 1) != 0) {
                typeHierarchy.computeSubtypes = true;
            }
            if ((bytes = TypeHierarchy.readUntil(input, (byte)10)).length > 0) {
                typeHierarchy.project = (IJavaScriptProject)JavaScriptCore.create(new String(bytes));
                typeHierarchy.scope = SearchEngine.createJavaSearchScope(new IJavaScriptElement[]{typeHierarchy.project});
            } else {
                typeHierarchy.project = null;
                typeHierarchy.scope = SearchEngine.createWorkspaceScope();
            }
            bytes = TypeHierarchy.readUntil(input, (byte)10);
            int j = 0;
            int length = bytes.length;
            int i = 0;
            while (i < length) {
                b = bytes[i];
                if (b == 44) {
                    missing = new byte[i - j];
                    System.arraycopy(bytes, j, missing, 0, i - j);
                    typeHierarchy.missingTypes.add(new String(missing));
                    j = i + 1;
                }
                ++i;
            }
            missing = new byte[length - j];
            System.arraycopy(bytes, j, missing, 0, length - j);
            typeHierarchy.missingTypes.add(new String(missing));
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte info;
                bytes = TypeHierarchy.readUntil(input, (byte)13, 1);
                bytes[0] = b;
                IType element = (IType)JavaScriptCore.create(new String(bytes), owner);
                if (types.length == typeCount) {
                    IType[] iTypeArray = types;
                    types = new IType[typeCount * 2];
                    System.arraycopy(iTypeArray, 0, types, 0, typeCount);
                }
                types[typeCount++] = element;
                bytes = TypeHierarchy.readUntil(input, (byte)13);
                Integer flags = TypeHierarchy.bytesToFlags(bytes);
                if (flags != null) {
                    typeHierarchy.cacheFlags(element, flags);
                }
                if (((info = (byte)input.read()) & 2) != 0) {
                    if (!element.equals(type)) {
                        throw new JavaScriptModelException(new JavaModelStatus(4));
                    }
                    typeHierarchy.focusType = element;
                }
                if ((info & 4) == 0) continue;
                typeHierarchy.addRootClass(element);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = Integer.valueOf(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                int superClass = Integer.valueOf(new String(bytes));
                typeHierarchy.cacheSuperclass(types[subClass], types[superClass]);
            }
            if (b == -1) {
                throw new JavaScriptModelException(new JavaModelStatus(4));
            }
            return typeHierarchy;
        }
        catch (IOException e) {
            throw new JavaScriptModelException(e, 985);
        }
    }

    protected boolean packageRegionContainsSamePackageFragment(PackageFragment element) {
        IJavaScriptElement[] pkgs = this.packageRegion.getElements();
        int i = 0;
        while (i < pkgs.length) {
            PackageFragment pkg = (PackageFragment)pkgs[i];
            if (Util.equalArraysOrNull(pkg.names, element.names)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized void refresh(IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            try {
                this.progressMonitor = monitor;
                if (monitor != null) {
                    monitor.beginTask(this.focusType != null ? Messages.bind(Messages.hierarchy_creatingOnType, this.focusType.getFullyQualifiedName()) : Messages.hierarchy_creating, 100);
                }
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.computeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.focusType != null) {
                        System.out.println("  on type " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors());
                    }
                }
                this.compute();
                this.initializeRegions();
                this.needsRefresh = false;
                this.changeCollector = null;
                if (DEBUG) {
                    if (this.computeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (JavaScriptModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaScriptModelException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
        }
    }

    @Override
    public synchronized void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            JavaScriptCore.removeElementChangedListener(this);
        }
    }

    @Override
    public void store(OutputStream output, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            Object t;
            Hashtable<IType, Integer> hashtable = new Hashtable<IType, Integer>();
            Hashtable<Integer, IType> hashtable2 = new Hashtable<Integer, IType>();
            int count = 0;
            if (this.focusType != null) {
                Integer index = count++;
                hashtable.put(this.focusType, index);
                hashtable2.put(index, this.focusType);
            }
            Object[] types = this.classToSuperclass.entrySet().toArray();
            int i = 0;
            while (i < types.length) {
                Object superClass;
                Map.Entry entry = (Map.Entry)types[i];
                t = entry.getKey();
                if (hashtable.get(t) == null) {
                    Integer index = count++;
                    hashtable.put((IType)t, index);
                    hashtable2.put(index, (IType)t);
                }
                if ((superClass = entry.getValue()) != null && hashtable.get(superClass) == null) {
                    Integer index = count++;
                    hashtable.put((IType)superClass, index);
                    hashtable2.put(index, (IType)superClass);
                }
                ++i;
            }
            output.write(0);
            int generalInfo = 0;
            if (this.computeSubtypes) {
                generalInfo = (byte)(generalInfo | 1);
            }
            output.write(generalInfo);
            if (this.project != null) {
                output.write(this.project.getHandleIdentifier().getBytes());
            }
            output.write(10);
            int i2 = 0;
            while (i2 < this.missingTypes.size()) {
                if (i2 != 0) {
                    output.write(44);
                }
                output.write(((String)this.missingTypes.get(i2)).getBytes());
                ++i2;
            }
            output.write(10);
            i2 = 0;
            while (i2 < count) {
                t = (IType)hashtable2.get(i2);
                output.write(t.getHandleIdentifier().getBytes());
                output.write(13);
                output.write(TypeHierarchy.flagsToBytes((Integer)this.typeFlags.get(t)));
                output.write(13);
                int info = 0;
                if (this.focusType != null && this.focusType.equals(t)) {
                    info = (byte)(info | 2);
                }
                if (this.rootClasses.contains((IType)t)) {
                    info = (byte)(info | 4);
                }
                output.write(info);
                ++i2;
            }
            output.write(10);
            types = this.classToSuperclass.entrySet().toArray();
            i2 = 0;
            while (i2 < types.length) {
                Map.Entry entry = (Map.Entry)types[i2];
                IJavaScriptElement key = (IJavaScriptElement)entry.getKey();
                IJavaScriptElement value = (IJavaScriptElement)entry.getValue();
                output.write(((Integer)hashtable.get(key)).toString().getBytes());
                output.write(62);
                output.write(((Integer)hashtable.get(value)).toString().getBytes());
                output.write(10);
                ++i2;
            }
            output.write(10);
            output.write(10);
        }
        catch (IOException e) {
            throw new JavaScriptModelException(e, 985);
        }
    }

    boolean subtypesIncludeSupertypeOf(IType type) {
        String simpleSuper;
        String superclassName = null;
        try {
            superclassName = type.getSuperclassName();
        }
        catch (JavaScriptModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        if (superclassName == null) {
            superclassName = "Object";
        }
        int dot = -1;
        dot = superclassName.lastIndexOf(46);
        String string = simpleSuper = dot > -1 ? superclassName.substring(dot + 1) : superclassName;
        return this.hasSubtypeNamed(simpleSuper);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Focus: ");
        buffer.append(this.focusType == null ? "<NONE>" : ((JavaElement)((Object)this.focusType)).toStringWithAncestors(false));
        buffer.append("\n");
        if (this.exists()) {
            int i;
            IJavaScriptElement[] roots;
            if (this.focusType != null) {
                buffer.append("Super types:\n");
                this.toString(buffer, this.focusType, 1, true);
                buffer.append("Sub types:\n");
                this.toString(buffer, this.focusType, 1, false);
            } else {
                buffer.append("Sub types of root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                while (i < roots.length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            }
            if (this.rootClasses.size > 1) {
                buffer.append("Root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                int length = roots.length;
                while (i < length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            } else if (this.rootClasses.size == 0) {
                buffer.append("No root classes");
            }
        } else {
            buffer.append("(Hierarchy became stale)");
        }
        return buffer.toString();
    }

    private void toString(StringBuffer buffer, IType type, int indent, boolean ascendant) {
        IJavaScriptElement[] iJavaScriptElementArray;
        if (ascendant) {
            IJavaScriptElement[] iJavaScriptElementArray2 = new IType[1];
            iJavaScriptElementArray = iJavaScriptElementArray2;
            iJavaScriptElementArray2[0] = this.getSuperclass(type);
        } else {
            iJavaScriptElementArray = this.getSubclasses(type);
        }
        IJavaScriptElement[] types = iJavaScriptElementArray;
        IJavaScriptElement[] sortedTypes = Util.sortCopy(types);
        int i = 0;
        while (i < sortedTypes.length) {
            int j = 0;
            while (j < indent) {
                buffer.append("  ");
                ++j;
            }
            JavaElement element = (JavaElement)sortedTypes[i];
            buffer.append(element.toStringWithAncestors(false));
            buffer.append('\n');
            this.toString(buffer, (IType)types[i], indent + 1, ascendant);
            ++i;
        }
    }

    boolean hasSupertype(String simpleName) {
        for (IType superType : this.classToSuperclass.values()) {
            if (!superType.getElementName().equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    protected void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }
}

