/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.eclipse.wst.jsdt.internal.core.UserLibraryJsGlobalScopeContainer;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.wst.jsdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static Map UserLibraries;
    private static ThreadLocal InitializingLibraries;
    private static final boolean logProblems = false;
    private static IEclipsePreferences.IPreferenceChangeListener listener;

    static {
        InitializingLibraries = new ThreadLocal();
        listener = new IEclipsePreferences.IPreferenceChangeListener(){

            @Override
            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String key = event.getKey();
                if (key.startsWith(UserLibraryManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    try {
                        UserLibraryManager.recreatePersistedUserLibraryEntry(key, (String)event.getNewValue(), false, true);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private UserLibraryManager() {
    }

    public static String[] getUserLibraryNames() {
        Set set = UserLibraryManager.getLibraryMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static UserLibrary getUserLibrary(String name) {
        return (UserLibrary)UserLibraryManager.getLibraryMap().get(name);
    }

    public static void setUserLibraries(String[] newNames, UserLibrary[] newLibs, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isTrue(newNames.length == newLibs.length, "names and libraries should have the same length");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", newNames.length);
            int last = newNames.length - 1;
            int i = 0;
            while (i < newLibs.length) {
                UserLibraryManager.internalSetUserLibrary(newNames[i], newLibs[i], i == last, true, new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void setUserLibrary(String name, UserLibrary library, IProgressMonitor monitor) throws JavaScriptModelException {
        UserLibraryManager.internalSetUserLibrary(name, library, true, true, monitor);
    }

    static Map getLibraryMap() {
        if (UserLibraries == null) {
            HashMap libraries = (HashMap)InitializingLibraries.get();
            if (libraries != null) {
                return libraries;
            }
            try {
                libraries = new HashMap();
                InitializingLibraries.set(libraries);
                IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
                instancePreferences.addPreferenceChangeListener(listener);
                try {
                    String[] propertyNames = instancePreferences.keys();
                    int i = 0;
                    while (i < propertyNames.length) {
                        String propertyName = propertyNames[i];
                        if (propertyName.startsWith(CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                            try {
                                String propertyValue = instancePreferences.get(propertyName, null);
                                if (propertyValue != null) {
                                    UserLibraryManager.recreatePersistedUserLibraryEntry(propertyName, propertyValue, false, false);
                                }
                            }
                            catch (JavaScriptModelException javaScriptModelException) {}
                        }
                        ++i;
                    }
                }
                catch (BackingStoreException backingStoreException) {}
                UserLibraries = libraries;
            }
            finally {
                InitializingLibraries.set(null);
            }
        }
        return UserLibraries;
    }

    static void recreatePersistedUserLibraryEntry(String propertyName, String savedString, boolean save, boolean rebind) throws JavaScriptModelException {
        String libName = propertyName.substring(CP_USERLIBRARY_PREFERENCES_PREFIX.length());
        if (savedString == null || savedString.equals(CP_ENTRY_IGNORE)) {
            UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
        } else {
            try {
                StringReader reader = new StringReader(savedString);
                UserLibrary library = UserLibrary.createFromString(reader);
                UserLibraryManager.internalSetUserLibrary(libName, library, save, rebind, null);
            }
            catch (IOException e) {
                UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
            }
        }
    }

    static void internalSetUserLibrary(String name, UserLibrary library, boolean save, boolean rebind, IProgressMonitor monitor) throws JavaScriptModelException {
        Object previous;
        if (library == null ? (previous = UserLibraryManager.getLibraryMap().remove(name)) == null : library.equals(previous = UserLibraryManager.getLibraryMap().put(name, library))) {
            return;
        }
        IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
        String containerKey = CP_USERLIBRARY_PREFERENCES_PREFIX + name;
        String containerString = CP_ENTRY_IGNORE;
        if (library != null) {
            try {
                containerString = library.serialize();
            }
            catch (IOException iOException) {}
        }
        instancePreferences.removePreferenceChangeListener(listener);
        try {
            instancePreferences.put(containerKey, containerString);
            if (save) {
                try {
                    instancePreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (rebind) {
                UserLibraryManager.rebindClasspathEntries(name, library == null, monitor);
            }
        }
        finally {
            instancePreferences.addPreferenceChangeListener(listener);
        }
    }

    private static void rebindClasspathEntries(String name, boolean remove, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            if (monitor != null) {
                monitor.beginTask("", 1);
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaScriptProject[] projects = JavaScriptCore.create(root).getJavaScriptProjects();
            IPath containerPath = new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append(name);
            ArrayList<IJavaScriptProject> affectedProjects = new ArrayList<IJavaScriptProject>();
            int i = 0;
            while (i < projects.length) {
                IJavaScriptProject project = projects[i];
                IIncludePathEntry[] entries = project.getRawIncludepath();
                int k = 0;
                while (k < entries.length) {
                    IIncludePathEntry curr = entries[k];
                    if (curr.getEntryKind() == 5 && containerPath.equals(curr.getPath())) {
                        affectedProjects.add(project);
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            if (!affectedProjects.isEmpty()) {
                IJavaScriptProject[] affected = affectedProjects.toArray(new IJavaScriptProject[affectedProjects.size()]);
                IJsGlobalScopeContainer[] containers = new IJsGlobalScopeContainer[affected.length];
                if (!remove) {
                    UserLibraryJsGlobalScopeContainer container = new UserLibraryJsGlobalScopeContainer(name);
                    containers[0] = container;
                }
                JavaScriptCore.setJsGlobalScopeContainer(containerPath, affected, containers, monitor == null ? null : new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

