/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.codeassist.ISearchRequestor;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironmentRequestor;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IConstructorRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IFunctionRequester;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IVariableRequester;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;

public class SearchableEnvironment
implements INameEnvironment,
IJavaScriptSearchConstants {
    public NameLookup nameLookup;
    protected ICompilationUnit unitToSkip;
    protected IJavaScriptUnit[] workingCopies;
    protected JavaProject javaProject;
    protected IJavaScriptSearchScope searchScope;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironment(JavaProject project, IRestrictedAccessBindingRequestor resolutionScope, IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        this.javaProject = project;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.wst.jsdt.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = this.javaProject.newNameLookup(workingCopies);
        this.nameLookup.setRestrictedAccessRequestor(resolutionScope);
        this.nameLookup.searchScope = this.searchScope = BasicSearchEngine.createJavaSearchScope(this.nameLookup.packageFragmentRoots);
    }

    public SearchableEnvironment(JavaProject project, IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        this(project, null, workingCopies);
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner) throws JavaScriptModelException {
        this(project, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true));
    }

    public SearchableEnvironment(JavaProject project, IRestrictedAccessBindingRequestor resolutionScope, WorkingCopyOwner owner) throws JavaScriptModelException {
        this(project, resolutionScope, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true));
    }

    private static int convertSearchFilterToModelFilter(int searchFilter) {
        switch (searchFilter) {
            case 5: {
                return 2;
            }
        }
        return 30;
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName) {
        NameLookup.Answer answer;
        if (packageName == null) {
            packageName = "";
        }
        if ((answer = this.nameLookup.findType(typeName, packageName, false, 30, this.checkAccessRestrictions)) != null) {
            IType[] types;
            ISourceType topLevelType;
            SourceTypeElementInfo sourceType;
            block15: {
                if (answer.type instanceof BinaryType) {
                    try {
                        return new NameEnvironmentAnswer((IBinaryType)((BinaryType)answer.type).getElementInfo(), answer.restriction);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                }
                sourceType = (SourceTypeElementInfo)((SourceType)answer.type).getElementInfo();
                if (answer.type.isBinary()) {
                    ICompilationUnit compUnit = (ICompilationUnit)((Object)answer.type.getClassFile());
                    return new NameEnvironmentAnswer(compUnit, answer.restriction);
                }
                topLevelType = sourceType;
                while (topLevelType.getEnclosingType() != null) {
                    topLevelType = topLevelType.getEnclosingType();
                }
                types = null;
                IJavaScriptUnit compilationUnit = sourceType.getHandle().getJavaScriptUnit();
                if (compilationUnit != null) {
                    types = compilationUnit.getTypes();
                } else if (sourceType.getHandle().getClassFile() != null) {
                    types = sourceType.getHandle().getClassFile().getTypes();
                }
                if (types != null && types.length != 0) break block15;
                return null;
            }
            try {
                ISourceType[] sourceTypes = new ISourceType[types.length];
                sourceTypes[0] = sourceType;
                int length = types.length;
                int i = 0;
                int index = 1;
                while (i < length) {
                    ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                    if (!otherType.equals(topLevelType) && index < length) {
                        sourceTypes[index++] = otherType;
                    }
                    ++i;
                }
                return new NameEnvironmentAnswer(sourceTypes, answer.restriction);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return null;
            }
        }
        return null;
    }

    protected NameEnvironmentAnswer findBinding(String typeName, String packageName, int type, boolean returnMultiple, String excludePath) {
        NameLookup.Answer answer;
        if (packageName == null) {
            packageName = "";
        }
        if ((answer = this.nameLookup.findBinding(typeName, packageName, type, false, 30, this.checkAccessRestrictions, returnMultiple, excludePath)) != null && answer.element != null) {
            if (answer.element instanceof IJavaScriptElement) {
                IOpenable openable = ((IJavaScriptElement)answer.element).getOpenable();
                ICompilationUnit compilationUnit = null;
                if (openable instanceof ClassFile) {
                    ClassFile classFile;
                    compilationUnit = classFile = (ClassFile)openable;
                } else {
                    if (openable instanceof MetadataFile) {
                        return new NameEnvironmentAnswer(((MetadataFile)openable).getAPIs());
                    }
                    if (openable instanceof ICompilationUnit) {
                        compilationUnit = (ICompilationUnit)((Object)openable);
                    }
                }
                return new NameEnvironmentAnswer(compilationUnit, answer.restriction);
            }
            if (answer.element != null && answer.element.getClass().isArray()) {
                Object[] elements = (Object[])answer.element;
                ICompilationUnit[] units = new ICompilationUnit[elements.length];
                System.arraycopy(elements, 0, units, 0, elements.length);
                return new NameEnvironmentAnswer(units, answer.restriction);
            }
        }
        return null;
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor));
    }

    public void findExactTypes(char[] name, final boolean findMembers, int searchFor, final ISearchRequestor storage) {
        try {
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaScriptElement)) {
                    this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    return;
                }
                excludePath = ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString();
            } else {
                excludePath = null;
            }
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] superTypeNames, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        return;
                    }
                    storage.acceptType(packageName, path.toCharArray(), simpleTypeName, enclosingTypeNames, modifiers, access);
                }
            };
            try {
                new BasicSearchEngine(this.workingCopies).searchAllTypeNames(name, 0, this.searchScope, typeRequestor, 2, new CancelableProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
                this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
        }
    }

    private void findExactTypes(String name, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.javaProject, this.nameLookup);
        this.nameLookup.seekTypes(name, null, false, type, requestor);
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName, ITypeRequestor requestor) {
        if (compoundTypeName == null) {
            return null;
        }
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(new String(compoundTypeName[lengthM1]), CharOperation.toString(packageName));
    }

    @Override
    public NameEnvironmentAnswer findBinding(char[] typeName, char[][] packageName, int type, ITypeRequestor requestor, boolean returnMultiple, String excludePath) {
        if (typeName == null) {
            return null;
        }
        return this.findBinding(new String(typeName), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName), type, returnMultiple, excludePath);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] name, char[][] packageName, ITypeRequestor requestor) {
        if (name == null) {
            return null;
        }
        return this.find(new String(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString(packageName));
    }

    public void findTypes(char[] prefix, final boolean findMembers, boolean camelCaseMatch, int searchFor, final ISearchRequestor storage) {
        try {
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaScriptElement)) {
                    this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    return;
                }
                excludePath = ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString();
            } else {
                excludePath = null;
            }
            CancelableProgressMonitor progressMonitor = new CancelableProgressMonitor();
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] superTypeNames, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        return;
                    }
                    storage.acceptType(packageName, path.toCharArray(), simpleTypeName, enclosingTypeNames, modifiers, access);
                }
            };
            try {
                int matchRule = 1;
                if (camelCaseMatch) {
                    matchRule |= 0x80;
                }
                new BasicSearchEngine(this.workingCopies).searchAllTypeNames(prefix, matchRule, this.searchScope, typeRequestor, 2, progressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.findTypes(new String(prefix), storage, 30);
        }
    }

    public void findBindings(char[] prefix, int bindingType, boolean camelCaseMatch, final ISearchRequestor storage) {
        try {
            char[] simpleName;
            char[] qualification;
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaScriptElement)) {
                    this.findBindings(new String(prefix), bindingType, storage, 30);
                    return;
                }
                excludePath = ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString();
            } else {
                excludePath = null;
            }
            int lastDotIndex = CharOperation.lastIndexOf('.', prefix);
            if (lastDotIndex < 0) {
                qualification = null;
                simpleName = camelCaseMatch ? prefix : CharOperation.toLowerCase(prefix);
            } else {
                qualification = CharOperation.subarray(prefix, 0, lastDotIndex);
                simpleName = camelCaseMatch ? CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length) : CharOperation.toLowerCase(CharOperation.subarray(prefix, lastDotIndex + 1, prefix.length));
            }
            CancelableProgressMonitor progressMonitor = new CancelableProgressMonitor();
            IRestrictedAccessBindingRequestor bindingRequestor = new IRestrictedAccessBindingRequestor(){
                String exclude;

                @Override
                public boolean acceptBinding(int type, int modifiers, char[] packageName, char[] simpleTypeName, String path, AccessRestriction access) {
                    if (this.exclude != null && this.exclude.equals(path)) {
                        return false;
                    }
                    if (excludePath != null && excludePath.equals(path)) {
                        return false;
                    }
                    storage.acceptBinding(packageName, path.toCharArray(), simpleTypeName, type, modifiers, access);
                    return true;
                }

                @Override
                public String getFoundPath() {
                    return null;
                }

                @Override
                public void reset() {
                }

                @Override
                public ArrayList getFoundPaths() {
                    return null;
                }

                @Override
                public void setExcludePath(String excludePath2) {
                    this.exclude = excludePath2;
                }
            };
            try {
                int matchRule = 1;
                if (camelCaseMatch) {
                    matchRule |= 0x80;
                }
                new BasicSearchEngine(this.workingCopies).searchAllBindingNames(qualification, simpleName, bindingType, matchRule, this.searchScope, bindingRequestor, 2, true, progressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.findBindings(new String(prefix), bindingType, storage, 30);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.findTypes(new String(prefix), storage, 30);
        }
    }

    public void findFunctions(char[] selectorPrefix, char[][] declaringTypeNames, boolean camelCaseMatch, final ISearchRequestor searchRequester) {
        int selectorPatternMatchRule;
        char[] selectorPattern;
        final String excludePath = this.unitToSkip != null && this.unitToSkip instanceof IJavaScriptElement ? ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString() : null;
        IFunctionRequester functionRequestor = new IFunctionRequester(){

            @Override
            public void acceptFunction(char[] signature, char[][] parameterFullyQualifiedTypeNames, char[][] parameterNames, char[] returnQualification, char[] returnSimpleName, char[] declaringQualification, char[] declaringSimpleName, int modifiers, String path) {
                if (excludePath == null || !excludePath.equals(path)) {
                    searchRequester.acceptFunction(signature, parameterFullyQualifiedTypeNames, parameterNames, returnQualification, returnSimpleName, declaringQualification, declaringSimpleName, modifiers, path);
                }
            }
        };
        if (selectorPrefix != null) {
            selectorPattern = selectorPrefix;
            selectorPatternMatchRule = 1;
        } else {
            selectorPattern = new char[]{'*'};
            selectorPatternMatchRule = 2;
        }
        if (camelCaseMatch) {
            selectorPatternMatchRule |= 0x80;
        }
        new BasicSearchEngine(this.workingCopies).searchAllFunctions(functionRequestor, selectorPattern, declaringTypeNames, selectorPatternMatchRule, this.searchScope, 3, new CancelableProgressMonitor());
    }

    public void findVariables(char[] variablePrefix, char[][] declaringTypeNames, boolean camelCaseMatch, final ISearchRequestor searchRequester) {
        int variablePatternMatchRule;
        char[] variablePattern;
        final String excludePath = this.unitToSkip != null && this.unitToSkip instanceof IJavaScriptElement ? ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString() : null;
        IVariableRequester variableRequestor = new IVariableRequester(){

            @Override
            public void acceptVariable(char[] signature, char[] typeQualification, char[] typeSimpleName, char[] declaringQualification, char[] declaringSimpleName, int modifiers, String path) {
                if (excludePath == null || !excludePath.equals(path)) {
                    searchRequester.acceptVariable(signature, typeQualification, typeSimpleName, declaringQualification, declaringSimpleName, modifiers, path);
                }
            }
        };
        if (variablePrefix != null) {
            variablePattern = variablePrefix;
            variablePatternMatchRule = 1;
        } else {
            variablePattern = new char[]{'*'};
            variablePatternMatchRule = 2;
        }
        if (camelCaseMatch) {
            variablePatternMatchRule |= 0x80;
        }
        new BasicSearchEngine(this.workingCopies).searchAllVariables(variableRequestor, variablePattern, declaringTypeNames, variablePatternMatchRule, this.searchScope, 3, new CancelableProgressMonitor());
    }

    public void findConstructorDeclarations(char[] prefix, boolean camelCaseMatch, final ISearchRequestor storage) {
        final String excludePath = this.unitToSkip != null && this.unitToSkip instanceof IJavaScriptElement ? ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString() : null;
        CancelableProgressMonitor progressMonitor = new CancelableProgressMonitor();
        IConstructorRequestor constructorRequestor = new IConstructorRequestor(){

            @Override
            public void acceptConstructor(int modifiers, char[] typeName, int parameterCount, char[][] parameterTypes, char[][] parameterNames, String path, AccessRestriction access) {
                if (excludePath != null && excludePath.equals(path)) {
                    return;
                }
                storage.acceptConstructor(modifiers, typeName, parameterTypes, parameterNames, path, access);
            }
        };
        int matchRule = 1;
        if (camelCaseMatch) {
            matchRule |= 0x80;
        }
        try {
            new BasicSearchEngine(this.workingCopies).searchAllConstructorDeclarations(prefix, matchRule, this.searchScope, constructorRequestor, 2, progressMonitor);
        }
        catch (OperationCanceledException e) {
            Logger.logException("Constructor search operation canceled.", e);
        }
    }

    private void findTypes(String prefix, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.javaProject, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                int i = 0;
                int length = fragments.length;
                while (i < length) {
                    if (fragments[i] != null) {
                        this.nameLookup.seekTypes(className, fragments[i], true, type, requestor);
                    }
                    ++i;
                }
            }
        }
    }

    private void findBindings(String prefix, int bindingType, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.javaProject, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index != -1) {
            throw new UnimplementedException("shouldnt get here");
        }
        this.nameLookup.seekBindings(prefix, bindingType, null, true, type, requestor);
    }

    public ArrayList findSuperTypes(char[] typeName) {
        final ArrayList superTypes = new ArrayList();
        final ArrayList<char[]> queue = new ArrayList<char[]>();
        ArrayList<char[]> alreadySearched = new ArrayList<char[]>();
        try {
            final String excludePath = this.unitToSkip != null ? ((IJavaScriptElement)((Object)this.unitToSkip)).getPath().toString() : null;
            char[] qualification = null;
            char[] simpleName = CharOperation.toLowerCase(typeName);
            queue.add(simpleName);
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] superTypeNames, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    boolean doAdd = true;
                    int i = 0;
                    while (i < superTypes.size()) {
                        if (CharOperation.equals(superTypeNames[0], (char[])superTypes.get(i))) {
                            doAdd = false;
                            break;
                        }
                        ++i;
                    }
                    if (doAdd) {
                        superTypes.add(superTypeNames[0]);
                    }
                    queue.add(superTypeNames[0]);
                }
            };
            try {
                while (!queue.isEmpty()) {
                    char[] nextSearch = (char[])queue.get(0);
                    boolean doSearch = true;
                    if (CharOperation.equals(nextSearch, IIndexConstants.OBJECT)) {
                        doSearch = false;
                    }
                    int i = 0;
                    while (doSearch && i < alreadySearched.size()) {
                        if (CharOperation.equals(nextSearch, (char[])alreadySearched.get(i))) {
                            doSearch = false;
                        }
                        ++i;
                    }
                    if (doSearch) {
                        alreadySearched.add(nextSearch);
                        new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, nextSearch, 0, this.searchScope, typeRequestor, 3, (IProgressMonitor)new CancelableProgressMonitor());
                    }
                    queue.remove(0);
                    doSearch = true;
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return superTypes;
    }

    @Override
    public boolean isPackage(char[][] parentPackageName, char[] subPackageName) {
        String[] pkgName;
        if (parentPackageName == null) {
            pkgName = new String[]{new String(subPackageName)};
        } else {
            int length = parentPackageName.length;
            pkgName = new String[length + 1];
            int i = 0;
            while (i < length) {
                pkgName[i] = new String(parentPackageName[i]);
                ++i;
            }
            pkgName[length] = new String(subPackageName);
        }
        return this.nameLookup.isPackage(pkgName);
    }

    protected String toStringChar(char[] name) {
        return "[" + new String(name) + "]";
    }

    protected String toStringCharChar(char[][] names) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            result.append(this.toStringChar(names[i]));
            ++i;
        }
        return result.toString();
    }

    @Override
    public void cleanup() {
    }

    public void setCompilationUnit(IInferenceFile file) {
        this.nameLookup.setScriptFile(file);
    }

    private static class CancelableProgressMonitor
    implements IProgressMonitor {
        boolean isCanceled = false;

        private CancelableProgressMonitor() {
        }

        @Override
        public void beginTask(String name, int totalWork) {
        }

        @Override
        public void done() {
        }

        @Override
        public void internalWorked(double work) {
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        @Override
        public void setCanceled(boolean value) {
            this.isCanceled = value;
        }

        @Override
        public void setTaskName(String name) {
        }

        @Override
        public void subTask(String name) {
        }

        @Override
        public void worked(int work) {
        }
    }
}

