/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.ReconcileContext;
import org.eclipse.wst.jsdt.core.compiler.ValidationParticipant;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ReconcileWorkingCopyOperation
extends JavaModelOperation {
    public static boolean PERF = false;
    public int astLevel;
    public boolean resolveBindings;
    public HashMap problems;
    public int reconcileFlags;
    WorkingCopyOwner workingCopyOwner;
    public JavaScriptUnit ast;
    public JavaElementDeltaBuilder deltaBuilder;
    public boolean requestorIsActive;

    public ReconcileWorkingCopyOperation(IJavaScriptElement workingCopy, int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner) {
        super(new IJavaScriptElement[]{workingCopy});
        this.astLevel = astLevel;
        this.reconcileFlags = reconcileFlags;
        this.workingCopyOwner = workingCopyOwner;
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        this.checkCanceled();
        try {
            JavaElementDelta delta;
            this.beginTask(Messages.element_reconciling, 2);
            CompilationUnit workingCopy = this.getWorkingCopy();
            boolean wasConsistent = workingCopy.isConsistent();
            IProblemRequestor problemRequestor = workingCopy.getPerWorkingCopyInfo();
            if (problemRequestor != null) {
                problemRequestor = problemRequestor.getProblemRequestor();
            }
            boolean defaultRequestorIsActive = problemRequestor != null && problemRequestor.isActive();
            IProblemRequestor ownerProblemRequestor = this.workingCopyOwner.getProblemRequestor(workingCopy);
            boolean ownerRequestorIsActive = ownerProblemRequestor != null && ownerProblemRequestor != problemRequestor && ownerProblemRequestor.isActive();
            this.requestorIsActive = defaultRequestorIsActive || ownerRequestorIsActive;
            this.deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
            this.makeConsistent(workingCopy);
            if (!wasConsistent || (this.reconcileFlags & 1) != 0) {
                this.notifyParticipants(workingCopy);
                if (this.ast == null && this.astLevel != 0) {
                    this.makeConsistent(workingCopy);
                }
            }
            if (!(this.problems == null || (this.reconcileFlags & 1) == 0 && wasConsistent)) {
                if (defaultRequestorIsActive) {
                    this.reportProblems(workingCopy, problemRequestor);
                }
                if (ownerRequestorIsActive) {
                    this.reportProblems(workingCopy, ownerProblemRequestor);
                }
            }
            if ((delta = this.deltaBuilder.delta) != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            this.done();
        }
    }

    private void reportProblems(CompilationUnit workingCopy, IProblemRequestor problemRequestor) {
        try {
            problemRequestor.beginReporting();
            block3: for (CategorizedProblem[] categorizedProblems : this.problems.values()) {
                if (categorizedProblems == null) continue;
                int i = 0;
                int length = categorizedProblems.length;
                while (i < length) {
                    CategorizedProblem problem = categorizedProblems[i];
                    if (JavaModelManager.VERBOSE) {
                        System.out.println("PROBLEM FOUND while reconciling : " + problem.getMessage());
                    }
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) continue block3;
                    problemRequestor.acceptProblem(problem);
                    ++i;
                }
            }
        }
        finally {
            problemRequestor.endReporting();
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public JavaScriptUnit makeConsistent(CompilationUnit workingCopy) throws JavaScriptModelException {
        if (!workingCopy.isConsistent()) {
            if (this.problems == null) {
                this.problems = new HashMap();
            }
            this.resolveBindings = this.requestorIsActive;
            this.ast = workingCopy.makeConsistent(this.astLevel, this.resolveBindings, this.reconcileFlags, this.problems, this.progressMonitor);
            this.deltaBuilder.buildDeltas();
            if (this.ast != null && this.deltaBuilder.delta != null) {
                this.deltaBuilder.delta.changedAST(this.ast);
            }
            return this.ast;
        }
        if (this.ast != null) {
            return this.ast;
        }
        CompilationUnitDeclaration unit = null;
        char[] contents = null;
        try {
            try {
                if (JavaProject.hasJavaNature(workingCopy.getJavaScriptProject().getProject()) && (this.reconcileFlags & 1) != 0) {
                    this.resolveBindings = this.requestorIsActive;
                    if (this.problems == null) {
                        this.problems = new HashMap();
                    }
                    contents = workingCopy.getContents();
                    unit = CompilationUnitProblemFinder.process(workingCopy, contents, this.workingCopyOwner, this.problems, this.astLevel != 0, this.reconcileFlags, this.progressMonitor);
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
                if (this.astLevel != 0) {
                    workingCopy.getJavaScriptProject().getOptions(true);
                    ASTParser parser = ASTParser.newParser(3);
                    parser.setSource(workingCopy);
                    this.ast = (JavaScriptUnit)parser.createAST(this.progressMonitor);
                    if (this.ast != null) {
                        this.deltaBuilder.delta = new JavaElementDelta(workingCopy);
                        this.deltaBuilder.delta.changedAST(this.ast);
                    }
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
            }
            catch (Exception e) {
                if (JavaProject.hasJavaNature(workingCopy.getJavaScriptProject().getProject())) {
                    throw e;
                }
                if (unit != null) {
                    unit.cleanUp();
                    if (unit.scope != null) {
                        unit.scope.cleanup();
                    }
                }
            }
        }
        finally {
            if (unit != null) {
                unit.cleanUp();
                if (unit.scope != null) {
                    unit.scope.cleanup();
                }
            }
        }
        return this.ast;
    }

    private void notifyParticipants(CompilationUnit workingCopy) {
        IJavaScriptProject javaProject = this.getWorkingCopy().getJavaScriptProject();
        ValidationParticipant[] participants = JavaModelManager.getJavaModelManager().validationParticipants.getvalidationParticipants(javaProject);
        if (participants == null) {
            return;
        }
        final ReconcileContext context = new ReconcileContext(this, workingCopy);
        int i = 0;
        int length = participants.length;
        while (i < length) {
            final ValidationParticipant participant = participants[i];
            SafeRunner.run(new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                    if (exception instanceof Error) {
                        throw (Error)exception;
                    }
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        Util.log(exception, "Reconcile participant attempted to modify the buffer of the working copy being reconciled");
                    } else {
                        Util.log(exception, "Exception occurred in reconcile participant");
                    }
                }

                @Override
                public void run() throws Exception {
                    participant.reconcile(context);
                }
            });
            ++i;
        }
    }

    @Override
    protected IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new JavaModelStatus(969, workingCopy);
        }
        return status;
    }
}

