/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferrenceManager;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.ResolutionConfiguration;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.IJavaElementRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaElementRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.JavaProjectElementInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SingleTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class NameLookup
implements SuffixConstants {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    public static final int ACCEPT_ENUMS = 8;
    public static final int ACCEPT_ANNOTATIONS = 16;
    public static final int ACCEPT_ALL = 30;
    public static boolean VERBOSE = false;
    private static final IType[] NO_TYPES = new IType[0];
    private static final IJavaScriptElement[] NO_BINDINGS = new IJavaScriptElement[0];
    private boolean searchFiles = true;
    protected IPackageFragmentRoot[] packageFragmentRoots;
    protected HashtableOfArrayToObject packageFragments;
    protected Map rootToResolvedEntries;
    protected HashMap typesInWorkingCopies;
    protected HashMap[] bindingsInWorkingCopies;
    public long timeSpentInSeekTypesInSourcePackage = 0L;
    public long timeSpentInSeekTypesInBinaryPackage = 0L;
    protected HashSet acceptedCUs = new HashSet();
    private IJavaScriptUnit[] workingCopies;
    IRestrictedAccessBindingRequestor restrictedRequestor;
    public static final boolean USE_BINDING_SEARCH = true;
    private HandleFactory handleFactory;
    protected IJavaScriptSearchScope searchScope;

    public NameLookup(IPackageFragmentRoot[] packageFragmentRoots, HashtableOfArrayToObject packageFragments, IJavaScriptUnit[] workingCopies, Map rootToResolvedEntries) {
        long start = -1L;
        if (VERBOSE) {
            Util.verbose(" BUILDING NameLoopkup");
            Util.verbose(" -> pkg roots size: " + (packageFragmentRoots == null ? 0 : packageFragmentRoots.length));
            Util.verbose(" -> pkgs size: " + (packageFragments == null ? 0 : packageFragments.size()));
            Util.verbose(" -> working copy size: " + (workingCopies == null ? 0 : workingCopies.length));
            start = System.currentTimeMillis();
        }
        this.packageFragmentRoots = packageFragmentRoots;
        if (workingCopies == null) {
            this.packageFragments = packageFragments;
        } else {
            try {
                this.packageFragments = (HashtableOfArrayToObject)packageFragments.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            this.typesInWorkingCopies = new HashMap();
            this.bindingsInWorkingCopies = new HashMap[16];
            int j = 0;
            while (j < 16) {
                this.bindingsInWorkingCopies[j] = new HashMap();
                ++j;
            }
            this.workingCopies = workingCopies;
            int i = 0;
            int length = workingCopies.length;
            while (i < length) {
                IJavaScriptUnit workingCopy = workingCopies[i];
                try {
                    IJavaScriptElement[] types = workingCopy.getTypes();
                    int typeLength = types.length;
                    if (typeLength == 0) {
                        String typeName = Util.getNameWithoutJavaLikeExtension(workingCopy.getElementName());
                        this.typesInWorkingCopies.put(typeName, NO_TYPES);
                    } else {
                        int j2 = 0;
                        while (j2 < typeLength) {
                            IType type = types[j2];
                            String typeName = type.getElementName();
                            Object existing = this.typesInWorkingCopies.get(typeName);
                            if (existing == null) {
                                this.typesInWorkingCopies.put(typeName, type);
                            } else if (existing instanceof IType) {
                                this.typesInWorkingCopies.put(typeName, new IType[]{(IType)existing, type});
                            } else {
                                IType[] existingTypes = (IType[])existing;
                                int existingTypeLength = existingTypes.length;
                                IType[] iTypeArray = existingTypes;
                                existingTypes = new IType[existingTypeLength + 1];
                                System.arraycopy(iTypeArray, 0, existingTypes, 0, existingTypeLength);
                                existingTypes[existingTypeLength] = type;
                                this.typesInWorkingCopies.put(typeName, existingTypes);
                            }
                            ++j2;
                        }
                    }
                    this.addWorkingCopyBindings(types, this.bindingsInWorkingCopies[4]);
                    this.addWorkingCopyBindings(workingCopy.getFields(), this.bindingsInWorkingCopies[3]);
                    this.addWorkingCopyBindings(workingCopy.getFields(), this.bindingsInWorkingCopies[2]);
                    this.addWorkingCopyBindings(workingCopy.getFunctions(), this.bindingsInWorkingCopies[8]);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                PackageFragment pkg = (PackageFragment)workingCopy.getParent();
                IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
                Object[] pkgName = pkg.names;
                Object existing = this.packageFragments.get(pkgName);
                if (existing == null || existing == JavaProjectElementInfo.NO_ROOTS) {
                    this.packageFragments.put(pkgName, root);
                    JavaProjectElementInfo.addSuperPackageNames((String[])pkgName, this.packageFragments);
                } else if (existing instanceof PackageFragmentRoot) {
                    if (!existing.equals(root)) {
                        this.packageFragments.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                    }
                } else {
                    IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])existing;
                    int rootLength = roots.length;
                    boolean containsRoot = false;
                    int j3 = 0;
                    while (j3 < rootLength) {
                        if (roots[j3].equals(root)) {
                            containsRoot = true;
                            break;
                        }
                        ++j3;
                    }
                    if (containsRoot) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        roots = new IPackageFragmentRoot[rootLength + 1];
                        System.arraycopy(iPackageFragmentRootArray, 0, roots, 0, rootLength);
                        roots[rootLength] = root;
                        this.packageFragments.put(pkgName, roots);
                    }
                }
                ++i;
            }
        }
        this.rootToResolvedEntries = rootToResolvedEntries;
        if (VERBOSE) {
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void setRestrictedAccessRequestor(IRestrictedAccessBindingRequestor restrictedRequestor) {
        this.restrictedRequestor = restrictedRequestor;
    }

    protected IRestrictedAccessBindingRequestor getRestrictedAccessRequestor() {
        if (this.restrictedRequestor == null) {
            this.restrictedRequestor = new IRestrictedAccessBindingRequestor(){
                ArrayList foundPaths = new ArrayList();
                String excludePath;

                @Override
                public void setExcludePath(String excludePath) {
                    this.excludePath = excludePath;
                }

                @Override
                public boolean acceptBinding(int type, int modifiers, char[] packageName, char[] simpleTypeName, String path, AccessRestriction access) {
                    if (path == null) {
                        return false;
                    }
                    if (this.excludePath != null && path.equals(this.excludePath)) {
                        return false;
                    }
                    if (!this.foundPaths.contains(path)) {
                        this.foundPaths.add(path);
                    }
                    return true;
                }

                @Override
                public String getFoundPath() {
                    return this.foundPaths.size() > 0 ? (String)this.foundPaths.get(0) : null;
                }

                @Override
                public void reset() {
                    this.foundPaths.clear();
                }

                @Override
                public ArrayList getFoundPaths() {
                    return this.foundPaths;
                }
            };
        }
        return this.restrictedRequestor;
    }

    private void addWorkingCopyBindings(IJavaScriptElement[] elements, HashMap bindingsMap) {
        int j = 0;
        while (j < elements.length) {
            IJavaScriptElement element = elements[j];
            String elementName = element.getElementName();
            Object existing = bindingsMap.get(elementName);
            if (existing == null) {
                bindingsMap.put(elementName, element);
            } else if (existing instanceof IJavaScriptElement) {
                bindingsMap.put(elementName, new IJavaScriptElement[]{(IJavaScriptElement)existing, element});
            } else {
                IJavaScriptElement[] existingElements = (IJavaScriptElement[])existing;
                int existingElementsLength = existingElements.length;
                IJavaScriptElement[] iJavaScriptElementArray = existingElements;
                existingElements = new IJavaScriptElement[existingElementsLength + 1];
                System.arraycopy(iJavaScriptElementArray, 0, existingElements, 0, existingElementsLength);
                existingElements[existingElementsLength] = element;
                bindingsMap.put(elementName, existingElements);
            }
            ++j;
        }
    }

    protected boolean acceptType(IType type, int acceptFlags, boolean isSourceType) {
        if (!type.exists()) {
            return false;
        }
        if (acceptFlags == 0 || acceptFlags == 30) {
            return true;
        }
        try {
            int kind = TypeDeclaration.kind(((SourceTypeElementInfo)((SourceType)type).getElementInfo()).getModifiers());
            switch (kind) {
                case 1: {
                    return (acceptFlags & 2) != 0;
                }
            }
            return (acceptFlags & 0x10) != 0;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    protected boolean doAcceptBinding(IJavaScriptElement element, int bindingType, boolean isSourceType, IJavaElementRequestor requestor) {
        switch (bindingType) {
            case 9: {
                if (element instanceof IFunction) {
                    requestor.acceptMethod((IFunction)element);
                    return true;
                }
                if (element instanceof IField) {
                    requestor.acceptField((IField)element);
                    return true;
                }
                return false;
            }
            case 1: 
            case 3: {
                if (element instanceof IField) {
                    requestor.acceptField((IField)element);
                    return true;
                }
                return false;
            }
            case 8: {
                if (element instanceof IFunction) {
                    requestor.acceptMethod((IFunction)element);
                    return true;
                }
            }
            case 4: {
                if (!(element instanceof IType)) break;
                requestor.acceptType((IType)element);
                return true;
            }
        }
        return false;
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.packageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                IJavaScriptElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void findAllBindings(String prefix, int bindingType, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.packageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                IJavaScriptElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekBindings(prefix, bindingType, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ITypeRoot findCompilationUnit(String qualifiedTypeName) {
        Object[] pkgName = CharOperation.NO_STRINGS;
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = Util.splitOn('.', qualifiedTypeName, 0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        cuName = cuName.replace('#', '.');
        Object value = this.packageFragments.get(pkgName);
        if (value != null) {
            if (value instanceof PackageFragmentRoot) {
                return this.findCompilationUnit((String[])pkgName, cuName, (PackageFragmentRoot)value);
            }
            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
            int i = 0;
            while (i < roots.length) {
                PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                ITypeRoot cu = this.findCompilationUnit((String[])pkgName, cuName, root);
                if (cu != null) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    private ITypeRoot findCompilationUnit(String[] pkgName, String cuName, PackageFragmentRoot root) {
        if (!root.isArchive()) {
            PackageFragment pkg = root.getPackageFragment(pkgName);
            try {
                IJavaScriptUnit[] cus = pkg.getJavaScriptUnits();
                int j = 0;
                int length = cus.length;
                while (j < length) {
                    IJavaScriptUnit cu = cus[j];
                    if (Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), cuName)) {
                        return cu;
                    }
                    ++j;
                }
                IClassFile[] classFiles = pkg.getClassFiles();
                int j2 = 0;
                int length2 = classFiles.length;
                while (j2 < length2) {
                    IClassFile cu = classFiles[j2];
                    if (Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), cuName)) {
                        return cu;
                    }
                    ++j2;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        IResource possibleFragment = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.packageFragmentRoots.length) {
                block22: {
                    IPath rootPath;
                    int matchingCount;
                    IPackageFragmentRoot root = this.packageFragmentRoots[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IJavaScriptElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (JavaScriptModelException javaScriptModelException) {
                            break block22;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IPackageFragment packageFragment = (IPackageFragment)list[j];
                            if (this.nameMatches(name, packageFragment, false)) {
                                return packageFragment;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else {
            IJavaScriptElement fromFactory = JavaScriptCore.create(possibleFragment);
            if (fromFactory == null) {
                return null;
            }
            switch (fromFactory.getElementType()) {
                case 4: {
                    return (IPackageFragment)fromFactory;
                }
                case 2: {
                    JavaProject project = (JavaProject)fromFactory;
                    try {
                        IIncludePathEntry entry = project.getClasspathEntryFor(path);
                        if (entry != null) {
                            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
                            Object defaultPkgRoot = this.packageFragments.get(CharOperation.NO_STRINGS);
                            if (defaultPkgRoot == null) {
                                return null;
                            }
                            if (defaultPkgRoot instanceof PackageFragmentRoot && defaultPkgRoot.equals(root)) {
                                return ((PackageFragmentRoot)root).getPackageFragment(CharOperation.NO_STRINGS);
                            }
                            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])defaultPkgRoot;
                            int i = 0;
                            while (i < roots.length) {
                                if (roots[i].equals(root)) {
                                    return ((PackageFragmentRoot)root).getPackageFragment(CharOperation.NO_STRINGS);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((PackageFragmentRoot)fromFactory).getPackageFragment(CharOperation.NO_STRINGS);
                }
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        return this.findPackageFragments(name, partialMatch, false);
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch, boolean patternMatch) {
        ArrayList<IPackageFragment> fragRootChildren = new ArrayList<IPackageFragment>();
        int i = 0;
        while (i < this.packageFragmentRoots.length) {
            try {
                IJavaScriptElement[] children = this.packageFragmentRoots[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    IPackageFragment packageFragment = (IPackageFragment)children[j];
                    if (packageFragment != null && packageFragment.getElementName().equals(name)) {
                        fragRootChildren.add(packageFragment);
                    }
                    ++j;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        return fragRootChildren.toArray(new IPackageFragment[fragRootChildren.size()]);
    }

    private IType findSecondaryType(String packageName, String typeName, IJavaScriptProject project, boolean waitForIndexes, IProgressMonitor monitor) {
        if (JavaModelManager.VERBOSE) {
            Util.verbose("NameLookup FIND SECONDARY TYPES:");
            Util.verbose(" -> pkg name: " + packageName);
            Util.verbose(" -> type name: " + typeName);
            Util.verbose(" -> project: " + project.getElementName());
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IType type;
            Map types;
            IJavaScriptProject javaProject = project;
            Map secondaryTypePaths = manager.secondaryTypes(javaProject, waitForIndexes, monitor);
            if (secondaryTypePaths.size() > 0 && (types = (Map)secondaryTypePaths.get(packageName == null ? "" : packageName)) != null && types.size() > 0 && (type = (IType)types.get(typeName)) != null) {
                if (JavaModelManager.VERBOSE) {
                    Util.verbose(" -> type: " + type.getElementName());
                }
                return type;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return null;
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        if (this.searchFiles) {
            Answer answer = this.findBindingSearch(typeName, packageName, 4, partialMatch, acceptFlags, true, true, checkRestrictions, null, false, null);
            if (answer != null && answer.type == null && answer.element instanceof ITypeRoot) {
                ITypeRoot typeroot = (ITypeRoot)answer.element;
                answer.type = typeroot.getType(typeName);
            }
            return answer;
        }
        return this.findType(typeName, packageName, partialMatch, acceptFlags, true, false, checkRestrictions, null);
    }

    public Answer findBinding(String typeName, String packageName, int type, boolean partialMatch, int acceptFlags, boolean checkRestrictions, boolean returnMultiple, String excludePath) {
        if ((type & 0x2000) != 0) {
            ITypeRoot compilationUnit;
            String fullName = typeName;
            if (packageName.length() > 0) {
                fullName = String.valueOf(packageName) + "." + typeName;
            }
            if ((compilationUnit = this.findCompilationUnit(fullName)) != null) {
                return new Answer(compilationUnit, null);
            }
            if ((type &= 0xFFFFDFFF) == 0) {
                return null;
            }
        }
        if ((type & 0x4000) != 0 && (type &= 0xFFFFBFFF) == 0) {
            return null;
        }
        if (this.searchFiles) {
            return this.findBindingSearch(typeName, packageName, type, partialMatch, acceptFlags, true, false, checkRestrictions, null, returnMultiple, excludePath);
        }
        return this.findBinding(typeName, packageName, type, partialMatch, acceptFlags, true, false, checkRestrictions, null);
    }

    public IJavaScriptUnit[] findTypeSources(String typeName, boolean waitForIndexes) {
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments("", false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        IType type = null;
        int length = packages.length;
        HashSet<IJavaScriptProject> projects = null;
        IJavaScriptProject javaProject = null;
        ArrayList<IType> found = new ArrayList<IType>();
        int i = 0;
        while (i < length) {
            type = this.findType(typeName, packages[i], false, 30);
            if (type != null && type.exists()) {
                found.add(type);
            }
            if (javaProject == null) {
                javaProject = packages[i].getJavaScriptProject();
            } else if (projects == null) {
                if (!javaProject.equals(packages[i].getJavaScriptProject())) {
                    projects = new HashSet<IJavaScriptProject>(3);
                    projects.add(javaProject);
                    projects.add(packages[i].getJavaScriptProject());
                }
            } else {
                projects.add(packages[i].getJavaScriptProject());
            }
            ++i;
        }
        if (javaProject != null) {
            if (projects == null) {
                type = this.findSecondaryType("", typeName, javaProject, waitForIndexes, new NullProgressMonitor());
            } else {
                Iterator allProjects = projects.iterator();
                while (type == null && allProjects.hasNext()) {
                    type = this.findSecondaryType("", typeName, (IJavaScriptProject)allProjects.next(), waitForIndexes, new NullProgressMonitor());
                }
            }
        }
        return null;
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && ScannerHelper.isLowerCase(typeName.charAt(0)) && this.findPackageFragments(String.valueOf(packageName) + "." + typeName, false) != null) {
            return null;
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        IType type = null;
        int length = packages.length;
        HashSet<IJavaScriptProject> projects = null;
        IJavaScriptProject javaProject = null;
        Answer suggestedAnswer = null;
        int i = 0;
        while (i < length) {
            type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                Answer answer;
                AccessRestriction accessRestriction = null;
                if (checkRestrictions) {
                    accessRestriction = this.getViolatedRestriction(typeName, packageName, type, accessRestriction);
                }
                if (!(answer = new Answer(type, accessRestriction)).ignoreIfBetter()) {
                    if (answer.isBetter(suggestedAnswer)) {
                        return answer;
                    }
                } else if (answer.isBetter(suggestedAnswer)) {
                    suggestedAnswer = answer;
                }
            } else if (suggestedAnswer == null && considerSecondaryTypes) {
                if (javaProject == null) {
                    javaProject = packages[i].getJavaScriptProject();
                } else if (projects == null) {
                    if (!javaProject.equals(packages[i].getJavaScriptProject())) {
                        projects = new HashSet<IJavaScriptProject>(3);
                        projects.add(javaProject);
                        projects.add(packages[i].getJavaScriptProject());
                    }
                } else {
                    projects.add(packages[i].getJavaScriptProject());
                }
            }
            ++i;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        if (considerSecondaryTypes && javaProject != null) {
            if (projects == null) {
                type = this.findSecondaryType(packageName, typeName, javaProject, waitForIndexes, monitor);
            } else {
                Iterator allProjects = projects.iterator();
                while (type == null && allProjects.hasNext()) {
                    type = this.findSecondaryType(packageName, typeName, (IJavaScriptProject)allProjects.next(), waitForIndexes, monitor);
                }
            }
        }
        return type == null ? null : new Answer(type, null);
    }

    public Answer findBinding(String bindingName, String packageName, int bindingType, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (bindingName.length() > 0 && ScannerHelper.isLowerCase(bindingName.charAt(0)) && this.findPackageFragments(String.valueOf(packageName) + "." + bindingName, false) != null) {
            return null;
        }
        if (VERBOSE) {
            System.out.println("find binding: " + bindingName);
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        IJavaScriptElement element = null;
        int length = packages.length;
        HashSet<IJavaScriptProject> projects = null;
        IJavaScriptProject javaProject = null;
        Answer suggestedAnswer = null;
        int i = 0;
        while (i < length) {
            element = this.findBinding(bindingName, bindingType, packages[i], partialMatch, acceptFlags);
            if (element != null) {
                AccessRestriction accessRestriction = null;
                if (checkRestrictions) {
                    accessRestriction = this.getViolatedRestriction(bindingName, packageName, element, accessRestriction);
                }
                char[] path = null;
                if (element instanceof SourceTypeBinding) {
                    path = ((SourceTypeBinding)((Object)element)).getFileName();
                } else if (element instanceof ReferenceBinding) {
                    path = ((ReferenceBinding)((Object)element)).getFileName();
                } else if (element instanceof SourceType) {
                    path = ((SourceType)element).getPath().toString().toCharArray();
                }
                if (path != null && !this.getRestrictedAccessRequestor().acceptBinding(bindingType, acceptFlags, packageName.toCharArray(), bindingName.toCharArray(), new String(path), accessRestriction)) {
                    element = null;
                } else {
                    Answer answer = new Answer(element, accessRestriction);
                    if (!answer.ignoreIfBetter()) {
                        if (answer.isBetter(suggestedAnswer)) {
                            return answer;
                        }
                    } else if (answer.isBetter(suggestedAnswer)) {
                        suggestedAnswer = answer;
                    }
                }
            } else if (suggestedAnswer == null && considerSecondaryTypes) {
                if (javaProject == null) {
                    javaProject = packages[i].getJavaScriptProject();
                } else if (projects == null) {
                    if (!javaProject.equals(packages[i].getJavaScriptProject())) {
                        projects = new HashSet<IJavaScriptProject>(3);
                        projects.add(javaProject);
                        projects.add(packages[i].getJavaScriptProject());
                    }
                } else {
                    projects.add(packages[i].getJavaScriptProject());
                }
            }
            ++i;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return element == null ? null : new Answer(element, null);
    }

    private AccessRestriction getViolatedRestriction(String typeName, String packageName, IType type, AccessRestriction accessRestriction) {
        AccessRuleSet accessRuleSet;
        PackageFragmentRoot root = (PackageFragmentRoot)type.getAncestor(3);
        ClasspathEntry entry = (ClasspathEntry)this.rootToResolvedEntries.get(root);
        if (entry != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
            char[][] packageChars = CharOperation.splitOn('.', packageName.toCharArray());
            char[] typeChars = typeName.toCharArray();
            accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, typeChars, '/'));
        }
        return accessRestriction;
    }

    private AccessRestriction getViolatedRestriction(String typeName, String packageName, Object element, AccessRestriction accessRestriction) {
        return accessRestriction;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes) {
        IType type = this.findType(name, pkg, partialMatch, acceptFlags);
        if (type == null && considerSecondaryTypes) {
            type = this.findSecondaryType(pkg.getElementName(), name, pkg.getJavaScriptProject(), false, null);
        }
        return type;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor);
        return typeRequestor.getType();
    }

    public IJavaScriptElement findBinding(String name, int type, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        JavaElementRequestor requestor = new JavaElementRequestor();
        this.seekBindings(name, type, pkg, partialMatch, acceptFlags, requestor);
        IField[] fields = requestor.getFields();
        IFunction[] methods = requestor.getMethods();
        IType[] types = requestor.getTypes();
        switch (type) {
            case 9: {
                if (methods.length > 0) {
                    return methods[0];
                }
            }
            case 1: {
                return fields.length > 0 ? fields[0] : null;
            }
            case 8: {
                return methods.length > 0 ? methods[0] : null;
            }
            case 4: 
            case 16388: {
                return types.length > 0 ? types[0] : null;
            }
        }
        if ((4 & type) != 0 && types.length > 0) {
            return types[0];
        }
        if ((8 & type) != 0 && methods.length > 0) {
            return methods[0];
        }
        if ((3 & type) != 0 && fields.length > 0) {
            return fields[0];
        }
        return null;
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        Answer answer = this.findType(name, partialMatch, acceptFlags, false);
        return answer == null ? null : answer.type;
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        return this.findType(name, partialMatch, acceptFlags, true, true, checkRestrictions, null);
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        String className = null;
        String packageName = null;
        packageName = "";
        className = name;
        if (this.searchFiles) {
            return this.findBindingSearch(className, packageName, 4, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, monitor, true, null);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, monitor);
    }

    private IType getMemberType(IType type, String name, int dot) {
        return type;
    }

    public boolean isPackage(String[] pkgName) {
        return this.packageFragments.get(pkgName) != null;
    }

    protected boolean nameMatches(String searchName, IJavaScriptElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    protected boolean nameMatches(String searchName, IJavaScriptUnit cu, boolean partialMatch) {
        if (partialMatch) {
            return cu.getElementName().toLowerCase().startsWith(searchName);
        }
        return Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        int i = 0;
        while (i < this.packageFragmentRoots.length) {
            try {
                if (this.searchFiles || this.packageFragmentRoots[i].isLibrary()) {
                    IJavaScriptElement[] children = this.packageFragmentRoots[i].getChildren();
                    int j = 0;
                    while (j < children.length) {
                        requestor.acceptPackageFragment((IPackageFragment)children[j]);
                        ++j;
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int firstDot = -1;
            String topLevelTypeName = matchName;
            int packageFlavor = root.getKind();
            if (this.typesInWorkingCopies != null && this.seekTypesInWorkingCopies(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor)) {
                return;
            }
            switch (packageFlavor) {
                case 2: {
                    this.seekBindingsInBinaryPackage(matchName, 4, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
    }

    public void seekBindings(String name, int bindingType, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (pkg == null) {
            this.findAllBindings(matchName, bindingType, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int firstDot = -1;
            String topLevelTypeName = null;
            int packageFlavor = root.getKind();
            if (this.typesInWorkingCopies != null || packageFlavor == 1) {
                firstDot = matchName.indexOf(46);
                if (!partialMatch) {
                    String string2 = topLevelTypeName = firstDot == -1 ? matchName : matchName.substring(0, firstDot);
                }
            }
            if (this.bindingsInWorkingCopies != null && this.seekBindingsInWorkingCopies(matchName, bindingType, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor)) {
                return;
            }
            switch (packageFlavor) {
                case 2: {
                    this.seekBindingsInBinaryPackage(matchName, bindingType, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekBindingsInSourcePackage(matchName, bindingType, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
    }

    protected void seekBindingsInBinaryPackage(String name, int bindingType, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            this.acceptedCUs.clear();
            IJavaScriptElement[] classFiles = null;
            try {
                classFiles = pkg.getChildren();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                if (VERBOSE) {
                    this.timeSpentInSeekTypesInBinaryPackage += System.currentTimeMillis() - start;
                }
                return;
            }
            int length = classFiles.length;
            if (!partialMatch) {
                int i = 0;
                while (i < length) {
                    ClassFile classFile = (ClassFile)classFiles[i];
                    if (!this.acceptedCUs.contains(classFile)) {
                        switch (bindingType) {
                            case 4: 
                            case 16388: {
                                IType type = classFile.getType(name);
                                if (!this.acceptType(type, acceptFlags, false)) break;
                                this.acceptedCUs.add(classFile);
                                requestor.acceptType(type);
                                break;
                            }
                            case 3: {
                                IField field = classFile.getField(name);
                                if (!field.exists()) break;
                                this.acceptedCUs.add(classFile);
                                requestor.acceptField(field);
                                break;
                            }
                            case 8: {
                                IFunction method = classFile.getFunction(name, null);
                                if (!method.exists()) break;
                                this.acceptedCUs.add(classFile);
                                requestor.acceptMethod(method);
                                break;
                            }
                            case 11: {
                                IFunction method = classFile.getFunction(name, null);
                                if (method != null && method.exists()) {
                                    this.acceptedCUs.add(classFile);
                                    requestor.acceptMethod(method);
                                    break;
                                }
                                IField field = classFile.getField(name);
                                if (field == null || !field.exists()) break;
                                this.acceptedCUs.add(classFile);
                                requestor.acceptField(field);
                                break;
                            }
                            default: {
                                IType thisType;
                                IFunction method;
                                IField field;
                                if ((4 & bindingType) != 0 && this.acceptType(thisType = classFile.getType(name), acceptFlags, false)) {
                                    this.acceptedCUs.add(classFile);
                                    requestor.acceptType(thisType);
                                }
                                if ((8 & bindingType) != 0 && (method = classFile.getFunction(name, null)) != null && method.exists()) {
                                    this.acceptedCUs.add(classFile);
                                    requestor.acceptMethod(method);
                                }
                                if ((3 & bindingType) == 0 || (field = classFile.getField(name)) == null || !field.exists()) break;
                                this.acceptedCUs.add(classFile);
                                requestor.acceptField(field);
                            }
                        }
                    }
                    ++i;
                }
            } else {
                String unqualifiedName = name;
                int matchLength = name.length();
                int i = 0;
                if (i < length) {
                }
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekTypesInBinaryPackage += System.currentTimeMillis() - start;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            if (!partialMatch) {
                try {
                    IJavaScriptElement[] compilationUnits = pkg.getChildren();
                    int i = 0;
                    int length = compilationUnits.length;
                    if (i >= length) return;
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return;
                }
                {
                }
            }
            try {
                String cuPrefix = firstDot == -1 ? name : name.substring(0, firstDot);
                IJavaScriptElement[] compilationUnits = pkg.getChildren();
                int i = 0;
                int length = compilationUnits.length;
                if (i >= length) return;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return;
            }
            {
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekTypesInSourcePackage += System.currentTimeMillis() - start;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void seekBindingsInSourcePackage(String name, int bindingType, IPackageFragment pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            if (!partialMatch) {
                try {
                    IJavaScriptElement[] compilationUnits = pkg.getChildren();
                    int i = 0;
                    int length = compilationUnits.length;
                    if (i >= length) return;
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return;
                }
                {
                }
            }
            try {
                String cuPrefix = firstDot == -1 ? name : name.substring(0, firstDot);
                IJavaScriptElement[] compilationUnits = pkg.getChildren();
                int i = 0;
                int length = compilationUnits.length;
                if (i >= length) return;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return;
            }
            {
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekTypesInSourcePackage += System.currentTimeMillis() - start;
            }
        }
    }

    protected boolean seekTypesInType(String prefix, int firstDot, IType type, IJavaElementRequestor requestor, int acceptFlags) {
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        int length = types.length;
        if (length == 0) {
            return false;
        }
        String memberPrefix = prefix;
        boolean isMemberTypePrefix = false;
        if (firstDot != -1) {
            memberPrefix = prefix.substring(0, firstDot);
            isMemberTypePrefix = true;
        }
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return false;
            }
            IType memberType = types[i];
            if (memberType.getElementName().toLowerCase().startsWith(memberPrefix)) {
                if (isMemberTypePrefix) {
                    String subPrefix = prefix.substring(firstDot + 1, prefix.length());
                    return this.seekTypesInType(subPrefix, subPrefix.indexOf(46), memberType, requestor, acceptFlags);
                }
                if (this.acceptType(memberType, acceptFlags, true)) {
                    requestor.acceptMemberType(memberType);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean seekTypesInTopLevelType(String prefix, int firstDot, IType topLevelType, IJavaElementRequestor requestor, int acceptFlags) {
        if (!topLevelType.getElementName().toLowerCase().startsWith(prefix)) {
            return false;
        }
        if (firstDot == -1) {
            if (this.acceptType(topLevelType, acceptFlags, true)) {
                requestor.acceptType(topLevelType);
                return true;
            }
        } else {
            return this.seekTypesInType(prefix, firstDot, topLevelType, requestor, acceptFlags);
        }
        return false;
    }

    protected boolean seekTypesInWorkingCopies(String name, IPackageFragment pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor) {
        block11: {
            block10: {
                Object object;
                block12: {
                    if (partialMatch) break block10;
                    HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
                    if (typeMap == null) break block11;
                    object = typeMap.get(topLevelTypeName);
                    if (!(object instanceof IType)) break block12;
                    IType type = this.getMemberType((IType)object, name, firstDot);
                    if (this.acceptType(type, acceptFlags, true)) {
                        requestor.acceptType(type);
                        return true;
                    }
                    break block11;
                }
                if (!(object instanceof IType[])) break block11;
                if (object == NO_TYPES) {
                    return true;
                }
                IType[] topLevelTypes = (IType[])object;
                int i = 0;
                int length = topLevelTypes.length;
                while (i < length) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    IType type = this.getMemberType(topLevelTypes[i], name, firstDot);
                    if (this.acceptType(type, acceptFlags, true)) {
                        requestor.acceptType(type);
                        return true;
                    }
                    ++i;
                }
                break block11;
            }
            HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
            if (typeMap != null) {
                Iterator iterator = typeMap.values().iterator();
                while (iterator.hasNext()) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    Object object = iterator.next();
                    if (object instanceof IType) {
                        this.seekTypesInTopLevelType(name, firstDot, (IType)object, requestor, acceptFlags);
                        continue;
                    }
                    if (!(object instanceof IType[])) continue;
                    IType[] topLevelTypes = (IType[])object;
                    int i = 0;
                    int length = topLevelTypes.length;
                    while (i < length) {
                        this.seekTypesInTopLevelType(name, firstDot, topLevelTypes[i], requestor, acceptFlags);
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    private boolean checkBindingAccept(String topLevelTypeName, HashMap[] bindingsMap, int bindingType, IJavaElementRequestor requestor) {
        Object object = bindingsMap[bindingType].get(topLevelTypeName);
        if (object instanceof IJavaScriptElement) {
            if (this.doAcceptBinding((IJavaScriptElement)object, bindingType, true, requestor)) {
                return true;
            }
        } else if (object instanceof IJavaScriptElement[]) {
            if (object == NO_BINDINGS) {
                return true;
            }
            IJavaScriptElement[] topLevelElements = (IJavaScriptElement[])object;
            boolean isAnyBindingAccepted = false;
            int i = 0;
            int length = topLevelElements.length;
            while (i < length) {
                if (requestor.isCanceled()) {
                    return false;
                }
                if (this.doAcceptBinding(topLevelElements[i], bindingType, true, requestor)) {
                    isAnyBindingAccepted = true;
                }
                ++i;
            }
            return isAnyBindingAccepted;
        }
        return false;
    }

    protected boolean seekBindingsInWorkingCopies(String name, int bindingType, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor) {
        bindingType &= 0xF;
        if (!partialMatch) {
            HashMap[] bindingsMap;
            HashMap[] hashMapArray = bindingsMap = this.bindingsInWorkingCopies == null ? null : this.bindingsInWorkingCopies;
            if (bindingsMap != null) {
                if (this.checkBindingAccept(topLevelTypeName, bindingsMap, bindingType, requestor)) {
                    return true;
                }
                if ((bindingType & 3) > 0 && bindingType != 3 && this.checkBindingAccept(topLevelTypeName, bindingsMap, 3, requestor)) {
                    return true;
                }
                if ((bindingType & 2) > 0 && bindingType != 2 && this.checkBindingAccept(topLevelTypeName, bindingsMap, 2, requestor)) {
                    return true;
                }
                if ((bindingType & 8) > 0 && bindingType != 8 && this.checkBindingAccept(topLevelTypeName, bindingsMap, 8, requestor)) {
                    return true;
                }
                if ((bindingType & 4) > 0 && bindingType != 4 && this.checkBindingAccept(topLevelTypeName, bindingsMap, 4, requestor)) {
                    return true;
                }
            }
        } else {
            HashMap[] bindingsMap;
            HashMap[] hashMapArray = bindingsMap = this.bindingsInWorkingCopies == null ? null : this.bindingsInWorkingCopies;
            if (bindingsMap != null) {
                Iterator iterator = bindingsMap[bindingType].values().iterator();
                while (iterator.hasNext()) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    Object object = iterator.next();
                    if (object instanceof IType) {
                        this.seekTypesInTopLevelType(name, firstDot, (IType)object, requestor, acceptFlags);
                        continue;
                    }
                    if (!(object instanceof IType[])) continue;
                    IType[] topLevelTypes = (IType[])object;
                    int i = 0;
                    int length = topLevelTypes.length;
                    while (i < length) {
                        this.seekTypesInTopLevelType(name, firstDot, topLevelTypes[i], requestor, acceptFlags);
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Answer findBindingSearch(String bindingName, String packageName, int bindingType, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor progressMonitor, boolean returnMultiple, String exclude) {
        ArrayList<IOpenable> foundAnswers;
        block20: {
            if (this.searchScope == null) {
                this.searchScope = BasicSearchEngine.createJavaSearchScope(this.packageFragmentRoots);
            }
            foundAnswers = new ArrayList<IOpenable>();
            Path excludePath = exclude != null ? new Path(exclude) : null;
            class MyRequestor
            implements IJavaElementRequestor {
                ArrayList element;

                MyRequestor() {
                }

                @Override
                public void acceptField(IField field) {
                    if (this.element == null) {
                        this.element = new ArrayList();
                    }
                    this.element.add(field);
                }

                @Override
                public void acceptInitializer(IInitializer initializer) {
                }

                @Override
                public void acceptMemberType(IType type) {
                    if (this.element == null) {
                        this.element = new ArrayList();
                    }
                    this.element.add(type);
                }

                @Override
                public void acceptMethod(IFunction method) {
                    if (this.element == null) {
                        this.element = new ArrayList();
                    }
                    this.element.add(method);
                }

                @Override
                public void acceptPackageFragment(IPackageFragment packageFragment) {
                }

                @Override
                public void acceptType(IType type) {
                    if (this.element == null) {
                        this.element = new ArrayList();
                    }
                    this.element.add(type);
                }

                @Override
                public boolean isCanceled() {
                    return false;
                }
            }
            MyRequestor requestor = new MyRequestor();
            new JavaElementRequestor();
            this.seekBindingsInWorkingCopies(bindingName, bindingType, -1, partialMatch, bindingName, acceptFlags, requestor);
            if (requestor.element != null) {
                int i = 0;
                while (i < requestor.element.size()) {
                    IOpenable openable = ((IJavaScriptElement)requestor.element.get(i)).getOpenable();
                    if (excludePath == null || !((IJavaScriptElement)requestor.element.get(i)).getPath().equals(excludePath)) {
                        if (!returnMultiple) {
                            return new Answer(openable, null);
                        }
                        foundAnswers.add(openable);
                    }
                    ++i;
                }
                requestor.element = null;
            }
            try {
                IRestrictedAccessBindingRequestor bindingAcceptor = this.getRestrictedAccessRequestor();
                if (exclude != null) {
                    exclude = exclude.replace('\\', '/');
                }
                bindingAcceptor.setExcludePath(exclude);
                try {
                    int matchRule = 8;
                    new BasicSearchEngine().searchAllBindingNames(CharOperation.NO_CHAR, bindingName.toCharArray(), bindingType, matchRule, this.searchScope, bindingAcceptor, 1, false, progressMonitor);
                    if (bindingAcceptor.getFoundPath() == null) break block20;
                    Object[] foundPaths = bindingAcceptor.getFoundPaths().toArray();
                    int i = 0;
                    while (true) {
                        Openable openable;
                        if (i >= foundPaths.length) {
                            if (foundAnswers.size() > 0 && returnMultiple) {
                                Answer answer = new Answer(foundAnswers.toArray(), null);
                                return answer;
                            }
                            break;
                        }
                        String path = (String)foundPaths[i];
                        if (this.handleFactory == null) {
                            this.handleFactory = new HandleFactory();
                        }
                        if ((openable = this.handleFactory.createOpenable(path, this.searchScope)) != null) {
                            if (!returnMultiple) {
                                Answer answer = new Answer(openable, null);
                                return answer;
                            }
                            foundAnswers.add(openable);
                        }
                        ++i;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    Answer answer = this.findBinding(bindingName, packageName, bindingType, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, progressMonitor);
                    return answer;
                }
                finally {
                    bindingAcceptor.reset();
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return this.findBinding(bindingName, packageName, bindingType, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, progressMonitor);
            }
        }
        if (foundAnswers.size() <= 0) return null;
        if (!returnMultiple) return null;
        return new Answer(foundAnswers.toArray(), null);
    }

    public IOpenable createOpenable(String resourcePath, IJavaScriptSearchScope scope) {
        if (this.packageFragmentRoots == null) {
            return null;
        }
        Path resourceP = new Path(resourcePath);
        int i = 0;
        while (i < this.packageFragmentRoots.length) {
            int resourceSegs;
            int rootSegs;
            IPackageFragmentRoot root = this.packageFragmentRoots[i];
            IPath fragPath = root.getPath();
            String fileName = resourceP.lastSegment();
            IPath rootPostFix = null;
            if (root.isLanguageRuntime() && (rootSegs = fragPath.segmentCount()) > (resourceSegs = resourceP.segmentCount())) {
                rootPostFix = fragPath.removeFirstSegments(rootSegs - resourceSegs).setDevice(null).makeAbsolute();
            }
            if (fragPath.isPrefixOf(resourceP) || rootPostFix != null && rootPostFix.equals(resourceP.makeAbsolute())) {
                if (root instanceof LibraryFragmentRoot) {
                    IClassFile file = root.getPackageFragment(root.getPath().toString()).getClassFile(root.getPath().toString());
                    return file;
                }
                if (resourceP.toFile().exists()) {
                    IClassFile file = root.getPackageFragment(resourcePath).getClassFile(resourcePath);
                    return file;
                }
                String pkgName = resourcePath.substring(fragPath.toString().length());
                int indexName = pkgName.indexOf(fileName);
                if (indexName > -1) {
                    pkgName = pkgName.substring(0, indexName - 1);
                }
                IJavaScriptUnit file = root.getPackageFragment(pkgName).getJavaScriptUnit(fileName);
                return file;
            }
            ++i;
        }
        return null;
    }

    public void setScriptFile(IInferenceFile compUnit) {
        InferrenceProvider[] inferenceProviders = InferrenceManager.getInstance().getInferenceProviders(compUnit);
        if (inferenceProviders != null && inferenceProviders.length > 0) {
            int i = 0;
            while (i < inferenceProviders.length) {
                ResolutionConfiguration resolutionConfiguration = inferenceProviders[i].getResolutionConfiguration();
                if (resolutionConfiguration != null) {
                    this.searchFiles = resolutionConfiguration.searchAllFiles();
                }
                if (!this.searchFiles) break;
                ++i;
            }
        }
    }

    public static class Answer {
        public IType type;
        public Object element;
        AccessRestriction restriction;

        Answer(IType type, AccessRestriction restriction) {
            this.type = type;
            this.restriction = restriction;
        }

        Answer(Object element, AccessRestriction restriction) {
            this.element = element;
            this.restriction = restriction;
        }

        public boolean ignoreIfBetter() {
            return this.restriction != null && this.restriction.ignoreIfBetter();
        }

        public boolean isBetter(Answer otherAnswer) {
            if (otherAnswer == null) {
                return true;
            }
            if (this.restriction == null) {
                return true;
            }
            return otherAnswer.restriction != null && this.restriction.getProblemId() < otherAnswer.restriction.getProblemId();
        }
    }
}

