/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.JarEntryResource;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class JarEntryFile
extends JarEntryResource {
    private static final IJarEntryResource[] NO_CHILDREN = new IJarEntryResource[0];

    public JarEntryFile(String simpleName) {
        super(simpleName);
    }

    @Override
    public JarEntryResource clone(Object newParent) {
        JarEntryFile file = new JarEntryFile(this.simpleName);
        file.setParent(newParent);
        return file;
    }

    @Override
    public InputStream getContents() throws CoreException {
        ZipFile zipFile = null;
        try {
            String entryName;
            ZipEntry zipEntry;
            zipFile = this.getZipFile();
            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + zipFile.getName());
            }
            if ((zipEntry = zipFile.getEntry(entryName = this.getEntryName())) == null) {
                throw new JavaScriptModelException(new JavaModelStatus(979, entryName));
            }
            byte[] contents = Util.getZipEntryByteContent(zipEntry, zipFile);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new JavaScriptModelException(e, 985);
        }
        finally {
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
        }
    }

    @Override
    public IJarEntryResource[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.getEntryName() + "]";
    }
}

