/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IExportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ExportContainer;
import org.eclipse.wst.jsdt.internal.core.ExportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;

public class ExportDeclaration
extends SourceRefElement
implements IExportDeclaration {
    protected String name;

    protected ExportDeclaration(ExportContainer parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExportDeclaration)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 16;
    }

    public int getFlags() throws JavaScriptModelException {
        ExportDeclarationElementInfo info = (ExportDeclarationElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu = (CompilationUnit)this.parent.getParent();
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getExport(this.getElementName());
    }

    @Override
    public String readableName() {
        return null;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("export ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

