/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.ClasspathValidation;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.ProjectReferenceChange;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int[] preResourceChangeEventMasks = new int[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal deltaProcessors = new ThreadLocal();
    public HashMap roots = new HashMap();
    public HashMap otherRoots = new HashMap();
    public HashMap oldRoots = new HashMap();
    public HashMap oldOtherRoots = new HashMap();
    public HashMap sourceAttachments = new HashMap();
    public HashMap projectDependencies = new HashMap();
    public boolean rootsAreStale = true;
    private Set initializingThreads = Collections.synchronizedSet(new HashSet());
    public Hashtable externalTimeStamps;
    private HashMap classpathValidations = new HashMap();
    private HashMap projectReferenceChanges = new HashMap();
    private HashSet javaProjectNamesCache;

    public synchronized void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i] == listener) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                int n = i;
                this.elementChangedListenerMasks[n] = this.elementChangedListenerMasks[n] | eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public synchronized void addPreResourceChangedListener(IResourceChangeListener listener, int eventMask) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i] == listener) {
                int n = i;
                this.preResourceChangeEventMasks[n] = this.preResourceChangeEventMasks[n] | eventMask;
                return;
            }
            ++i;
        }
        int length = this.preResourceChangeListeners.length;
        if (length == this.preResourceChangeListenerCount) {
            this.preResourceChangeListeners = new IResourceChangeListener[length * 2];
            System.arraycopy(this.preResourceChangeListeners, 0, this.preResourceChangeListeners, 0, length);
            this.preResourceChangeEventMasks = new int[length * 2];
            System.arraycopy(this.preResourceChangeEventMasks, 0, this.preResourceChangeEventMasks, 0, length);
        }
        this.preResourceChangeListeners[this.preResourceChangeListenerCount] = listener;
        this.preResourceChangeEventMasks[this.preResourceChangeListenerCount] = eventMask;
        ++this.preResourceChangeListenerCount;
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = (DeltaProcessor)this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, JavaModelManager.getJavaModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    public synchronized ClasspathValidation addClasspathValidation(JavaProject project) {
        ClasspathValidation validation = (ClasspathValidation)this.classpathValidations.get(project);
        if (validation == null) {
            validation = new ClasspathValidation(project);
            this.classpathValidations.put(project, validation);
        }
        return validation;
    }

    public synchronized void addProjectReferenceChange(JavaProject project, IIncludePathEntry[] oldResolvedClasspath) {
        ProjectReferenceChange change = (ProjectReferenceChange)this.projectReferenceChanges.get(project);
        if (change == null) {
            change = new ProjectReferenceChange(project, oldResolvedClasspath);
            this.projectReferenceChanges.put(project, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeRoots() {
        HashMap<IPath, DeltaProcessor.RootInfo> newRoots = null;
        HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>> newOtherRoots = null;
        HashMap<IPath, IPath> newSourceAttachments = null;
        HashMap<IJavaScriptProject, IJavaScriptProject[]> newProjectDependencies = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                IJavaScriptProject[] projects;
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                JavaModelManager.getJavaModelManager().batchContainerInitializations = true;
                newRoots = new HashMap<IPath, DeltaProcessor.RootInfo>();
                newOtherRoots = new HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>>();
                newSourceAttachments = new HashMap<IPath, IPath>();
                newProjectDependencies = new HashMap<IJavaScriptProject, IJavaScriptProject[]>();
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                try {
                    projects = model.getJavaScriptProjects();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    if (addedCurrentThread) {
                        this.initializingThreads.remove(currentThread);
                    }
                    return;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    block30: {
                        IIncludePathEntry[] classpath;
                        JavaProject project = (JavaProject)projects[i];
                        try {
                            classpath = project.getResolvedClasspath();
                        }
                        catch (JavaScriptModelException javaScriptModelException) {
                            break block30;
                        }
                        int j = 0;
                        int classpathLength = classpath.length;
                        while (j < classpathLength) {
                            IIncludePathEntry entry = classpath[j];
                            if (entry.getEntryKind() == 2) {
                                IJavaScriptProject key = model.getJavaScriptProject(entry.getPath().segment(0));
                                IJavaScriptProject[] dependents = (IJavaScriptProject[])newProjectDependencies.get(key);
                                if (dependents == null) {
                                    dependents = new IJavaScriptProject[]{project};
                                } else {
                                    int dependentsLength = dependents.length;
                                    IJavaScriptProject[] iJavaScriptProjectArray = dependents;
                                    dependents = new IJavaScriptProject[dependentsLength + 1];
                                    System.arraycopy(iJavaScriptProjectArray, 0, dependents, 0, dependentsLength);
                                    dependents[dependentsLength] = project;
                                }
                                newProjectDependencies.put(key, dependents);
                            } else {
                                IPath path = entry.getPath();
                                if (newRoots.get(path) == null) {
                                    newRoots.put(path, new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                } else {
                                    ArrayList<DeltaProcessor.RootInfo> rootList = (ArrayList<DeltaProcessor.RootInfo>)newOtherRoots.get(path);
                                    if (rootList == null) {
                                        rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                        newOtherRoots.put(path, rootList);
                                    }
                                    rootList.add(new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                }
                                if (entry.getEntryKind() == 1) {
                                    int index;
                                    String propertyString = null;
                                    try {
                                        propertyString = Util.getSourceAttachmentProperty(path);
                                    }
                                    catch (JavaScriptModelException e) {
                                        e.printStackTrace();
                                    }
                                    IPath sourceAttachmentPath = propertyString != null ? ((index = propertyString.lastIndexOf(42)) < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index))) : entry.getSourceAttachmentPath();
                                    if (sourceAttachmentPath != null) {
                                        newSourceAttachments.put(sourceAttachmentPath, path);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (this.rootsAreStale && newRoots != null) {
                this.roots = newRoots;
                this.otherRoots = newOtherRoots;
                this.sourceAttachments = newSourceAttachments;
                this.projectDependencies = newProjectDependencies;
                this.rootsAreStale = false;
            }
        }
    }

    public synchronized ClasspathValidation[] removeClasspathValidations() {
        int length = this.classpathValidations.size();
        if (length == 0) {
            return null;
        }
        ClasspathValidation[] validations = new ClasspathValidation[length];
        this.classpathValidations.values().toArray(validations);
        this.classpathValidations.clear();
        return validations;
    }

    public synchronized ProjectReferenceChange[] removeProjectReferenceChanges() {
        int length = this.projectReferenceChanges.size();
        if (length == 0) {
            return null;
        }
        ProjectReferenceChange[] updates = new ProjectReferenceChange[length];
        this.projectReferenceChanges.values().toArray(updates);
        this.projectReferenceChanges.clear();
        return updates;
    }

    public synchronized void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i] == listener) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    public synchronized void removePreResourceChangedListener(IResourceChangeListener listener) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i] == listener) {
                int length = this.preResourceChangeListeners.length;
                IResourceChangeListener[] newListeners = new IResourceChangeListener[length];
                int[] newEventMasks = new int[length];
                System.arraycopy(this.preResourceChangeListeners, 0, newListeners, 0, i);
                System.arraycopy(this.preResourceChangeEventMasks, 0, newEventMasks, 0, i);
                int trailingLength = this.preResourceChangeListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.preResourceChangeListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.preResourceChangeEventMasks, i + 1, newEventMasks, i, trailingLength);
                }
                this.preResourceChangeListeners = newListeners;
                this.preResourceChangeEventMasks = newEventMasks;
                --this.preResourceChangeListenerCount;
                return;
            }
            ++i;
        }
    }

    @Override
    public void resourceChanged(final IResourceChangeEvent event) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            final IResourceChangeListener listener = this.preResourceChangeListeners[i];
            if ((this.preResourceChangeEventMasks[i] & event.getType()) != 0) {
                SafeRunner.run(new ISafeRunnable(){

                    @Override
                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre Java resource change notification");
                    }

                    @Override
                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
            ++i;
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (event.getType() == 1) {
                this.deltaProcessors.set(null);
            }
        }
    }

    public Hashtable getExternalLibTimeStamps() {
        if (this.externalTimeStamps == null) {
            Hashtable<IPath, Long> timeStamps;
            block17: {
                timeStamps = new Hashtable<IPath, Long>();
                File timestampsFile = this.getTimeStampsFile();
                FilterInputStream in = null;
                try {
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                        int size = ((DataInputStream)in).readInt();
                        while (size-- > 0) {
                            String key = ((DataInputStream)in).readUTF();
                            long timestamp = ((DataInputStream)in).readLong();
                            timeStamps.put(Path.fromPortableString(key), timestamp);
                        }
                    }
                    catch (IOException e) {
                        if (timestampsFile.exists()) {
                            Util.log(e, "Unable to read external time stamps");
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.externalTimeStamps = timeStamps;
        }
        return this.externalTimeStamps;
    }

    public IJavaScriptProject findJavaProject(String name) {
        if (this.getOldJavaProjecNames().contains(name)) {
            return JavaModelManager.getJavaModelManager().getJavaModel().getJavaScriptProject(name);
        }
        return null;
    }

    public synchronized HashSet getOldJavaProjecNames() {
        if (this.javaProjectNamesCache == null) {
            IJavaScriptProject[] projects;
            HashSet<String> result = new HashSet<String>();
            try {
                projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaScriptProjects();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return this.javaProjectNamesCache;
            }
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaScriptProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.javaProjectNamesCache = result;
            return this.javaProjectNamesCache;
        }
        return this.javaProjectNamesCache;
    }

    public synchronized void resetOldJavaProjectNames() {
        this.javaProjectNamesCache = null;
    }

    private File getTimeStampsFile() {
        return JavaScriptCore.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    public void saveExternalLibTimeStamps() throws CoreException {
        if (this.externalTimeStamps == null) {
            return;
        }
        File timestamps = this.getTimeStampsFile();
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(timestamps)));
                ((DataOutputStream)out).writeInt(this.externalTimeStamps.size());
                for (Map.Entry entry : this.externalTimeStamps.entrySet()) {
                    IPath key = (IPath)entry.getKey();
                    ((DataOutputStream)out).writeUTF(key.toPortableString());
                    Long timestamp = (Long)entry.getValue();
                    ((DataOutputStream)out).writeLong(timestamp);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.wst.jsdt.core", 4, "Problems while saving timestamps", (Throwable)e);
                throw new CoreException(status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        HashMap otherUpdatedRoots;
        HashMap updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        int containerSegmentCount = containerPath.segmentCount();
        boolean containerIsProject = containerSegmentCount == 1;
        for (Map.Entry entry : updatedRoots.entrySet()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            IPath path = (IPath)entry.getKey();
            if (!containerPath.isPrefixOf(path) || containerPath.equals(path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(containerSegmentCount))) == null) continue;
            DeltaProcessor.RootInfo rootInfo2 = (DeltaProcessor.RootInfo)entry.getValue();
            if (!containerIsProject || !rootInfo2.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
            if ((rootList = (ArrayList)otherUpdatedRoots.get(path)) == null) continue;
            for (DeltaProcessor.RootInfo rootInfo2 : rootList) {
                if (containerIsProject && rootInfo2.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
        }
    }
}

