/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreatePackageFragmentOperation
extends JavaModelOperation {
    protected String[] pkgName;

    public CreatePackageFragmentOperation(IPackageFragmentRoot parentElement, String packageName, boolean force) {
        super(null, new IJavaScriptElement[]{parentElement}, force);
        this.pkgName = packageName == null ? null : Util.getTrimmedSimpleNames(packageName);
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            JavaElementDelta delta = null;
            PackageFragmentRoot root = (PackageFragmentRoot)this.getParentElement();
            this.beginTask(Messages.operation_createPackageFragmentProgress, this.pkgName.length);
            IContainer parentFolder = (IContainer)root.getResource();
            String[] sideEffectPackageName = CharOperation.NO_STRINGS;
            ArrayList<PackageFragment> results = new ArrayList<PackageFragment>(this.pkgName.length);
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            int i = 0;
            while (i < this.pkgName.length) {
                String subFolderName = this.pkgName[i];
                sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
                IResource subFolder = parentFolder.findMember(subFolderName);
                if (subFolder == null) {
                    this.createFolder(parentFolder, subFolderName, this.force);
                    parentFolder = parentFolder.getFolder(new Path(subFolderName));
                    PackageFragment addedFrag = root.getPackageFragment(sideEffectPackageName);
                    if (!Util.isExcluded(parentFolder, inclusionPatterns, exclusionPatterns)) {
                        if (delta == null) {
                            delta = this.newJavaElementDelta();
                        }
                        delta.added(addedFrag);
                    }
                    results.add(addedFrag);
                } else {
                    parentFolder = (IContainer)subFolder;
                }
                this.worked(1);
                ++i;
            }
            if (results.size() > 0) {
                this.resultElements = new IJavaScriptElement[results.size()];
                results.toArray(this.resultElements);
                if (delta != null) {
                    this.addDelta(delta);
                }
            }
        }
        finally {
            this.done();
        }
    }

    @Override
    public IJavaScriptModelStatus verify() {
        IJavaScriptElement parentElement = this.getParentElement();
        if (parentElement == null) {
            return new JavaModelStatus(968);
        }
        String packageName = this.pkgName == null ? null : Util.concatWith(this.pkgName, '.');
        IJavaScriptProject project = parentElement.getJavaScriptProject();
        if (this.pkgName == null || this.pkgName.length > 0 && JavaScriptConventions.validatePackageName(packageName, project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, packageName);
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        if (root.isReadOnly()) {
            return new JavaModelStatus(976, root);
        }
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < this.pkgName.length) {
            IResource subFolder = parentFolder.findMember(this.pkgName[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

