/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ASTHolderCUInfo;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.ClassFileInfo;
import org.eclipse.wst.jsdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClassFile
extends Openable
implements IClassFile,
SuffixConstants,
ICompilationUnit,
IVirtualParent {
    protected String name;
    protected IPath filePath;
    protected BinaryType binaryType = null;
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IFunction[] NO_METHODS = new IFunction[0];

    protected ClassFile(PackageFragment parent, String path) {
        super(parent);
        this.filePath = Path.fromOSString(path);
        if (this.filePath.getFileExtension() != null) {
            String lastSegment = this.filePath.lastSegment();
            this.name = lastSegment.substring(0, lastSegment.length() - (this.filePath.getFileExtension().length() + 1));
        } else {
            this.name = path;
        }
    }

    public IJavaScriptUnit becomeWorkingCopy(IProblemRequestor problemRequestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        ClassFileWorkingCopy workingCopy;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner), false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
            operation.runOperation(monitor);
            return workingCopy;
        }
        return perWorkingCopyInfo.workingCopy;
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        Hashtable options;
        int reconcileFlags;
        boolean createAST;
        IStatus status = this.validateClassFile();
        if (!status.isOK()) {
            throw this.newJavaModelException(status);
        }
        if (underlyingResource != null && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        CompilationUnitElementInfo unitInfo = new CompilationUnitElementInfo();
        CompilationUnitStructureRequestor requestor = new CompilationUnitStructureRequestor(this, unitInfo, newElements);
        IJavaScriptProject project = this.getJavaScriptProject();
        if (info instanceof ASTHolderCUInfo) {
            ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
            createAST = astHolder.astLevel != 0;
            boolean cfr_ignored_0 = astHolder.resolveBindings;
            reconcileFlags = astHolder.reconcileFlags;
        } else {
            createAST = false;
            reconcileFlags = 0;
        }
        boolean computeProblems = false;
        DefaultProblemFactory problemFactory = new DefaultProblemFactory();
        Map map = options = project == null ? JavaScriptCore.getOptions() : project.getOptions(true);
        if (!computeProblems) {
            options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
        }
        SourceElementParser parser = new SourceElementParser(requestor, problemFactory, new CompilerOptions(options), true, !createAST);
        parser.reportOnlyOneSyntaxError = !computeProblems;
        parser.setStatementsRecovery((reconcileFlags & 2) != 0);
        requestor.parser = parser;
        CompilationUnitDeclaration unit = parser.parseCompilationUnit(this, true);
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        if (underlyingResource != null) {
            unitInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        }
        info.setChildren(unitInfo.children);
        try {
            if (createAST) {
                throw new RuntimeException("Implement this");
            }
        }
        finally {
            if (unit != null) {
                unit.cleanUp();
            }
        }
        return true;
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaScriptModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaScriptModelException {
        String source = this.getSource();
        if (source != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, type.sourceFileName((IBinaryType)type.getElementInfo()), this.getJavaScriptProject());
            this.codeComplete(cu, cu, offset, requestor, owner);
        }
    }

    @Override
    public IJavaScriptElement[] codeSelect(int offset, int length) throws JavaScriptModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IJavaScriptElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaScriptModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            PackageFragment packageFragment = (PackageFragment)this.getParent();
            String[] names = packageFragment.names;
            char[][] pkgNames = new char[names.length][];
            int i = 0;
            while (i < names.length) {
                pkgNames[i] = names[i].toCharArray();
                ++i;
            }
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, pkgNames, this.filePath.toOSString());
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaScriptElement[0];
    }

    @Override
    protected Object createElementInfo() {
        return new ClassFileInfo();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClassFile)) {
            return false;
        }
        ClassFile other = (ClassFile)o;
        return this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    @Override
    public boolean exists() {
        return super.exists() && this.validateClassFile().isOK();
    }

    protected IJavaScriptElement findElement(IJavaScriptElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaScriptElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaScriptElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return elt;
    }

    @Override
    public IType findPrimaryType() {
        IType primaryType = this.getType();
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaScriptModelException {
        return this.getType().getAttachedJavadoc(monitor);
    }

    @Override
    public byte[] getBytes() throws JavaScriptModelException {
        JavaElement cfr_ignored_0 = (JavaElement)this.getParent();
        IFile file = (IFile)this.getResource();
        return Util.getResourceContentsAsByteArray(file);
    }

    @Override
    public IClassFile getClassFile() {
        return this;
    }

    public ITypeRoot getTypeRoot() {
        return this;
    }

    @Override
    public IResource getCorrespondingResource() throws JavaScriptModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    @Override
    public IJavaScriptElement getElementAt(int position) throws JavaScriptModelException {
        IJavaScriptElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        return this.findElement(this, position, mapper);
    }

    public IJavaScriptElement getElementAtConsideringSibling(int position) throws JavaScriptModelException {
        IPackageFragment fragment = (IPackageFragment)this.getParent();
        PackageFragmentRoot root = (PackageFragmentRoot)fragment.getAncestor(3);
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        int prefixLength = this.name.length();
        IType type = null;
        int start = -1;
        int end = Integer.MAX_VALUE;
        IJavaScriptElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            String childName = children[i].getElementName();
            int childPrefixLength = childName.indexOf(46);
            if (prefixLength == childPrefixLength && this.name.regionMatches(0, childName, 0, prefixLength)) {
                IClassFile classFile = (IClassFile)children[i];
                classFile.getBuffer();
                SourceRange range = mapper.getSourceRange(classFile.getType());
                if (range != SourceMapper.UNKNOWN_RANGE) {
                    int newStart = range.offset;
                    int newEnd = newStart + range.length - 1;
                    if (newStart > start && newEnd < end && newStart <= position && newEnd >= position) {
                        type = classFile.getType();
                        start = newStart;
                        end = newEnd;
                    }
                }
            }
            ++i;
        }
        if (type != null) {
            return this.findElement(type, position, mapper);
        }
        return null;
    }

    @Override
    public String getElementName() {
        if (this.name != null && this.name.toUpperCase().endsWith(".js".toUpperCase())) {
            return this.name;
        }
        return String.valueOf(this.name) + ".js";
    }

    @Override
    public int getElementType() {
        return 6;
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '(';
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if ((root instanceof LibraryFragmentRoot || this.getParent() instanceof PackageFragment && ((PackageFragment)this.getParent()).getKind() == 2) && root.getPath().lastSegment().equalsIgnoreCase(this.getElementName())) {
                ((JavaElement)this.getParent()).getHandleMemento(buff);
                buff.append(this.getHandleMementoDelimiter());
                this.escapeMementoName(buff, this.getPath().toPortableString());
            } else {
                super.getHandleMemento(buff);
            }
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        Object me = JavaModel.getTarget(workspace.getRoot(), this.getPath(), true);
        if (me != null) {
            return true;
        }
        me = JavaModel.getTarget(workspace.getRoot(), this.getPath().makeRelative(), true);
        return me != null;
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive() || root instanceof LibraryFragmentRoot && root.getPath().lastSegment().equalsIgnoreCase(this.getElementName())) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!root.isResourceContainer()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile(new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws JavaScriptModelException {
        this.openBuffer(monitor, this.createElementInfo());
    }

    @Override
    public ISourceRange getSourceRange() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    public String getTopLevelTypeName() {
        String topLevelTypeName = this.getElementName();
        topLevelTypeName = topLevelTypeName.substring(0, topLevelTypeName.length() - SUFFIX_JAVA.length);
        return topLevelTypeName;
    }

    @Override
    public IType getType() {
        if (this.binaryType == null) {
            this.binaryType = new BinaryType(this, this.getTypeName());
        }
        return this.binaryType;
    }

    public String getTypeName() {
        return this.name;
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    @Override
    public boolean isClass() throws JavaScriptModelException {
        return this.getType().isClass();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2 && ((PackageFragment)this.getParent()).getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaScriptModelException e) {
            return e.getJavaScriptModelStatus();
        }
        IJavaScriptProject project = this.getJavaScriptProject();
        return JavaScriptConventions.validateClassFileName(this.getElementName(), project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true));
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaScriptModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper, info instanceof IBinaryType ? (IBinaryType)info : null);
        }
        return null;
    }

    private IBuffer mapSource(SourceMapper mapper, IBinaryType info) {
        BufferManager bufManager;
        IBuffer buffer;
        char[] contents = null;
        String fileEncoding = null;
        try {
            IResource resource = this.getResource();
            fileEncoding = resource != null && resource instanceof IFile ? ((IFile)resource).getCharset() : null;
        }
        catch (CoreException coreException) {}
        try {
            IPath rootpath = this.getAncestor(3).getPath();
            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(rootpath.lastSegment())) {
                ZipFile zip = JavaModelManager.getJavaModelManager().getZipFile(rootpath);
                String entryName = this.filePath.toString();
                if (!((IPackageFragment)this.getAncestor(4)).isDefaultPackage()) {
                    entryName = String.valueOf(((IPackageFragment)this.getAncestor(4)).getElementName()) + "/" + entryName;
                }
                byte[] bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(zip.getEntry(entryName), zip);
                contents = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, fileEncoding);
            } else {
                contents = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(new File(this.filePath.toOSString()), fileEncoding);
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (contents != null) {
            buffer = BufferManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            return buffer;
        }
        buffer = BufferManager.createNullBuffer(this);
        if (buffer == null) {
            return null;
        }
        bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    static String simpleName(char[] className) {
        if (className == null) {
            return null;
        }
        String simpleName = new String(ClassFile.unqualifiedName(className));
        return simpleName;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        int i = 0;
        while (i < nameLength) {
            newName[i] = name[i] == '/' ? 46 : name[i];
            ++i;
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        int i = 0;
        while (i < length) {
            newNames[i] = ClassFile.translatedName(names[i]);
            ++i;
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        int i = className.length - 1;
        while (i > -1) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }

    @Override
    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    @Override
    public IField[] getFields() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    @Override
    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    @Override
    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public IFunction[] getMethods() throws JavaScriptModelException {
        return this.getFunctions();
    }

    @Override
    public IFunction[] getFunctions() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IFunction[] array = new IFunction[size];
        list.toArray(array);
        return array;
    }

    @Override
    public IType[] getTypes() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public char[] getContents() {
        String fileEncoding = null;
        try {
            IResource resource = this.getResource();
            fileEncoding = resource != null && resource instanceof IFile ? ((IFile)resource).getCharset() : null;
        }
        catch (CoreException coreException) {}
        char[] chars = null;
        try {
            if (this.name.indexOf(124) > 0) {
                ZipFile zip = JavaModelManager.getJavaModelManager().getZipFile(this.getAncestor(3).getPath());
                String entryName = this.filePath.lastSegment().substring(this.name.indexOf(124) + 1);
                if (!((IPackageFragment)this.getAncestor(4)).isDefaultPackage()) {
                    entryName = String.valueOf(((IPackageFragment)this.getAncestor(4)).getElementName()) + "/" + entryName;
                }
                byte[] bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(zip.getEntry(entryName), zip);
                chars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, fileEncoding);
            } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(this.getAncestor(3).getPath().lastSegment())) {
                ZipFile zip = JavaModelManager.getJavaModelManager().getZipFile(this.getAncestor(3).getPath());
                String entryName = this.filePath.toString();
                if (!((IPackageFragment)this.getAncestor(4)).isDefaultPackage()) {
                    entryName = String.valueOf(((IPackageFragment)this.getAncestor(4)).getElementName()) + "/" + entryName;
                }
                byte[] bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(zip.getEntry(entryName), zip);
                chars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, fileEncoding);
            } else {
                chars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(new File(this.filePath.toOSString()), fileEncoding);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return chars;
    }

    @Override
    public char[] getMainTypeName() {
        return this.name.toCharArray();
    }

    @Override
    public char[][] getPackageName() {
        PackageFragment packageFragment = (PackageFragment)this.getParent();
        if (packageFragment == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return Util.toCharArrays(packageFragment.names);
    }

    @Override
    public char[] getFileName() {
        return this.filePath != null ? this.filePath.toString().toCharArray() : this.getElementName().toCharArray();
    }

    @Override
    public String getDisplayName() {
        if (this.isVirtual()) {
            JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
            if (init == null) {
                return super.getDisplayName();
            }
            return init.getDescription(new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return super.getDisplayName();
    }

    @Override
    public URI getHostPath() {
        JsGlobalScopeContainerInitializer init;
        if (this.isVirtual() && (init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer()) != null) {
            return init.getHostPath(new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return null;
    }

    @Override
    public LibrarySuperType getCommonSuperType() {
        return null;
    }

    @Override
    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
        return init;
    }

    @Override
    public String getInferenceID() {
        JsGlobalScopeContainerInitializer containerInitializer = this.getContainerInitializer();
        if (containerInitializer != null) {
            return containerInitializer.getInferenceID();
        }
        return null;
    }

    @Override
    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        SearchableEnvironment env = super.newSearchableNameEnvironment(owner);
        env.setCompilationUnit(this);
        return env;
    }
}

