/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.search;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.TypeNameMatchRequestorWrapper;
import org.eclipse.wst.jsdt.internal.core.search.TypeNameRequestorWrapper;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeSynonymsPattern;

public class SearchEngine {
    private BasicSearchEngine basicEngine;

    public SearchEngine() {
        this.basicEngine = new BasicSearchEngine();
    }

    public SearchEngine(IJavaScriptUnit[] workingCopies) {
        this.basicEngine = new BasicSearchEngine(workingCopies);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.basicEngine = new BasicSearchEngine(workingCopyOwner);
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type) throws JavaScriptModelException {
        return BasicSearchEngine.createHierarchyScope(type);
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaScriptModelException {
        return BasicSearchEngine.createHierarchyScope(type, owner);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements) {
        return BasicSearchEngine.createJavaSearchScope(elements);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, boolean includeReferencedProjects) {
        return BasicSearchEngine.createJavaSearchScope(elements, includeReferencedProjects);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, int includeMask) {
        return BasicSearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return BasicSearchEngine.createTypeNameMatch(type, modifiers);
    }

    public static IJavaScriptSearchScope createWorkspaceScope() {
        return BasicSearchEngine.createWorkspaceScope();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return BasicSearchEngine.getDefaultSearchParticipant();
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.basicEngine.search(pattern, participants, scope, requestor, monitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IJavaScriptSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(packageName, typeName, typeMatchRule, scope, (IRestrictedAccessTypeRequestor)requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] prefix, int typeMatchRule, int searchFor, IJavaScriptSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(prefix, typeMatchRule, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IJavaScriptSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(packageName, typeName, typeMatchRule, scope, (IRestrictedAccessTypeRequestor)requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IJavaScriptSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, scope, (IRestrictedAccessTypeRequestor)requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IJavaScriptSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, scope, (IRestrictedAccessTypeRequestor)requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchDeclarationsOfAccessedFields(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        this.basicEngine.searchDeclarationsOfAccessedFields(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        this.basicEngine.searchDeclarationsOfReferencedTypes(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfSentMessages(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        this.basicEngine.searchDeclarationsOfSentMessages(enclosingElement, requestor, monitor);
    }

    public static char[][] getAllSubtypeNames(char[] typeName, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        final IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        final SimpleSetOfCharArray subtypeNames = new SimpleSetOfCharArray();
        final LinkedList<char[]> searchQueue = new LinkedList<char[]>();
        searchQueue.add(typeName);
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        while (!searchQueue.isEmpty()) {
            char[] searchName = (char[])searchQueue.remove(0);
            if (subtypeNames.includes(searchName)) continue;
            subtypeNames.add(searchName);
            char[][] synonyms = SearchEngine.getAllSynonyms(searchName, scope, waitingPolicy, null);
            int i = 0;
            while (i < synonyms.length) {
                if (!subtypeNames.includes(synonyms[i])) {
                    searchQueue.add(synonyms[i]);
                }
                ++i;
            }
            TypeDeclarationPattern subtypePattern = new TypeDeclarationPattern(IIndexConstants.ONE_STAR, IIndexConstants.ONE_STAR, new char[][]{searchName}, 10);
            indexManager.performConcurrentJob(new PatternSearchJob(subtypePattern, new JavaSearchParticipant(), scope, new IndexQueryRequestor(){

                @Override
                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                    char[] subtype = CharOperation.concat(record.qualification, record.simpleName, '.');
                    if (!subtypeNames.includes(subtype)) {
                        searchQueue.add(subtype);
                    }
                    return true;
                }
            }), waitingPolicy, new NullProgressMonitor(){

                @Override
                public void setCanceled(boolean value) {
                    monitor.setCanceled(value);
                }

                @Override
                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
        }
        char[][] names = new char[subtypeNames.elementSize][];
        subtypeNames.asArray((Object[])names);
        return names;
    }

    public static char[][] getAllSynonyms(char[] typeName, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        final IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        final ArrayList<char[]> allSynonyms = new ArrayList<char[]>();
        allSynonyms.add(typeName);
        final LinkedList<char[]> searchForSynonyms = new LinkedList<char[]>();
        searchForSynonyms.add(typeName);
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        while (!searchForSynonyms.isEmpty() && !monitor.isCanceled()) {
            char[] needle = (char[])searchForSynonyms.removeFirst();
            TypeSynonymsPattern typeSynonymsPattern = new TypeSynonymsPattern(needle);
            indexManager.performConcurrentJob(new PatternSearchJob(typeSynonymsPattern, new JavaSearchParticipant(), scope, new IndexQueryRequestor(){

                @Override
                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    TypeSynonymsPattern record = (TypeSynonymsPattern)indexRecord;
                    char[][] patternSynonyms = record.getSynonyms();
                    if (patternSynonyms != null && patternSynonyms.length != 0) {
                        int i = 0;
                        while (i < patternSynonyms.length) {
                            if (!SearchEngine.listContains(allSynonyms, patternSynonyms[i])) {
                                allSynonyms.add(patternSynonyms[i]);
                                searchForSynonyms.add(patternSynonyms[i]);
                            }
                            ++i;
                        }
                    }
                    return true;
                }
            }), waitingPolicy, new NullProgressMonitor(){

                @Override
                public void setCanceled(boolean value) {
                    monitor.setCanceled(value);
                }

                @Override
                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
        }
        return (char[][])allSynonyms.toArray((T[])new char[allSynonyms.size()][]);
    }

    private static boolean listContains(List list, Object elem) {
        boolean contains = false;
        if (elem instanceof char[]) {
            char[] needle = (char[])elem;
            int i = 0;
            while (i < list.size() && !contains) {
                contains = list.get(i) instanceof char[] && CharOperation.equals((char[])list.get(i), needle);
                ++i;
            }
        } else {
            contains = list.contains(elem);
        }
        return contains;
    }
}

