/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimeInstallRegistryReader;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimeTypeRegistryReader;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimesDefinitionsContainer;
import org.eclipse.wst.jsdt.internal.core.runtime.RuntimeMessages;
import org.osgi.service.prefs.BackingStoreException;

public final class JSRuntimeManager {
    private static final String PREF_JS_RUNTIME_INSTALLS_XML = "org.eclipse.wst.jsdt.core.PREF_JS_RUNTIME_INSTALLS_XML";
    private static Map<String, IJSRuntimeInstall> jsRuntimes = new HashMap<String, IJSRuntimeInstall>();
    private static Set<String> contributedRuntimeInstallIds = new HashSet<String>();
    private static Map<String, String> defaultRuntimeInstalls = new HashMap<String, String>();
    private static boolean runtimeManagerInitializing;
    private static boolean runtimeManagerInitialized;

    private JSRuntimeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRuntimeManager() {
        runtimeManagerInitializing = true;
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            Collection<IJSRuntimeInstall> extRuntimeInstalls = JSRuntimeInstallRegistryReader.getJSRuntimeInstalls();
            for (IJSRuntimeInstall extRuntimeInstall : extRuntimeInstalls) {
                jsRuntimes.put(extRuntimeInstall.getId(), extRuntimeInstall);
                contributedRuntimeInstallIds.add(extRuntimeInstall.getId());
            }
            String runtimeInstallsXMLString = InstanceScope.INSTANCE.getNode("org.eclipse.wst.jsdt.core").get(PREF_JS_RUNTIME_INSTALLS_XML, "");
            JSRuntimesDefinitionsContainer container = null;
            if (runtimeInstallsXMLString.length() > 0) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(runtimeInstallsXMLString.getBytes("UTF8"));
                    container = JSRuntimesDefinitionsContainer.parseXMLIntoContainer(inputStream);
                }
                catch (IOException ioe) {
                    Logger.logException(ioe);
                }
            }
            if (container != null) {
                List<IJSRuntimeInstall> runtimeInstalls = container.getRuntimeList();
                for (IJSRuntimeInstall runtimeInstall : runtimeInstalls) {
                    if (!(runtimeInstall instanceof JSRuntimeWorkingCopy)) continue;
                    ((JSRuntimeWorkingCopy)runtimeInstall).convertToRealRuntime();
                }
                Collection<IJSRuntimeType> runtimeTypes = JSRuntimeManager.getJSRuntimeTypes();
                for (IJSRuntimeType runtimeType : runtimeTypes) {
                    String defaultRuntimeId = container.getDefaultRuntimeInstallId(runtimeType.getId());
                    if (defaultRuntimeId == null) continue;
                    JSRuntimeManager.setDefaultRuntimeInstall(runtimeType.getId(), defaultRuntimeId);
                }
            }
        }
        runtimeManagerInitializing = false;
        runtimeManagerInitialized = true;
    }

    public static Collection<IJSRuntimeType> getJSRuntimeTypes() {
        return JSRuntimeTypeRegistryReader.getJSRuntimeTypes();
    }

    public static Collection<String> getJSRuntimeTypesIds() {
        return JSRuntimeTypeRegistryReader.getJSRuntimeTypesIds();
    }

    public static IJSRuntimeInstall getJSRuntimeInstall(String jsRuntimeInstallId) {
        if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
            JSRuntimeManager.initializeRuntimeManager();
        }
        return jsRuntimes.get(jsRuntimeInstallId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJSRuntimeInstall[] getJSRuntimeInstallsByType(String jsRuntimeInstallTypeId) {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
            Collection<IJSRuntimeInstall> allRuntimes = jsRuntimes.values();
            ArrayList<IJSRuntimeInstall> returnRuntimes = new ArrayList<IJSRuntimeInstall>();
            for (IJSRuntimeInstall runtime : allRuntimes) {
                if (!runtime.getRuntimeType().getId().equals(jsRuntimeInstallTypeId)) continue;
                returnRuntimes.add(runtime);
            }
            return returnRuntimes.toArray(new IJSRuntimeInstall[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJSRuntimeInstall(IJSRuntimeInstall runtimeInstall) throws IllegalArgumentException {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            String id;
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
            if (jsRuntimes.containsKey(id = runtimeInstall.getId())) {
                throw new IllegalArgumentException(RuntimeMessages.JSRuntimeManager_DuplicatedRuntimeException);
            }
            jsRuntimes.put(runtimeInstall.getId(), runtimeInstall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateJSRuntimeInstall(IJSRuntimeInstall runtimeInstall) throws IllegalArgumentException {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            IJSRuntimeInstall storedRuntimeInstall;
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
            if ((storedRuntimeInstall = jsRuntimes.get(runtimeInstall.getId())) == null) {
                throw new IllegalArgumentException(RuntimeMessages.JSRuntimeManager_UnexistingRuntimeException);
            }
            jsRuntimes.put(runtimeInstall.getId(), runtimeInstall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJSRuntimeInstall(String runtimeInstallId) throws IllegalArgumentException {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
            if (!jsRuntimes.containsKey(runtimeInstallId)) {
                throw new IllegalArgumentException(RuntimeMessages.JSRuntimeManager_UnexistingRuntimeException);
            }
            jsRuntimes.remove(runtimeInstallId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            jsRuntimes.clear();
        }
    }

    public static void reset() {
        JSRuntimeManager.clear();
        runtimeManagerInitializing = false;
        runtimeManagerInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJSRuntimeInstall getDefaultRuntimeInstall(String runtimeTypeId) throws IllegalArgumentException {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            IJSRuntimeInstall[] runtimeInstalls;
            IJSRuntimeType type;
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
            if ((type = JSRuntimeTypeRegistryReader.getJSRuntimeType(runtimeTypeId)) == null) {
                throw new IllegalArgumentException(NLS.bind(RuntimeMessages.JSRuntimeManager_UnexistingRuntimeTypeException, runtimeTypeId));
            }
            String defaultInstallId = defaultRuntimeInstalls.get(runtimeTypeId);
            IJSRuntimeInstall defaultRuntimeInstall = JSRuntimeManager.getJSRuntimeInstall(defaultInstallId);
            if (defaultRuntimeInstall == null && (runtimeInstalls = JSRuntimeManager.getJSRuntimeInstallsByType(runtimeTypeId)).length > 0) {
                defaultRuntimeInstall = runtimeInstalls[0];
                defaultRuntimeInstalls.put(runtimeTypeId, defaultRuntimeInstall.getId());
            }
            return defaultRuntimeInstall;
        }
    }

    public static void setDefaultRuntimeInstall(String runtimeTypeId, String runtimeInstallId) {
        IJSRuntimeType type = JSRuntimeTypeRegistryReader.getJSRuntimeType(runtimeTypeId);
        if (type == null) {
            throw new IllegalArgumentException(NLS.bind(RuntimeMessages.JSRuntimeManager_UnexistingRuntimeTypeException, runtimeTypeId));
        }
        defaultRuntimeInstalls.put(runtimeTypeId, runtimeInstallId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContributedRuntimeInstall(String runtimeInstallId) {
        Map<String, IJSRuntimeInstall> map = jsRuntimes;
        synchronized (map) {
            if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
                JSRuntimeManager.initializeRuntimeManager();
            }
        }
        return contributedRuntimeInstallIds.contains(runtimeInstallId);
    }

    public static IJSRuntimeType getJSRuntimeType(String runtimeTypeId) {
        return JSRuntimeTypeRegistryReader.getJSRuntimeType(runtimeTypeId);
    }

    public static void saveRuntimesConfiguration() throws CoreException {
        if (!runtimeManagerInitializing && !runtimeManagerInitialized) {
            return;
        }
        String xml = JSRuntimeManager.getUserRuntimesAsXML();
        InstanceScope.INSTANCE.getNode("org.eclipse.wst.jsdt.core").put(PREF_JS_RUNTIME_INSTALLS_XML, xml);
        JSRuntimeManager.savePreferences();
    }

    private static String getUserRuntimesAsXML() throws CoreException {
        JSRuntimesDefinitionsContainer container = new JSRuntimesDefinitionsContainer();
        Collection<IJSRuntimeType> runtimeTypes = JSRuntimeManager.getJSRuntimeTypes();
        IJSRuntimeInstall[] runtimes = null;
        for (IJSRuntimeType runtimeType : runtimeTypes) {
            runtimes = JSRuntimeManager.getJSRuntimeInstallsByType(runtimeType.getId());
            int i = 0;
            while (i < runtimes.length) {
                if (!JSRuntimeManager.isContributedRuntimeInstall(runtimes[i].getId())) {
                    container.addRuntime(runtimes[i]);
                }
                ++i;
            }
            IJSRuntimeInstall defaultInstall = JSRuntimeManager.getDefaultRuntimeInstall(runtimeType.getId());
            if (defaultInstall == null) continue;
            container.setDefaultRuntimeInstallId(runtimeType.getId(), defaultInstall.getId());
        }
        return container.getAsXML();
    }

    private static void savePreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.jsdt.core");
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }
}

