/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.compiler.libraries;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SystemLibraryLocation
implements LibraryLocation {
    public static final char[] SYSTEM_LIBARAY_NAME = new char[]{'s', 'y', 's', 't', 'e', 'm', '.', 'j', 's'};
    public static final char[] LIBRARY_RUNTIME_DIRECTORY = new char[]{'l', 'i', 'b', 'r', 'a', 'r', 'i', 'e', 's'};
    public static final char[] LIBRARY_PLUGIN_DIRECTORY = new char[]{'l', 'i', 'b', 'r', 'a', 'r', 'i', 'e', 's'};
    private static final boolean AUTO_UPDATE_LIBS = true;
    private static SystemLibraryLocation fInstance;

    public static LibraryLocation getInstance() {
        if (fInstance == null) {
            fInstance = new SystemLibraryLocation();
        }
        return fInstance;
    }

    @Override
    public IPath getLibraryPathInPlugin() {
        return new Path("libraries");
    }

    @Override
    public char[][] getLibraryFileNames() {
        return new char[][]{SYSTEM_LIBARAY_NAME};
    }

    protected String getPluginId() {
        return "org.eclipse.wst.jsdt.core";
    }

    public char[][] getAllFilesInPluginDirectory(String directory) {
        Enumeration<String> entries = Platform.getBundle(this.getPluginId()).getEntryPaths(directory);
        ArrayList<char[]> allEntries = new ArrayList<char[]>();
        while (entries.hasMoreElements()) {
            Path value = new Path(entries.nextElement());
            char[] filename = value.lastSegment().toCharArray();
            if (!Util.isJavaLikeFileName(filename)) continue;
            allEntries.add(filename);
        }
        char[][] fileNames = new char[allEntries.size()][];
        int i = 0;
        while (i < allEntries.size()) {
            fileNames[i] = (char[])allEntries.get(i);
            ++i;
        }
        return fileNames;
    }

    public SystemLibraryLocation() {
        IPath libraryRuntimePath = Platform.getStateLocation(Platform.getBundle("org.eclipse.wst.jsdt.core")).append(new String(LIBRARY_RUNTIME_DIRECTORY));
        try {
            if (!libraryRuntimePath.toFile().exists()) {
                libraryRuntimePath.toFile().mkdir();
            }
        }
        catch (SecurityException e) {
            Platform.getLog(Platform.getBundle("org.eclipse.wst.jsdt.core")).log(new Status(4, "org.eclipse.wst.jsdt.core", "Problem creating folder " + libraryRuntimePath, (Throwable)e));
        }
        char[][] libFiles = this.getLibraryFileNames();
        int i = 0;
        while (i < libFiles.length) {
            IPath workingLibLocation = libraryRuntimePath.addTrailingSeparator().append(new String(libFiles[i]));
            File library = workingLibLocation.toFile();
            if (!library.exists()) {
                InputStream is = null;
                try {
                    is = FileLocator.openStream(Platform.getBundle(this.getPluginId()), this.getLibraryPathInPlugin().append(new String(libFiles[i])), false);
                }
                catch (IOException e) {
                    Platform.getLog(Platform.getBundle(this.getPluginId())).log(new Status(4, this.getPluginId(), "Could not read " + this.getPluginId() + ":" + this.getLibraryPathInPlugin().append(new String(libFiles[i])), (Throwable)e));
                }
                if (is != null) {
                    try {
                        SystemLibraryLocation.copyFile(is, library);
                    }
                    catch (IOException e) {
                        Platform.getLog(Platform.getBundle(this.getPluginId())).log(new Status(4, this.getPluginId(), "Problem writing to " + workingLibLocation, (Throwable)e));
                    }
                }
            } else {
                File inPlugin;
                long lastModNew;
                long lastModold = library.lastModified();
                URL path = null;
                URL entry = null;
                try {
                    entry = Platform.getBundle(this.getPluginId()).getEntry(this.getLibraryPathInPlugin().append(new String(libFiles[i])).toString());
                    path = FileLocator.toFileURL(entry);
                }
                catch (IOException e) {
                    Platform.getLog(Platform.getBundle("org.eclipse.wst.jsdt.core")).log(new Status(4, this.getPluginId(), "Problem getting file path from " + entry, (Throwable)e));
                }
                catch (IllegalStateException illegalStateException) {}
                if (path != null && (lastModNew = (inPlugin = new File(path.getFile())).lastModified()) > lastModold) {
                    InputStream is = null;
                    try {
                        is = FileLocator.openStream(Platform.getBundle(this.getPluginId()), this.getLibraryPathInPlugin().append(new String(libFiles[i])), false);
                    }
                    catch (IOException e) {
                        Platform.getLog(Platform.getBundle(this.getPluginId())).log(new Status(4, this.getPluginId(), "Could not read " + this.getPluginId() + ":" + this.getLibraryPathInPlugin().append(new String(libFiles[i])), (Throwable)e));
                    }
                    if (is != null) {
                        library.delete();
                        try {
                            SystemLibraryLocation.copyFile(is, library);
                        }
                        catch (IOException e) {
                            Platform.getLog(Platform.getBundle(this.getPluginId())).log(new Status(4, this.getPluginId(), "Problem writing to " + library, (Throwable)e));
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public IPath getWorkingLibPath() {
        return new Path(this.getLibraryPath(""));
    }

    @Override
    public String getLibraryPath(String name) {
        return JavaScriptCore.getPlugin().getStateLocation().append(new String(LIBRARY_RUNTIME_DIRECTORY)).addTrailingSeparator().append(name).toString();
    }

    @Override
    public String getLibraryPath(char[] name) {
        return this.getLibraryPath(new String(name));
    }

    protected static void copyFile(InputStream src, File dst) throws IOException {
        BufferedInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(src);
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buffer = new byte[4096];
            while ((len = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

