/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class JavaScriptModelException
extends CoreException {
    private static final long serialVersionUID = -760398656505871287L;
    CoreException nestedCoreException;

    public JavaScriptModelException(Throwable e, int code) {
        this(new JavaModelStatus(code, e));
    }

    public JavaScriptModelException(CoreException exception) {
        super(exception.getStatus());
        this.nestedCoreException = exception;
    }

    public JavaScriptModelException(IJavaScriptModelStatus status) {
        super(status);
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IJavaScriptModelStatus getJavaScriptModelStatus() {
        IStatus status = this.getStatus();
        if (status instanceof IJavaScriptModelStatus) {
            return (IJavaScriptModelStatus)status;
        }
        return new JavaModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IJavaScriptModelStatus javaModelStatus = this.getJavaScriptModelStatus();
        return javaModelStatus != null && javaModelStatus.isDoesNotExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            Throwable throwable = this.getException();
            if (throwable != null) {
                output.print("Caused by: ");
                throwable.printStackTrace(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            Throwable throwable = this.getException();
            if (throwable != null) {
                output.print("Caused by: ");
                throwable.printStackTrace(output);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JavaScript Model Exception: ");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException c = (CoreException)this.getException();
                buffer.append("Core Exception [code ");
                buffer.append(c.getStatus().getCode());
                buffer.append("] ");
                buffer.append(c.getStatus().getMessage());
            } else {
                buffer.append(this.getException().toString());
            }
        } else {
            buffer.append(this.getStatus().toString());
        }
        return buffer.toString();
    }
}

