/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static void zip(File dir, File target) throws IOException {
        if (target.exists()) {
            ZipUtil.delete(target);
        }
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(target));
        try {
            ZipUtil.zipDir(target, zip, dir, "");
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
    }

    private static void zipDir(File target, ZipOutputStream zip, File dir, String path) throws IOException {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String cpath = String.valueOf(path) + f.getName();
            if (f.isDirectory()) {
                ZipUtil.zipDir(target, zip, f, String.valueOf(cpath) + "/");
            } else {
                ZipUtil.zipFile(target, zip, f, cpath);
            }
            ++n2;
        }
    }

    private static void zipFile(File target, ZipOutputStream zip, File file, String path) throws IOException {
        if (!file.equals(target)) {
            long flength;
            int bufsize;
            FileInputStream in;
            block12: {
                ZipEntry ze = new ZipEntry(path);
                ze.setTime(file.lastModified() + 1999L);
                ze.setMethod(8);
                zip.putNextEntry(ze);
                in = new FileInputStream(file);
                bufsize = 8192;
                flength = file.length();
                if (flength != 0L) break block12;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                return;
            }
            try {
                if (flength < (long)bufsize) {
                    bufsize = (int)flength;
                }
                byte[] buffer = new byte[bufsize];
                int count = in.read(buffer);
                while (count != -1) {
                    zip.write(buffer, 0, count);
                    count = in.read(buffer);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void unzip(File file, File destdir) throws IOException {
        ZipUtil.unzip(file, destdir, new NullProgressMonitor());
    }

    public static void unzip(File file, File destdir, IProgressMonitor monitor) throws IOException {
        ZipFile zip = ZipUtil.open(file);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int totalWork = zip.size();
            monitor.beginTask(Resources.progressUnzipping, totalWork);
            int c = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                monitor.worked(1);
                String taskMsg = NLS.bind(Resources.progressUnzipped, c++, totalWork);
                monitor.setTaskName(taskMsg);
                if (entry.isDirectory()) continue;
                File f = new File(destdir, entry.getName());
                File dir = f.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    String msg = "Could not create dir: " + dir.getPath();
                    throw new IOException(msg);
                }
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = zip.getInputStream(entry);
                    out = new FileOutputStream(f);
                    byte[] bytes = new byte[1024];
                    int count = in.read(bytes);
                    while (count != -1) {
                        out.write(bytes, 0, count);
                        count = in.read(bytes);
                    }
                    out.flush();
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
    }

    public static ZipFile open(File file) throws IOException {
        try {
            return new ZipFile(file);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fnfe = new FileNotFoundException(file.getAbsolutePath());
            fnfe.initCause(e);
            throw fnfe;
        }
    }

    public static ZipEntry getZipEntry(ZipFile zip, String name) {
        String lcasename = name.toLowerCase();
        Enumeration<? extends ZipEntry> itr = zip.entries();
        while (itr.hasMoreElements()) {
            ZipEntry zipentry = itr.nextElement();
            if (!zipentry.getName().toLowerCase().equals(lcasename)) continue;
            return zipentry;
        }
        return null;
    }

    private static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                ZipUtil.delete(child);
                ++n2;
            }
        }
        if (!f.delete()) {
            String msg = "Could not delete " + f.getPath() + ".";
            throw new IOException(msg);
        }
    }

    private static final class Resources
    extends NLS {
        public static String progressUnzipped;
        public static String progressUnzipping;

        static {
            Resources.initializeMessages(ZipUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

