/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntime
implements IRuntime {
    private static final String PROP_LOCALIZED_NAME = "localized-name";
    private static final String PROP_ALTERNATE_NAMES = "alternate-names";
    private String name;

    AbstractRuntime() {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getLocalizedName() {
        String localizedName = this.getProperty(PROP_LOCALIZED_NAME);
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public final Set<String> getAlternateNames() {
        String alternateNamesProp = this.getProperty(PROP_ALTERNATE_NAMES);
        HashSet<String> alternateNames = new HashSet<String>();
        String localizedName = this.getLocalizedName();
        if (!localizedName.equals(this.getName())) {
            alternateNames.add(localizedName);
        }
        if (alternateNamesProp != null) {
            String name;
            StringBuilder buf = new StringBuilder();
            boolean seenEscapeChar = false;
            int i = 0;
            int n = alternateNamesProp.length();
            while (i < n) {
                char ch = alternateNamesProp.charAt(i);
                if (seenEscapeChar) {
                    if (ch != ',') {
                        buf.append('\\');
                    }
                    buf.append(ch);
                    seenEscapeChar = false;
                } else if (ch == '\\' && i != n - 1) {
                    seenEscapeChar = true;
                } else if (ch == ',') {
                    String name2 = buf.toString().trim();
                    if (name2.length() > 0) {
                        alternateNames.add(name2);
                    }
                    buf.setLength(0);
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            if (seenEscapeChar) {
                buf.append('\\');
            }
            if ((name = buf.toString().trim()).length() > 0) {
                alternateNames.add(name);
            }
        }
        return Collections.unmodifiableSet(alternateNames);
    }

    final void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public final Object getAdapter(Class adapter) {
        String t = adapter.getName();
        Object res = Platform.getAdapterManager().loadAdapter(this, t);
        if (res == null) {
            for (IRuntimeComponent rc : this.getRuntimeComponents()) {
                res = rc.getAdapter(adapter);
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public boolean supports(IProjectFacet f) {
        for (IProjectFacetVersion fv : f.getVersions()) {
            if (!this.supports(fv)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IProjectFacetVersion> getDefaultFacets(Set<IProjectFacet> fixed) throws CoreException {
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet f : fixed) {
            facets.add(f.getLatestSupportedVersion(this));
        }
        return facets;
    }

    @Override
    public IStatus validate(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof IRuntime) {
            IRuntime r = (IRuntime)obj;
            return this.getName().equals(r.getName()) && this.getRuntimeComponents().equals(r.getRuntimeComponents()) && this.getProperties().equals(r.getProperties());
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

