/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IDefaultVersionProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.ActionDefinition;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetAliasesExtensionPoint;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.util.internal.MiscUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.Versionable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFacet
extends Versionable<IProjectFacetVersion>
implements IProjectFacet {
    private String id;
    private final Set<String> aliases = new HashSet<String>();
    private final Set<String> aliasesReadOnly = Collections.unmodifiableSet(this.aliases);
    private String plugin;
    private String label;
    private String description;
    private ICategory category;
    private final List<IActionDefinition> actionDefinitions = new ArrayList<IActionDefinition>();
    private IProjectFacetVersion defaultVersion;
    private IDefaultVersionProvider defaultVersionProvider;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> propertiesReadOnly = Collections.unmodifiableMap(this.properties);

    ProjectFacet() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public Set<String> getAliases() {
        return this.aliasesReadOnly;
    }

    void addAlias(String alias) {
        this.aliases.add(alias);
    }

    @Override
    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ICategory getCategory() {
        return this.category;
    }

    void setCategory(ICategory category) {
        this.category = category;
    }

    void addVersion(IProjectFacetVersion fv) {
        this.versions.addItem(fv);
        this.versions.addKey(fv.getVersionString(), fv);
        for (String alias : ProjectFacetAliasesExtensionPoint.getAliases(fv)) {
            this.versions.addKey(alias, fv);
            ((ProjectFacetVersion)fv).addAlias(alias);
        }
    }

    @Override
    public IProjectFacetVersion getLatestSupportedVersion(IRuntime r) {
        for (IProjectFacetVersion fv : this.getSortedVersions(false)) {
            if (!r.supports(fv)) continue;
            return fv;
        }
        return null;
    }

    @Override
    public IProjectFacetVersion getDefaultVersion() {
        IProjectFacetVersion defver = null;
        if (this.defaultVersionProvider != null) {
            try {
                defver = this.defaultVersionProvider.getDefaultVersion();
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
            if (defver != null && defver.getProjectFacet() != this) {
                String msg = NLS.bind(Resources.versionProviderReturnedWrongVersion, this.id);
                FacetCorePlugin.log(msg);
                defver = null;
            }
            if (defver == null) {
                defver = (IProjectFacetVersion)this.getLatestVersion();
            }
            return defver;
        }
        return this.defaultVersion;
    }

    void setDefaultVersion(IProjectFacetVersion fv) {
        this.defaultVersion = fv;
        this.defaultVersionProvider = null;
    }

    void setDefaultVersionProvider(IDefaultVersionProvider provider) {
        this.defaultVersion = null;
        this.defaultVersionProvider = provider;
    }

    public Object getAdapter(Class type) {
        return Platform.getAdapterManager().loadAdapter(this, type.getName());
    }

    @Override
    public String createVersionNotFoundErrMsg(String verstr) {
        return NLS.bind(FacetedProjectFrameworkImpl.Resources.facetVersionNotDefined, this.id, verstr);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propertiesReadOnly;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public boolean isVersionHidden() {
        return this.versions.getItemSet().size() == 1 && MiscUtil.equal(this.getProperty("hide.version"), true);
    }

    public String toString() {
        return this.label;
    }

    Set<IActionDefinition> getActionDefinitions(IProjectFacetVersion fv) {
        HashSet<IActionDefinition> result = new HashSet<IActionDefinition>();
        for (IActionDefinition def : this.actionDefinitions) {
            if (!def.getVersionExpr().check(fv)) continue;
            result.add(def);
        }
        return result;
    }

    void addActionDefinition(ActionDefinition actionDefinition) {
        this.actionDefinitions.add(actionDefinition);
    }

    public static final class Resources
    extends NLS {
        public static String versionProviderReturnedWrongVersion;

        static {
            Resources.initializeMessages(ProjectFacet.class.getName(), Resources.class);
        }
    }
}

