/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.EnumSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

public final class ProblemLog {
    private static final String NOT_DEFINED_WILDCARD = "not-defined";
    public static final Policy DEFAULT_POLICY = new Policy();

    public static void reportMissingFacet(String fid, String plugin) {
        ProblemLog.reportMissingFacet(fid, plugin, DEFAULT_POLICY);
    }

    public static void reportMissingFacet(String fid, String plugin, Policy policy) {
        if (policy.isLoggingEnabled(ProblemCase.FACET_NOT_DEFINED)) {
            String msg = String.valueOf(NLS.bind(Resources.facetNotDefined, fid)) + NLS.bind(Resources.usedInPlugin, plugin);
            FacetCorePlugin.logError(msg, true);
        }
    }

    public static void reportMissingFacetVersion(IProjectFacet facet, String version, String plugin) {
        ProblemLog.reportMissingFacetVersion(facet, version, plugin, DEFAULT_POLICY);
    }

    public static void reportMissingFacetVersion(IProjectFacet facet, String version, String plugin, Policy policy) {
        if (policy.isLoggingEnabled(ProblemCase.FACET_VERSION_NOT_DEFINED)) {
            String msg = String.valueOf(NLS.bind(Resources.facetVersionNotDefined, facet.getId(), version)) + NLS.bind(Resources.usedInPlugin, plugin);
            FacetCorePlugin.logError(msg, true);
        }
    }

    public static void reportMissingGroup(String groupId, String pluginId) {
        ProblemLog.reportMissingGroup(groupId, pluginId, DEFAULT_POLICY);
    }

    public static void reportMissingGroup(String groupId, String pluginId, Policy policy) {
        if (policy.isLoggingEnabled(ProblemCase.GROUP_NOT_DEFINED)) {
            String msg = String.valueOf(NLS.bind(Resources.groupNotDefined, groupId)) + NLS.bind(Resources.usedInPlugin, pluginId);
            FacetCorePlugin.logError(msg, true);
        }
    }

    public static void reportMissingRuntimeComponentType(String rct, String plugin) {
        ProblemLog.reportMissingRuntimeComponentType(rct, plugin, DEFAULT_POLICY);
    }

    public static void reportMissingRuntimeComponentType(String rct, String plugin, Policy policy) {
        if (policy.isLoggingEnabled(ProblemCase.RUNTIME_COMPONENT_TYPE_NOT_DEFINED)) {
            String msg = String.valueOf(NLS.bind(Resources.runtimeComponentTypeNotDefined, rct)) + NLS.bind(Resources.usedInPlugin, plugin);
            FacetCorePlugin.logError(msg, true);
        }
    }

    public static final class Policy {
        private final EnumSet<ProblemCase> problemCases = EnumSet.allOf(ProblemCase.class);

        public Policy() {
            ProblemCase[] problemCaseArray = ProblemCase.values();
            int n = problemCaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemCase problemCase = problemCaseArray[n2];
                this.problemCases.add(problemCase);
                ++n2;
            }
        }

        public static Policy createBasedOnIgnoreProblemsAttr(IConfigurationElement element) {
            return Policy.createBasedOnIgnoreProblemsAttr(element, DEFAULT_POLICY);
        }

        public static Policy createBasedOnIgnoreProblemsAttr(IConfigurationElement element, Policy defaultProblemLoggingPolicy) {
            String enabledWhenAttrValue = element.getAttribute("ignore-problems");
            if (enabledWhenAttrValue == null) {
                return defaultProblemLoggingPolicy;
            }
            Policy policy = new Policy();
            String[] stringArray = enabledWhenAttrValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                segment = segment.trim();
                boolean knownCase = false;
                if (segment.equalsIgnoreCase(ProblemLog.NOT_DEFINED_WILDCARD)) {
                    policy.problemCases.remove((Object)ProblemCase.FACET_NOT_DEFINED);
                    policy.problemCases.remove((Object)ProblemCase.FACET_VERSION_NOT_DEFINED);
                    policy.problemCases.remove((Object)ProblemCase.GROUP_NOT_DEFINED);
                    policy.problemCases.remove((Object)ProblemCase.RUNTIME_COMPONENT_TYPE_NOT_DEFINED);
                    policy.problemCases.remove((Object)ProblemCase.RUNTIME_COMPONENT_VERSION_NOT_DEFINED);
                    knownCase = true;
                } else {
                    ProblemCase[] problemCaseArray = ProblemCase.values();
                    int n3 = problemCaseArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ProblemCase problemCase = problemCaseArray[n4];
                        if (segment.equalsIgnoreCase(problemCase.toString())) {
                            policy.problemCases.remove((Object)problemCase);
                            knownCase = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!knownCase) {
                    String msg = String.valueOf(NLS.bind(Resources.problemCaseNotRecognized, segment)) + NLS.bind(Resources.usedInPlugin, element.getContributor().getName());
                    FacetCorePlugin.logWarning(msg, true);
                }
                ++n2;
            }
            return policy;
        }

        public boolean isLoggingEnabled(ProblemCase problemCase) {
            return this.problemCases.contains((Object)problemCase);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProblemCase {
        FACET_NOT_DEFINED("facet-not-defined"),
        FACET_VERSION_NOT_DEFINED("facet-version-not-defined"),
        GROUP_NOT_DEFINED("group-not-defined"),
        RUNTIME_COMPONENT_TYPE_NOT_DEFINED("runtime-component-type-not-defined"),
        RUNTIME_COMPONENT_VERSION_NOT_DEFINED("runtime-component-version-not-defined");

        private String str;

        private ProblemCase(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    private static final class Resources
    extends NLS {
        public static String problemCaseNotRecognized;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String groupNotDefined;
        public static String runtimeComponentTypeNotDefined;
        public static String usedInPlugin;

        static {
            Resources.initializeMessages(ProblemLog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

