/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.internal.DefaultFacetsExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalConfigurationPresetFactory
implements IPresetFactory {
    public static final String PRESET_ID = "minimal.configuration";

    @Override
    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        IFacetedProjectBase fproj = (IFacetedProjectBase)context.get("CONTEXT_KEY_FACETED_PROJECT");
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        Set<IProjectFacetVersion> defaultFacets = DefaultFacetsExtensionPoint.getDefaultFacets(fproj);
        if (defaultFacets == null) {
            return null;
        }
        for (IProjectFacet f : fproj.getFixedProjectFacets()) {
            facets.add(MinimalConfigurationPresetFactory.findProjectFacetVersion(defaultFacets, f));
        }
        return new PresetDefinition(Resources.presetLabel, Resources.presetDescription, facets);
    }

    private static IProjectFacetVersion findProjectFacetVersion(Set<IProjectFacetVersion> facets, IProjectFacet facet) {
        for (IProjectFacetVersion fv : facets) {
            if (fv.getProjectFacet() != facet) continue;
            return fv;
        }
        throw new IllegalStateException();
    }

    private static final class Resources
    extends NLS {
        public static String presetLabel;
        public static String presetDescription;

        static {
            Resources.initializeMessages(MinimalConfigurationPresetFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

