/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.uri.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFilter;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.relative.RelativeURI;
import org.eclipse.wst.common.internal.environment.uri.file.FileScheme;

public class FileURI
extends RelativeURI {
    private File file_ = null;

    public FileURI(String uri) {
        super(uri);
        if (this.getURIScheme().isValid(this)) {
            this.file_ = new File(uri.substring(5, uri.length()));
        }
    }

    public File asFile() {
        return this.file_;
    }

    public void erase() throws URIException {
        this.deleteFile(this.file_);
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int index = 0;
            while (index < children.length) {
                File child = children[index];
                if (child.isDirectory()) {
                    this.deleteFile(child);
                } else {
                    child.delete();
                }
                ++index;
            }
        }
        file.delete();
    }

    public InputStream getInputStream() throws URIException {
        FileInputStream stream = null;
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            stream = new FileInputStream(this.file_);
        }
        catch (IOException exc) {
            throw new URIException(new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
        return stream;
    }

    public OutputStream getOutputStream() throws URIException {
        FileOutputStream stream = null;
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            stream = new FileOutputStream(this.file_);
        }
        catch (IOException exc) {
            throw new URIException(new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
        return stream;
    }

    public IURIScheme getURIScheme() {
        return new FileScheme();
    }

    public boolean isAvailableAsFile() {
        return this.file_ != null;
    }

    public boolean isAvailableAsURL() {
        return this.file_ != null;
    }

    public URL asURL() throws URIException {
        URL url = null;
        try {
            url = this.file_ == null ? null : this.file_.toURL();
        }
        catch (MalformedURLException exc) {
            throw new URIException(new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
        return url;
    }

    public boolean isLeaf() {
        return this.file_.isFile();
    }

    public boolean isPresent() {
        return this.file_.exists();
    }

    public boolean isReadable() {
        return this.file_.canRead();
    }

    public boolean isWritable() {
        return this.file_.canWrite();
    }

    public IURI[] list() throws URIException {
        File[] children = this.file_.listFiles();
        IURI[] URIs = new IURI[]{};
        if (children != null) {
            int length = children.length;
            URIs = new IURI[length];
            int index = 0;
            while (index < length) {
                URIs[index] = new FileURI("file:" + children[index].getAbsolutePath());
                ++index;
            }
        }
        return URIs;
    }

    public IURI[] list(IURIFilter uriFilter) throws URIException {
        File[] children = this.file_.listFiles();
        int length = children == null ? 0 : children.length;
        Vector<FileURI> URIs = new Vector<FileURI>();
        if (children != null) {
            int index = 0;
            while (index < length) {
                FileURI newURI = new FileURI("file:" + children[index].getAbsolutePath());
                if (uriFilter.accepts(newURI)) {
                    URIs.add(newURI);
                }
                ++index;
            }
        }
        return URIs.toArray(new IURI[0]);
    }

    public void rename(IURI newURI) throws URIException {
        try {
            this.uri_ = newURI.toString();
            URL newURL = new URL(this.uri_);
            this.file_.renameTo(new File(newURL.getPath()));
        }
        catch (MalformedURLException exc) {
            throw new URIException(new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
    }

    public void touchFolder() throws URIException {
        this.file_.mkdirs();
    }

    public void touchLeaf() throws URIException {
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            this.file_.createNewFile();
        }
        catch (IOException exc) {
            throw new URIException(new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
    }

    public boolean isRelative() {
        return false;
    }
}

