/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.relative;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFilter;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.IURIVisitor;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;
import org.eclipse.wst.common.internal.environment.relative.RelativeScheme;

public class RelativeURI
implements IURI {
    protected String uri_;

    public RelativeURI(String uri) {
        this.uri_ = uri;
    }

    public IURI append(IURI relativeURI) throws URIException {
        if (!relativeURI.isRelative()) {
            throw new URIException(new Status(4, "id", 0, NLS.bind(Messages.MSG_URI_NOT_RELATIVE, relativeURI.toString()), null));
        }
        String newURI = String.valueOf(this.uri_) + "/" + relativeURI.toString();
        return this.getURIScheme().newURI(newURI);
    }

    public File asFile() {
        return null;
    }

    public String asString() {
        return this.uri_;
    }

    public String toString() {
        return this.uri_;
    }

    public URL asURL() throws URIException {
        return null;
    }

    public void erase() throws URIException {
    }

    public InputStream getInputStream() throws URIException {
        return null;
    }

    public OutputStream getOutputStream() throws URIException {
        return null;
    }

    public IURIScheme getURIScheme() {
        return new RelativeScheme();
    }

    public boolean isAvailableAsFile() {
        return false;
    }

    public boolean isAvailableAsURL() {
        return false;
    }

    public boolean isHierarchical() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isPresent() {
        return false;
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isRelative() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public IURI[] list() throws URIException {
        return new IURI[0];
    }

    public IURI[] list(IURIFilter uriFilter) throws URIException {
        return new IURI[0];
    }

    public IURI parent() throws URIException {
        int lastSlash = this.uri_.lastIndexOf(47);
        int firstSlash = this.uri_.indexOf(47);
        if (lastSlash == -1 || firstSlash == -1) {
            return null;
        }
        return this.getURIScheme().newURI(this.uri_.substring(0, lastSlash));
    }

    public void rename(IURI newURI) throws URIException {
        this.uri_ = newURI.toString();
    }

    public void touchFolder() throws URIException {
    }

    public void touchLeaf() throws URIException {
    }

    public void visit(IURIVisitor uriVisitor, IURIFilter uriFilter) throws URIException {
        boolean continueVisit = true;
        if (uriFilter.accepts(this)) {
            continueVisit = uriVisitor.visit(this);
        }
        IURI[] children = this.list();
        int index = 0;
        while (index < children.length && continueVisit) {
            children[index].visit(uriVisitor, uriFilter);
            ++index;
        }
    }

    public void visit(IURIVisitor uriVisitor) throws URIException {
        boolean continueVisit = uriVisitor.visit(this);
        IURI[] children = this.list();
        int index = 0;
        while (index < children.length && continueVisit) {
            children[index].visit(uriVisitor);
            ++index;
        }
    }
}

