/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.plugin;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;

public class WTPCommonPlugin
extends WTPPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.frameworks";
    public static final String GROUP_REGISTRY_EXTENSION_POINT = "functionGroup";
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.wst.common.frameworks", 0, "OK", null);
    private static WTPCommonPlugin plugin;

    public WTPCommonPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("wtp_common");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static WTPCommonPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IStatus createErrorStatus(String message) {
        return WTPCommonPlugin.createErrorStatus(message, null);
    }

    public static IStatus createWarningStatus(String message) {
        return WTPCommonPlugin.createWarningStatus(message, null);
    }

    public static IStatus createCancelStatus(String message) {
        return WTPCommonPlugin.createCancelStatus(message, null);
    }

    public static IStatus createWarningStatus(String message, Throwable exception) {
        return new Status(2, PLUGIN_ID, -1, message, exception);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, -1, message, exception);
    }

    public static IStatus createCancelStatus(String message, Throwable exception) {
        return new Status(8, PLUGIN_ID, -1, message, exception);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = WTPCommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getResourceString(String key, Object[] args) {
        String pattern = WTPCommonPlugin.getResourceString(key);
        if (pattern != null) {
            return MessageFormat.format(pattern, args);
        }
        return null;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return WTPCommonPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(WTPCommonPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(exception.getStatus());
    }

    public static void logError(String message) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(WTPCommonPlugin.createStatus(4, message));
    }
}

