/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.scope;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.core.search.scope.SearchScope;

public class SearchScopeImpl
extends SearchScope {
    protected List files = new ArrayList();
    protected HashSet projects = new HashSet();

    protected boolean acceptFile(IFile file) {
        if (file == null) {
            return false;
        }
        this.files.add(file);
        this.projects.add(file.getProject());
        return true;
    }

    protected boolean encloses(String resourcePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        if (resource == null) {
            return false;
        }
        return this.files.contains(resource);
    }

    @Override
    public IFile[] enclosingFiles() {
        if (this.files == null) {
            return new IFile[0];
        }
        return this.files.toArray(new IFile[this.files.size()]);
    }

    protected IProject[] enclosingProjects() {
        return this.projects.toArray(new IProject[this.projects.size()]);
    }

    protected void traverseContainer(IContainer container) {
        IResourceVisitor visitor = new IResourceVisitor(){

            @Override
            public boolean visit(IResource resource) {
                if (resource.getType() == 1) {
                    SearchScopeImpl.this.acceptFile((IFile)resource);
                }
                return true;
            }
        };
        try {
            container.accept(visitor);
        }
        catch (CoreException coreException) {}
    }
}

