/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.internal.SearchParticipantDescriptor;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;

public class SearchParticipantRegistry {
    protected Map idMap = new HashMap();

    public void putSearchParticipant(String id, SearchParticipantDescriptor searchParticipantDescriptor) {
        this.idMap.put(id, searchParticipantDescriptor);
    }

    public String[] getSearchParticipantIds() {
        Set ids = this.idMap.keySet();
        return ids.toArray(new String[ids.size()]);
    }

    public Collection getSearchParticipants() {
        return this.idMap.values();
    }

    public SearchParticipant getSearchParticipant(String id) {
        SearchParticipantDescriptor searchParticipantDescriptor = null;
        if (id != null) {
            searchParticipantDescriptor = (SearchParticipantDescriptor)this.idMap.get(id);
        }
        return searchParticipantDescriptor != null ? searchParticipantDescriptor.getSearchParticipant() : null;
    }

    public SearchParticipant[] getParticipants(SearchPattern pattern, Map searchOptions) {
        EvaluationContext evalContext = SearchParticipantRegistry.createEvaluationContext(pattern);
        ArrayList<SearchParticipant> result = new ArrayList<SearchParticipant>();
        Iterator iter = this.getSearchParticipants().iterator();
        while (iter.hasNext()) {
            SearchParticipantDescriptor descriptor = (SearchParticipantDescriptor)iter.next();
            try {
                if (!descriptor.matches(evalContext)) continue;
                try {
                    SearchParticipant participant = descriptor.getSearchParticipant();
                    if (!SearchParticipant.class.isInstance(participant)) {
                        throw new ClassCastException();
                    }
                    if (!participant.isApplicable(pattern, searchOptions)) continue;
                    result.add(participant);
                }
                catch (ClassCastException classCastException) {
                    iter.remove();
                }
            }
            catch (CoreException coreException) {
                iter.remove();
            }
        }
        return result.toArray(new SearchParticipant[result.size()]);
    }

    private static EvaluationContext createEvaluationContext(SearchPattern pattern) {
        EvaluationContext result = new EvaluationContext(null, pattern);
        result.addVariable("pattern", pattern);
        return result;
    }
}

