/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.core.search.ISearchOptions;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.internal.SearchParticipantRegistry;
import org.eclipse.wst.common.core.search.internal.SearchParticipantRegistryReader;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.osgi.framework.BundleContext;

public class SearchPlugin
extends Plugin
implements ISearchOptions {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.core";
    public static final String UI_CONTEXT_EXTENSION_POINT = "uiContextSensitiveClass";
    public static final String UI_TESTER_EXTENSION_POINT = "uiTester";
    private SearchParticipantRegistry searchParticipantRegistry;
    private static SearchPlugin plugin;

    public SearchPlugin() {
        plugin = this;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static SearchPlugin getDefault() {
        return plugin;
    }

    private SearchParticipantRegistry getSearchParticipantRegistry() {
        if (this.searchParticipantRegistry == null) {
            this.searchParticipantRegistry = new SearchParticipantRegistry();
            new SearchParticipantRegistryReader(this.searchParticipantRegistry).readRegistry();
        }
        return this.searchParticipantRegistry;
    }

    public SearchParticipant getSearchParticipant(String id) {
        return this.getSearchParticipantRegistry().getSearchParticipant(id);
    }

    SearchParticipant[] loadSearchParticipants(SearchPattern pattern, Map searchOptions) {
        return this.getSearchParticipantRegistry().getParticipants(pattern, searchOptions);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return SearchPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(SearchPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(exception.getStatus());
    }

    public static void logWarning(String message) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(SearchPlugin.createStatus(2, message));
    }

    public static void logWarning(Throwable exception) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(SearchPlugin.createStatus(2, exception.getMessage(), exception));
    }

    public static void logError(String message) {
        Platform.getLog(Platform.getBundle(PLUGIN_ID)).log(SearchPlugin.createStatus(4, message));
    }
}

