/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.core.search.ISearchOptions;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchPlugin;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.document.SearchDocumentSet;
import org.eclipse.wst.common.core.search.internal.Messages;
import org.eclipse.wst.common.core.search.internal.SearchDocumentSetImpl;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;

public class SearchEngine
implements ISearchOptions {
    public void search(SearchPattern pattern, SearchRequestor requestor, SearchParticipant[] participants, SearchScope scope, Map searchOptions, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Messages.engine_searching, 100);
        }
        SearchDocumentSetImpl set = new SearchDocumentSetImpl();
        try {
            SubProgressMonitor subMonitor;
            SearchParticipant participant;
            SearchScope[] scopeArray = new SearchScope[participants.length];
            int i = 0;
            int l = participants == null ? 0 : participants.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                participant = participants[i];
                SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                if (subMonitor != null) {
                    subMonitor.beginTask("", 1000);
                }
                try {
                    SearchScope newScope;
                    if (subMonitor != null) {
                        subMonitor.subTask(Messages.bind(Messages.engine_searching_locatingDocuments, new String[]{participant.getDescription()}));
                    }
                    participant.beginSearching(pattern, searchOptions);
                    scopeArray[i] = newScope = participant.selectDocumentLocations(pattern, scope, searchOptions, monitor);
                    participant.createSearchDocuments(set, pattern, newScope, searchOptions, subMonitor);
                }
                catch (Exception exception) {}
                ++i;
            }
            i = 0;
            l = participants == null ? 0 : participants.length;
            while (i < l) {
                block22: {
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    participant = participants[i];
                    SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                    if (subMonitor != null && subMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        try {
                            if (subMonitor != null) {
                                subMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                            }
                            if (scopeArray[i] != null) {
                                participant.locateMatches(set, pattern, scopeArray[i], requestor, searchOptions, subMonitor);
                            }
                        }
                        catch (Exception exception) {
                            participant.doneSearching(pattern, searchOptions);
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        participant.doneSearching(pattern, searchOptions);
                        throw throwable;
                    }
                    participant.doneSearching(pattern, searchOptions);
                }
                ++i;
            }
        }
        finally {
            ((SearchDocumentSet)set).dispose();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void search(SearchPattern pattern, SearchRequestor requestor, SearchScope scope, Map searchOptions, IProgressMonitor monitor) throws CoreException {
        SearchParticipant[] participants = this.getApplicableParticipants(pattern, searchOptions);
        this.search(pattern, requestor, participants, scope, searchOptions, monitor);
    }

    public SearchParticipant[] getApplicableParticipants(SearchPattern pattern, Map searchOptions) {
        return SearchPlugin.getDefault().loadSearchParticipants(pattern, searchOptions);
    }
}

