/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.variables;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.core.variables.Messages;
import org.eclipse.osgi.util.NLS;

public final class WorkspaceResolver
implements IDynamicVariableResolver {
    @Override
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        File file;
        URI uri;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = argument == null ? root : root.findMember(new Path(argument));
        if (resource != null && resource.exists() && (uri = resource.getLocationURI()) != null && (file = EFS.getStore(uri).toLocalFile(0, null)) != null) {
            return file.getAbsolutePath();
        }
        String expression = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(variable.getName(), argument);
        String message = NLS.bind(Messages.WorkspaceResolver_0, expression);
        throw new CoreException(new Status(4, "org.eclipse.core.resources", 368, message, null));
    }
}

