/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener2;

public class SourceLookupUtils {
    private static HashMap<String, ZipFile> fgZipFileCache = new HashMap(5);
    private static ArchiveCleaner fgCleaner = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFile getZipFile(String name) throws IOException {
        HashMap<String, ZipFile> hashMap = fgZipFileCache;
        synchronized (hashMap) {
            ZipFile zip;
            if (fgCleaner == null) {
                fgCleaner = new ArchiveCleaner();
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener(fgCleaner);
                ResourcesPlugin.getWorkspace().addResourceChangeListener(fgCleaner, 6);
            }
            if ((zip = fgZipFileCache.get(name)) == null) {
                zip = new ZipFile(name);
                fgZipFileCache.put(name, zip);
            }
            return zip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeArchives() {
        HashMap<String, ZipFile> hashMap = fgZipFileCache;
        synchronized (hashMap) {
            Iterator<ZipFile> iterator = fgZipFileCache.values().iterator();
            while (iterator.hasNext()) {
                ZipFile file;
                ZipFile zipFile = file = iterator.next();
                synchronized (zipFile) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        DebugPlugin.log(e);
                    }
                }
            }
            fgZipFileCache.clear();
        }
    }

    public static void shutdown() {
        SourceLookupUtils.closeArchives();
        if (fgCleaner != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(fgCleaner);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(fgCleaner);
        }
    }

    static class ArchiveCleaner
    implements IResourceChangeListener,
    ILaunchesListener2 {
        ArchiveCleaner() {
        }

        @Override
        public void launchesRemoved(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (!launch.isTerminated()) {
                    SourceLookupUtils.closeArchives();
                    return;
                }
                ++n2;
            }
        }

        @Override
        public void launchesAdded(ILaunch[] launches) {
        }

        @Override
        public void launchesChanged(ILaunch[] launches) {
        }

        @Override
        public void resourceChanged(IResourceChangeEvent event) {
            SourceLookupUtils.closeArchives();
        }

        @Override
        public void launchesTerminated(ILaunch[] launches) {
            SourceLookupUtils.closeArchives();
        }
    }
}

