/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class GroupLaunch
extends Launch
implements ILaunchesListener2 {
    private boolean fTerminated;
    private boolean fLaunched = false;
    private Map<ILaunch, IProcess[]> subLaunches = new HashMap<ILaunch, IProcess[]>();

    public GroupLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        this.getLaunchManager().addLaunchListener(this);
    }

    public void markLaunched() {
        this.fLaunched = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubLaunch(ILaunch subLaunch) {
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            this.subLaunches.put(subLaunch, new IProcess[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isChild(ILaunch launch) {
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            ILaunch subLaunch;
            Iterator<ILaunch> iterator = this.subLaunches.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((subLaunch = iterator.next()) != launch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTerminated() {
        if (this.fTerminated) {
            return true;
        }
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            ILaunch launch;
            if (this.subLaunches.isEmpty()) {
                return this.fLaunched;
            }
            Iterator<ILaunch> iterator = this.subLaunches.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return this.fLaunched;
            } while ((launch = iterator.next()).isTerminated());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canTerminate() {
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            ILaunch launch;
            if (this.subLaunches.isEmpty()) {
                return false;
            }
            Iterator<ILaunch> iterator = this.subLaunches.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(launch = iterator.next()).canTerminate());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() throws DebugException {
        MultiStatus status = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.Launch_terminate_failed, null);
        this.markLaunched();
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            for (ILaunch launch : this.subLaunches.keySet()) {
                if (!launch.canTerminate()) continue;
                try {
                    launch.terminate();
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
            }
        }
        if (status.isOK()) {
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            throw new DebugException(children[0]);
        }
        throw new DebugException(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTerminated(ILaunch launch) {
        if (this == launch) {
            return;
        }
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            if (this.subLaunches.remove(launch) != null && this.subLaunches.isEmpty() && this.fLaunched) {
                this.fTerminated = true;
                this.fireTerminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchChanged(ILaunch launch) {
        if (this == launch) {
            return;
        }
        Map<ILaunch, IProcess[]> map = this.subLaunches;
        synchronized (map) {
            Object[] newProcesses;
            Object[] oldProcesses;
            if (this.isChild(launch) && !Arrays.equals(oldProcesses = this.subLaunches.get(launch), newProcesses = launch.getProcesses())) {
                Object[] objectArray = oldProcesses;
                int n = oldProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    Object oldProcess = objectArray[n2];
                    this.removeProcess((IProcess)oldProcess);
                    ++n2;
                }
                objectArray = newProcesses;
                n = newProcesses.length;
                n2 = 0;
                while (n2 < n) {
                    Object newProcess = objectArray[n2];
                    this.addProcess((IProcess)newProcess);
                    ++n2;
                }
                this.subLaunches.put(launch, (IProcess[])newProcesses);
            }
        }
    }

    @Override
    public void launchRemoved(ILaunch launch) {
        if (this == launch) {
            IProcess[] processes;
            super.launchRemoved(launch);
            IProcess[] iProcessArray = processes = this.getProcesses();
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                this.removeProcess(process);
                ++n2;
            }
            this.getLaunchManager().removeLaunchListener(this);
        }
    }

    @Override
    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchTerminated(launch);
            ++n2;
        }
    }

    @Override
    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchAdded(launch);
            ++n2;
        }
    }

    @Override
    public void launchesChanged(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchChanged(launch);
            ++n2;
        }
    }

    @Override
    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchRemoved(launch);
            ++n2;
        }
    }
}

