/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStepFilter;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class StepFilter {
    private IConfigurationElement fConfigurationElement;
    private String fModelIdentifier;
    private IStepFilter fDelegate;

    public StepFilter(IConfigurationElement element) throws CoreException {
        this.fConfigurationElement = element;
        this.fModelIdentifier = this.fConfigurationElement.getAttribute("modelIdentifier");
        if (this.fModelIdentifier == null) {
            throw new CoreException(new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.StepFilter_0, null));
        }
        String className = this.fConfigurationElement.getAttribute("class");
        if (className == null) {
            throw new CoreException(new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.StepFilter_1, null));
        }
    }

    public IStepFilter[] getStepFilters(String modelIdentifier) {
        if (this.fModelIdentifier.equals(modelIdentifier)) {
            IStepFilter delegate = this.getDelegate();
            return new IStepFilter[]{delegate};
        }
        return new IStepFilter[0];
    }

    protected IStepFilter getDelegate() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (IStepFilter)this.fConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
        return this.fDelegate;
    }
}

