/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public final class LaunchDelegate
implements ILaunchDelegate {
    private IConfigurationElement fElement = null;
    private ILaunchConfigurationDelegate fDelegate = null;
    private List<Set<String>> fLaunchModes = null;
    private String fType = null;
    private HashMap<Set<String>, String> fPerspectiveIds = null;

    public LaunchDelegate(IConfigurationElement element) {
        this.fElement = element;
    }

    @Override
    public ILaunchConfigurationDelegate getDelegate() throws CoreException {
        if (this.fDelegate == null) {
            Object obj = this.fElement.createExecutableExtension("delegate");
            if (obj instanceof ILaunchConfigurationDelegate) {
                this.fDelegate = (ILaunchConfigurationDelegate)obj;
            } else {
                throw new CoreException(new Status(4, DebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.LaunchDelegate_3, this.getId()), null));
            }
        }
        return this.fDelegate;
    }

    @Override
    public String getId() {
        return this.fElement.getAttribute("id");
    }

    public String getLaunchConfigurationTypeId() {
        if (this.fType == null) {
            this.fType = this.fElement.getAttribute("type");
            if (this.fType == null) {
                this.fType = this.fElement.getAttribute("id");
            }
        }
        return this.fType;
    }

    private Set<String> parseModes(IConfigurationElement element) {
        HashSet<String> set = new HashSet<String>();
        String modes = element.getAttribute("modes");
        if (modes != null) {
            String[] strings;
            String[] stringArray = strings = modes.split(",");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                set.add(string.trim());
                ++n2;
            }
        }
        return set;
    }

    @Override
    public List<Set<String>> getModes() {
        if (this.fLaunchModes == null) {
            this.fLaunchModes = new ArrayList<Set<String>>();
            this.fPerspectiveIds = new HashMap();
            IConfigurationElement[] children = this.fElement.getChildren("modeCombination");
            Set<String> modeset = null;
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                modeset = this.parseModes(child);
                this.fLaunchModes.add(modeset);
                this.fPerspectiveIds.put(modeset, child.getAttribute("perspective"));
                ++n2;
            }
            modeset = null;
            String modes = this.fElement.getAttribute("modes");
            if (modes != null) {
                String[] strings;
                String[] stringArray = strings = modes.split(",");
                int n3 = strings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray[n4];
                    modeset = new HashSet<String>();
                    modeset.add(string.trim());
                    this.fLaunchModes.add(modeset);
                    ++n4;
                }
            }
        }
        return this.fLaunchModes;
    }

    @Override
    public String getName() {
        String name = this.fElement.getAttribute("delegateName");
        if (name == null) {
            name = this.fElement.getAttribute("name");
            if (name == null) {
                name = this.getContributorName();
            }
            name = Character.isUpperCase((name = name.trim()).charAt(0)) ? MessageFormat.format(DebugCoreMessages.LaunchDelegate_1, name) : MessageFormat.format(DebugCoreMessages.LaunchDelegate_2, name);
        }
        return name;
    }

    @Override
    public String getContributorName() {
        return this.fElement.getContributor().getName();
    }

    public String getSourceLocatorId() {
        return this.fElement.getAttribute("sourceLocatorId");
    }

    public String getSourcePathComputerId() {
        return this.fElement.getAttribute("sourcePathComputerId");
    }

    @Override
    public String getDescription() {
        String desc = this.fElement.getAttribute("delegateDescription");
        if (desc == null) {
            return DebugCoreMessages.LaunchDelegate_0;
        }
        return desc;
    }

    @Override
    public String getPluginIdentifier() {
        return this.fElement.getContributor().getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof ILaunchDelegate && this.getId() != null && this.getId().equals(((ILaunchDelegate)obj).getId());
    }

    public int hashCode() {
        String id = this.getId();
        return id == null ? 0 : id.hashCode();
    }

    @Override
    public String getPerspectiveId(Set<String> modes) {
        if (this.fPerspectiveIds == null) {
            this.getModes();
        }
        return this.fPerspectiveIds.get(modes);
    }
}

